/*
 * Decompiled with CFR 0.152.
 */
package rhino;

import java.util.Collections;
import java.util.Iterator;
import rhino.Context;
import rhino.ES6Iterator;
import rhino.Hashtable;
import rhino.Scriptable;
import rhino.ScriptableObject;

public class NativeCollectionIterator
extends ES6Iterator {
    private String className;
    private Type type;
    private transient Iterator<Hashtable.Entry> iterator;

    static void init(ScriptableObject scope, String tag, boolean sealed) {
        ES6Iterator.init(scope, sealed, new NativeCollectionIterator(tag), tag);
    }

    public NativeCollectionIterator(String tag) {
        this.className = tag;
        this.iterator = Collections.emptyIterator();
        this.type = Type.BOTH;
    }

    public NativeCollectionIterator(Scriptable scope, String className, Type type, Iterator<Hashtable.Entry> iterator) {
        super(scope, className);
        this.className = className;
        this.iterator = iterator;
        this.type = type;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    protected boolean isDone(Context cx, Scriptable scope) {
        return !this.iterator.hasNext();
    }

    @Override
    protected Object nextValue(Context cx, Scriptable scope) {
        Hashtable.Entry e = this.iterator.next();
        switch (this.type) {
            case KEYS: {
                return e.key;
            }
            case VALUES: {
                return e.value;
            }
            case BOTH: {
                return cx.newArray(scope, new Object[]{e.key, e.value});
            }
        }
        throw new AssertionError();
    }

    static enum Type {
        KEYS,
        VALUES,
        BOTH;

    }
}

