/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.meta;

import arc.struct.ObjectMap;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatCat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValue;
import mindustry.world.meta.StatValues;

public class Stats {
    public boolean useCategories = false;
    public boolean intialized = false;
    public float timePeriod = -1.0f;
    @Nullable
    private OrderedMap<StatCat, OrderedMap<Stat, Seq<StatValue>>> map;
    private boolean dirty;

    public void add(Stat stat, float value, StatUnit unit) {
        this.add(stat, StatValues.number(value, unit));
    }

    public void add(Stat stat, float value) {
        this.add(stat, value, StatUnit.none);
    }

    public void addPercent(Stat stat, float value) {
        this.add(stat, StatValues.number((int)(value * 100.0f), StatUnit.percent));
    }

    public void addMultModifier(Stat stat, float value) {
        this.add(stat, StatValues.multiplierModifier(value));
    }

    public void addPercentModifier(Stat stat, float value) {
        this.add(stat, StatValues.percentModifier(value));
    }

    public void add(Stat stat, boolean value) {
        this.add(stat, StatValues.bool(value));
    }

    public void add(Stat stat, Item item) {
        this.add(stat, StatValues.items(new ItemStack(item, 1)));
    }

    public void add(Stat stat, ItemStack item) {
        this.add(stat, StatValues.items(item));
    }

    public void add(Stat stat, Liquid liquid, float amount, boolean perSecond) {
        this.add(stat, StatValues.liquid(liquid, amount, perSecond));
    }

    public void add(Stat stat, Attribute attr) {
        this.add(stat, attr, false, 1.0f, false);
    }

    public void add(Stat stat, Attribute attr, float scale) {
        this.add(stat, attr, false, scale, false);
    }

    public void add(Stat stat, Attribute attr, boolean floating) {
        this.add(stat, attr, floating, 1.0f, false);
    }

    public void add(Stat stat, Attribute attr, boolean floating, float scale, boolean startZero) {
        this.add(stat, StatValues.blocks(attr, floating, scale, startZero));
    }

    public void add(Stat stat, String format, Object ... args) {
        this.add(stat, StatValues.string(format, args));
    }

    public void replace(Stat stat, StatValue value) {
        this.remove(stat);
        this.add(stat, value);
    }

    public void add(Stat stat, StatValue value) {
        if (this.map == null) {
            this.map = new OrderedMap();
        }
        if (!this.map.containsKey(stat.category)) {
            this.map.put(stat.category, new OrderedMap());
        }
        ((Seq)((Object)((OrderedMap)this.map.get(stat.category)).get(stat, Seq::new))).add(value);
        this.dirty = true;
    }

    public void remove(Stat stat) {
        if (this.map == null) {
            this.map = new OrderedMap();
        }
        if (!this.map.containsKey(stat.category)) {
            return;
        }
        ((OrderedMap)this.map.get(stat.category)).remove(stat);
        this.dirty = true;
    }

    public OrderedMap<StatCat, OrderedMap<Stat, Seq<StatValue>>> toMap() {
        if (this.map == null) {
            this.map = new OrderedMap();
        }
        if (this.dirty) {
            this.map.orderedKeys().sort();
            for (ObjectMap.Entry entry : this.map.entries()) {
                ((OrderedMap)entry.value).orderedKeys().sort();
            }
            this.dirty = false;
        }
        return this.map;
    }
}

