/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Eachable;
import arc.util.Time;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawWarmupRegion
extends DrawBlock {
    public float sinMag = 0.6f;
    public float sinScl = 8.0f;
    public Color color = Color.valueOf("ff9b59");
    public TextureRegion region;

    @Override
    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
    }

    @Override
    public void draw(Building build) {
        Draw.color(this.color);
        Draw.alpha(build.warmup() * (1.0f - this.sinMag) + Mathf.absin(Time.time, this.sinScl, this.sinMag) * build.warmup());
        Draw.rect(this.region, build.x, build.y);
        Draw.reset();
    }

    @Override
    public void load(Block block) {
        super.load(block);
        this.region = Core.atlas.find(block.name + "-top");
    }
}

