/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.util.Eachable;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawSideRegion
extends DrawBlock {
    public TextureRegion top1;
    public TextureRegion top2;

    @Override
    public void draw(Building build) {
        Draw.rect(build.rotation > 1 ? this.top2 : this.top1, build.x, build.y, build.rotdeg());
    }

    @Override
    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect(plan.rotation > 1 ? this.top2 : this.top1, plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
    }

    @Override
    public void load(Block block) {
        this.top1 = Core.atlas.find(block.name + "-top1");
        this.top2 = Core.atlas.find(block.name + "-top2");
    }

    @Override
    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.top1};
    }
}

