/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawFrames
extends DrawBlock {
    public int frames = 3;
    public float interval = 5.0f;
    public boolean sine = true;
    public TextureRegion[] regions;

    @Override
    public void draw(Building build) {
        Draw.rect(this.sine ? this.regions[(int)Mathf.absin(build.totalProgress(), this.interval, (float)this.frames - 0.001f)] : this.regions[(int)(build.totalProgress() / this.interval % (float)this.frames)], build.x, build.y);
    }

    @Override
    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{this.regions[0]};
    }

    @Override
    public void load(Block block) {
        this.regions = new TextureRegion[this.frames];
        for (int i = 0; i < this.frames; ++i) {
            this.regions[i] = Core.atlas.find(block.name + "-frame" + i);
        }
    }
}

