/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.func.Boolf;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Building;
import mindustry.type.PayloadSeq;
import mindustry.ui.MultiReqImage;
import mindustry.ui.ReqImage;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;
import mindustry.world.meta.Stats;

public class ConsumePayloadFilter
extends Consume {
    protected final UnlockableContent[] fitting;
    public Boolf<UnlockableContent> filter;

    public ConsumePayloadFilter(Boolf<UnlockableContent> filter) {
        this.filter = filter;
        this.fitting = (UnlockableContent[])Vars.content.blocks().copy().as().add(Vars.content.units().as()).select(filter).toArray(UnlockableContent.class);
    }

    @Override
    public float efficiency(Building build) {
        PayloadSeq payloads = build.getPayloads();
        for (UnlockableContent block : this.fitting) {
            if (!payloads.contains(block, 1)) continue;
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public void trigger(Building build) {
        PayloadSeq payloads = build.getPayloads();
        for (UnlockableContent block : this.fitting) {
            if (!payloads.contains(block, 1)) continue;
            payloads.remove(block);
            return;
        }
    }

    @Override
    public void display(Stats stats) {
        stats.add(this.booster ? Stat.booster : Stat.input, StatValues.content(new Seq<UnlockableContent>(this.fitting)));
    }

    @Override
    public void build(Building build, Table table) {
        PayloadSeq inv = build.getPayloads();
        MultiReqImage image = new MultiReqImage();
        Vars.content.blocks().each(i -> this.filter.get((UnlockableContent)i) && i.unlockedNow(), block -> image.add(new ReqImage((Element)StatValues.stack(block, 1), () -> inv.contains((UnlockableContent)block, 1))));
        table.add(image).size(32.0f);
    }
}

