/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.struct.ObjectFloatMap;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.world.consumers.ConsumeItemFilter;

public class ConsumeItemList
extends ConsumeItemFilter {
    public ObjectFloatMap<Item> itemMultipliers = new ObjectFloatMap();

    public ConsumeItemList(Item ... items) {
        this();
        for (Item i : items) {
            this.itemMultipliers.put(i, 1.0f);
        }
    }

    public ConsumeItemList() {
        this.filter = item -> this.itemMultipliers.containsKey((Item)item);
    }

    public void setMultipliers(Object ... objects) {
        for (int i = 0; i < objects.length; i += 2) {
            this.itemMultipliers.put((Item)objects[i], ((Float)objects[i + 1]).floatValue());
        }
    }

    @Override
    public float efficiencyMultiplier(Building build) {
        Item item = this.getConsumed(build);
        return this.itemMultipliers.get(item, 1.0f);
    }
}

