/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.production;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.meta.BlockStatus;

public class ItemIncinerator
extends Block {
    public Effect effect = Fx.incinerateSlag;
    public float effectChance = 0.2f;
    public TextureRegion liquidRegion;
    public TextureRegion topRegion;

    public ItemIncinerator(String name) {
        super(name);
        this.update = true;
        this.solid = true;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.topRegion};
    }

    public class ItemIncineratorBuild
    extends Building {
        @Override
        public void updateTile() {
        }

        @Override
        public BlockStatus status() {
            return !this.enabled ? BlockStatus.logicDisable : (this.efficiency > 0.0f ? BlockStatus.active : BlockStatus.noInput);
        }

        @Override
        public void draw() {
            super.draw();
            if (ItemIncinerator.this.liquidRegion.found()) {
                Drawf.liquid(ItemIncinerator.this.liquidRegion, this.x, this.y, this.liquids.currentAmount() / ItemIncinerator.this.liquidCapacity, this.liquids.current().color);
            }
            if (ItemIncinerator.this.topRegion.found()) {
                Draw.rect(ItemIncinerator.this.topRegion, this.x, this.y);
            }
        }

        @Override
        public void handleItem(Building source, Item item) {
            if (Mathf.chance(ItemIncinerator.this.effectChance)) {
                ItemIncinerator.this.effect.at(this.x, this.y);
            }
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.efficiency > 0.0f;
        }
    }
}

