/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.scene.style.TextureRegionDrawable;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.core.World;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.EntityCollisions;
import mindustry.entities.Units;
import mindustry.game.EventType;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.Unit;
import mindustry.type.ItemStack;
import mindustry.world.blocks.payloads.Payload;

public class UnitPayload
implements Payload {
    public static final float overlayDuration = 40.0f;
    public Unit unit;
    public float overlayTime = 0.0f;
    @Nullable
    public TextureRegion overlayRegion;

    public UnitPayload(Unit unit) {
        this.unit = unit;
    }

    public void showOverlay(TextureRegion icon) {
        this.overlayRegion = icon;
        this.overlayTime = 1.0f;
    }

    public void showOverlay(TextureRegionDrawable icon) {
        if (icon == null || Vars.headless) {
            return;
        }
        this.showOverlay(icon.getRegion());
    }

    @Override
    public void update(@Nullable Unit unitHolder, @Nullable Building buildingHolder) {
        this.unit.type.updatePayload(this.unit, unitHolder, buildingHolder);
    }

    @Override
    public UnlockableContent content() {
        return this.unit.type;
    }

    @Override
    public ItemStack[] requirements() {
        return this.unit.type.getTotalRequirements();
    }

    @Override
    public float buildTime() {
        return this.unit.type.getBuildTime();
    }

    @Override
    public void write(Writes write) {
        write.b(0);
        write.b(this.unit.classId());
        this.unit.write(write);
    }

    @Override
    public void set(float x, float y, float rotation) {
        this.unit.set(x, y);
        this.unit.rotation = rotation;
    }

    @Override
    public float x() {
        return this.unit.x;
    }

    @Override
    public float y() {
        return this.unit.y;
    }

    @Override
    public float rotation() {
        return this.unit.rotation;
    }

    @Override
    public float size() {
        return this.unit.hitSize;
    }

    @Override
    public boolean dump() {
        if (this.unit.type == null) {
            return true;
        }
        if (!Units.canCreate(this.unit.team, this.unit.type)) {
            this.overlayTime = 1.0f;
            this.overlayRegion = null;
            return false;
        }
        EntityCollisions.SolidPred solid = this.unit.solidity();
        if (solid != null) {
            Tmp.v1.trns(this.unit.rotation, 1.0f);
            int tx = World.toTile(this.unit.x + Tmp.v1.x);
            int ty = World.toTile(this.unit.y + Tmp.v1.y);
            if (solid.solid(tx, ty)) {
                return false;
            }
        }
        if (!this.unit.type.flying && Units.count(this.unit.x, this.unit.y, this.unit.physicSize() * 1.05f, o -> o.isGrounded() && o.type.allowLegStep == this.unit.type.allowLegStep) > 0) {
            return false;
        }
        if (Vars.net.client()) {
            return true;
        }
        this.unit.vel.add(Mathf.range(0.5f), Mathf.range(0.5f));
        this.unit.add();
        this.unit.unloaded();
        Events.fire(new EventType.UnitUnloadEvent(this.unit));
        Units.notifyUnitSpawn(this.unit);
        return true;
    }

    @Override
    public void drawShadow(float alpha) {
        if (this.unit.type == null) {
            return;
        }
        this.unit.type.drawSoftShadow(this.unit, alpha);
    }

    @Override
    public void draw() {
        if (this.unit.type == null) {
            return;
        }
        float e = this.unit.elevation;
        this.unit.elevation = 0.0f;
        Draw.scl(1.0f, 1.0f);
        this.unit.type.draw(this.unit);
        this.unit.elevation = e;
        if (this.overlayTime > 0.0f) {
            float z = Draw.z();
            Draw.z(61.0f);
            TextureRegion region = this.overlayRegion == null ? Icon.warning.getRegion() : this.overlayRegion;
            Draw.color(Color.scarlet);
            Draw.alpha(0.8f * Interp.exp5Out.apply(this.overlayTime));
            float size = 8.0f;
            Draw.rect(region, this.unit.x, this.unit.y, size, size);
            Draw.reset();
            this.overlayTime = Math.max(this.overlayTime - Time.delta / 40.0f, 0.0f);
            Draw.z(z);
        }
    }

    @Override
    public TextureRegion icon() {
        return this.unit.type.fullIcon;
    }
}

