/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.math.geom.Position;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.PayloadLoader;

public class PayloadUnloader
extends PayloadLoader {
    public int offloadSpeed = 4;
    public float maxPowerUnload = 80.0f;

    public PayloadUnloader(String name) {
        super(name);
        this.outputsPower = true;
        this.consumesPower = true;
        this.outputsLiquid = true;
        this.loadPowerDynamic = false;
        this.canOverdrive = false;
    }

    @Override
    public boolean outputsItems() {
        return true;
    }

    @Override
    public boolean rotatedOutput(int x, int y) {
        return false;
    }

    public class PayloadUnloaderBuild
    extends PayloadLoader.PayloadLoaderBuild {
        public float lastOutputPower = 0.0f;

        @Override
        public boolean acceptItem(Building source, Item item) {
            return false;
        }

        @Override
        public boolean acceptLiquid(Building source, Liquid liquid) {
            return false;
        }

        @Override
        public float getPowerProduction() {
            return this.lastOutputPower;
        }

        @Override
        public void updateTile() {
            if (this.payload != null) {
                ((BuildPayload)this.payload).update(null, this);
            }
            this.lastOutputPower = 0.0f;
            if (this.shouldExport()) {
                if (((BuildPayload)this.payload).block().instantDeconstruct) {
                    ((BuildPayload)this.payload).block().breakEffect.at((Position)this, (float)((BuildPayload)this.payload).block().size);
                    this.payload = null;
                } else {
                    this.moveOutPayload();
                }
            } else if (this.moveInPayload()) {
                if (((BuildPayload)this.payload).block().hasItems && !this.full() && this.efficiency > 0.01f && this.timer(PayloadUnloader.this.timerLoad, PayloadUnloader.this.loadTime / this.efficiency)) {
                    block0: for (int j = 0; j < PayloadUnloader.this.itemsLoaded && !this.full(); ++j) {
                        for (int i = 0; i < this.items.length(); ++i) {
                            if (((BuildPayload)this.payload).build.items.get(i) <= 0) continue;
                            Item item = Vars.content.item(i);
                            ((BuildPayload)this.payload).build.items.remove(item, 1);
                            this.items.add(item, 1);
                            continue block0;
                        }
                    }
                }
                if (((BuildPayload)this.payload).block().hasLiquids && ((BuildPayload)this.payload).build.liquids.currentAmount() >= 0.01f && (this.liquids.current() == ((BuildPayload)this.payload).build.liquids.current() || this.liquids.currentAmount() <= 0.2f)) {
                    Liquid liq = ((BuildPayload)this.payload).build.liquids.current();
                    float remaining = PayloadUnloader.this.liquidCapacity - this.liquids.currentAmount();
                    float flow = Math.min(Math.min(PayloadUnloader.this.liquidsLoaded * this.edelta(), remaining), ((BuildPayload)this.payload).build.liquids.currentAmount());
                    this.liquids.add(liq, flow);
                    ((BuildPayload)this.payload).build.liquids.remove(liq, flow);
                }
                if (this.hasBattery()) {
                    float unloaded;
                    float cap = ((BuildPayload)this.payload).block().consPower.capacity;
                    float total = ((BuildPayload)this.payload).build.power.status * cap;
                    this.lastOutputPower = unloaded = Math.min(PayloadUnloader.this.maxPowerUnload * this.edelta(), total);
                    ((BuildPayload)this.payload).build.power.status -= unloaded / cap;
                }
            }
            this.dumpLiquid(this.liquids.current());
            for (int i = 0; i < PayloadUnloader.this.offloadSpeed; ++i) {
                this.dumpAccumulate();
            }
        }

        public boolean full() {
            return this.items.total() >= PayloadUnloader.this.itemCapacity;
        }

        @Override
        public boolean shouldExport() {
            return !(this.payload == null || ((BuildPayload)this.payload).block().hasItems && !((BuildPayload)this.payload).build.items.empty() || ((BuildPayload)this.payload).block().hasLiquids && !(((BuildPayload)this.payload).build.liquids.currentAmount() <= 0.011f) || this.hasBattery() && !(((BuildPayload)this.payload).build.power.status <= 1.0E-7f));
        }
    }
}

