/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Intersector;
import arc.math.geom.Rect;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ctype.Content;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadBlock;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValues;

public class PayloadConveyor
extends Block {
    public float moveTime = 45.0f;
    public float moveForce = 201.0f;
    public TextureRegion topRegion;
    public TextureRegion edgeRegion;
    public Interp interp = Interp.pow5;
    public float payloadLimit = 3.0f;
    public boolean pushUnits = true;

    public PayloadConveyor(String name) {
        super(name);
        this.group = BlockGroup.payloads;
        this.size = 3;
        this.rotate = true;
        this.update = true;
        this.outputsPayload = true;
        this.noUpdateDisabled = true;
        this.acceptsUnitPayloads = true;
        this.priority = -1.0f;
        this.envEnabled |= 6;
        this.sync = true;
        this.underBullets = true;
    }

    @Override
    protected TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find(this.name + "-icon")};
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        int ntrns = this.size;
        for (int i = 0; i < 4; ++i) {
            Tile tile = Vars.world.tile(x + Geometry.d4x[i] * ntrns, y + Geometry.d4y[i] * ntrns);
            if (tile == null || tile.build == null || !tile.isCenter() || !tile.build.block.outputsPayload || tile.build.block.size != this.size || i != rotation && (!tile.block().rotate || i != (tile.build.rotation + 2) % 4)) continue;
            Drawf.selected(tile.x, tile.y, tile.block(), tile.build.team.color);
        }
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.payloadCapacity, StatValues.squared(this.payloadLimit, StatUnit.blocksSquared));
    }

    @Override
    public void init() {
        super.init();
        this.clipSize = Math.max(this.clipSize, (float)(this.size * 8) * 2.1f);
    }

    public class PayloadConveyorBuild
    extends Building {
        @Nullable
        public Payload item;
        public float progress;
        public float itemRotation;
        public float animation;
        public float curInterp;
        public float lastInterp;
        @Nullable
        public Building next;
        public boolean blocked;
        public int step = -1;
        public int stepAccepted = -1;

        @Override
        public boolean canControlSelect(Unit unit) {
            return this.item == null && unit.type.allowedInPayloads && !unit.spawnedByCore && unit.hitSize / 8.0f <= PayloadConveyor.this.payloadLimit && unit.tileOn() != null && unit.tileOn().build == this;
        }

        @Override
        public void onControlSelect(Unit player) {
            this.handleUnitPayload(player, p -> {
                this.item = p;
            });
        }

        @Override
        public Payload takePayload() {
            Payload t = this.item;
            this.item = null;
            return t;
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            Building accept = this.nearby(Geometry.d4((int)this.rotation).x * (PayloadConveyor.this.size / 2 + 1), Geometry.d4((int)this.rotation).y * (PayloadConveyor.this.size / 2 + 1));
            this.next = accept != null && (accept.block.size == PayloadConveyor.this.size && this.tileX() + Geometry.d4((int)this.rotation).x * PayloadConveyor.this.size == accept.tileX() && this.tileY() + Geometry.d4((int)this.rotation).y * PayloadConveyor.this.size == accept.tileY() || accept.block.size > PayloadConveyor.this.size && (this.rotation % 2 == 0 ? Math.abs(accept.y - this.y) <= (float)(accept.block.size * 8 - PayloadConveyor.this.size * 8) / 2.0f : Math.abs(accept.x - this.x) <= (float)(accept.block.size * 8 - PayloadConveyor.this.size * 8) / 2.0f)) ? accept : null;
            int ntrns = 1 + PayloadConveyor.this.size / 2;
            Tile next = this.tile.nearby(Geometry.d4((int)this.rotation).x * ntrns, Geometry.d4((int)this.rotation).y * ntrns);
            this.blocked = next != null && next.solid() && !next.block().outputsPayload && !next.block().acceptsPayload || this.next != null && this.next.payloadCheck(this.rotation);
        }

        @Override
        public Payload getPayload() {
            return this.item;
        }

        @Override
        public void updateTile() {
            int curStep;
            if (!this.enabled) {
                return;
            }
            if (this.item != null) {
                this.item.update(null, this);
            }
            this.lastInterp = this.curInterp;
            this.curInterp = this.fract();
            if (this.lastInterp > this.curInterp) {
                this.lastInterp = 0.0f;
            }
            this.progress = this.time() % PayloadConveyor.this.moveTime;
            this.updatePayload();
            if (this.item != null && this.next == null) {
                PayloadBlock.pushOutput(this.item, this.progress / PayloadConveyor.this.moveTime);
            }
            if ((curStep = this.curStep()) > this.step) {
                boolean had;
                boolean valid = this.step != -1;
                this.step = curStep;
                boolean bl = had = this.item != null;
                if (valid && this.stepAccepted != curStep && this.item != null) {
                    if (this.next != null) {
                        this.next.updateTile();
                        if (this.next != null && this.next.acceptPayload(this, this.item)) {
                            this.next.handlePayload(this, this.item);
                            this.item = null;
                            this.moved();
                        }
                    } else if (!this.blocked && this.item.dump()) {
                        this.item = null;
                        this.moved();
                    }
                }
                if (had && this.item != null) {
                    this.moveFailed();
                }
            }
        }

        public void moveFailed() {
        }

        public void moved() {
        }

        public void drawBottom() {
            super.draw();
        }

        @Override
        public void onDestroyed() {
            if (this.item != null) {
                this.item.destroyed();
            }
            super.onDestroyed();
        }

        @Override
        public void draw() {
            int i;
            super.draw();
            float dst = 0.8f;
            float glow = Math.max((dst - Math.abs(this.fract() - 0.5f) * 2.0f) / dst, 0.0f);
            Draw.mixcol(this.team.color, glow);
            float s = 8 * PayloadConveyor.this.size;
            float trnext = s * this.fract();
            float trprev = s * (this.fract() - 1.0f);
            float rot = this.rotdeg();
            TextureRegion clipped = this.clipRegion(this.tile.getHitbox(Tmp.r1), this.tile.getHitbox(Tmp.r2).move(trnext, 0.0f), PayloadConveyor.this.topRegion);
            float widthNext = (s - (float)clipped.width * clipped.scl()) * 0.5f;
            float heightNext = (s - (float)clipped.height * clipped.scl()) * 0.5f;
            Tmp.v1.set(widthNext, heightNext).rotate(rot);
            Draw.rect(clipped, this.x + Tmp.v1.x, this.y + Tmp.v1.y, rot);
            clipped = this.clipRegion(this.tile.getHitbox(Tmp.r1), this.tile.getHitbox(Tmp.r2).move(trprev, 0.0f), PayloadConveyor.this.topRegion);
            float widthPrev = ((float)clipped.width * clipped.scl() - s) * 0.5f;
            float heightPrev = ((float)clipped.height * clipped.scl() - s) * 0.5f;
            Tmp.v1.set(widthPrev, heightPrev).rotate(rot);
            Draw.rect(clipped, this.x + Tmp.v1.x, this.y + Tmp.v1.y, rot);
            for (i = 0; i < 4; ++i) {
                if (!this.blends(i) || i == this.rotation) continue;
                Draw.alpha(1.0f - Interp.pow5In.apply(this.fract()));
                Tmp.v1.set(widthPrev, heightPrev).rotate(i * 90 + 180);
                Draw.rect(clipped, this.x + Tmp.v1.x, this.y + Tmp.v1.y, (float)(i * 90 + 180));
            }
            Draw.reset();
            for (i = 0; i < 4; ++i) {
                if (this.blends(i)) continue;
                Draw.rect(PayloadConveyor.this.edgeRegion, this.x, this.y, (float)(i * 90));
            }
            Draw.z(35.0f);
            if (this.item != null) {
                this.item.draw();
            }
        }

        @Override
        public void payloadDraw() {
            Draw.rect(this.block.fullIcon, this.x, this.y);
        }

        public float time() {
            return Time.time;
        }

        @Override
        public void unitOn(Unit unit) {
            if (!PayloadConveyor.this.pushUnits || !this.enabled) {
                return;
            }
            float delta = (this.curInterp - this.lastInterp) * (float)PayloadConveyor.this.size * 8.0f;
            Tmp.v1.trns(this.rotdeg(), delta * PayloadConveyor.this.moveForce).scl(1.0f / Math.max(unit.mass(), 201.0f));
            unit.move(Tmp.v1.x, Tmp.v1.y);
        }

        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            return this.item == null && payload.fits(PayloadConveyor.this.payloadLimit) && (source == this || this.enabled && this.progress <= 5.0f);
        }

        @Override
        public void handlePayload(Building source, Payload payload) {
            this.item = payload;
            this.stepAccepted = this.curStep();
            this.itemRotation = source == this ? this.rotdeg() : source.angleTo(this);
            this.animation = 0.0f;
            this.updatePayload();
        }

        @Override
        public double sense(Content content) {
            Payload payload = this.item;
            if (payload instanceof UnitPayload) {
                UnitPayload up = (UnitPayload)payload;
                if (up.unit.type == content) {
                    return 1.0;
                }
            }
            if ((payload = this.item) instanceof BuildPayload) {
                BuildPayload bp = (BuildPayload)payload;
                if (bp.build.block == content) {
                    return 1.0;
                }
            }
            return super.sense(content);
        }

        @Override
        public void onRemoved() {
            super.onRemoved();
            if (this.item != null) {
                this.item.dump();
            }
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.progress);
            write.f(this.itemRotation);
            Payload.write(this.item, write);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            read.f();
            this.itemRotation = read.f();
            this.item = Payload.read(read);
        }

        public void updatePayload() {
            if (this.item != null) {
                if (this.animation > this.fract()) {
                    this.animation = Mathf.lerp(this.animation, 0.8f, 0.15f);
                }
                float fract = this.animation = Math.max(this.animation, this.fract());
                float rot = Mathf.slerp(this.itemRotation, this.rotdeg(), fract);
                if (fract < 0.5f) {
                    Tmp.v1.trns(this.itemRotation + 180.0f, (0.5f - fract) * 8.0f * (float)PayloadConveyor.this.size);
                } else {
                    Tmp.v1.trns(this.rotdeg(), (fract - 0.5f) * 8.0f * (float)PayloadConveyor.this.size);
                }
                float vx = Tmp.v1.x;
                float vy = Tmp.v1.y;
                this.item.set(this.x + vx, this.y + vy, rot);
            }
        }

        protected boolean blends(int direction) {
            if (direction == this.rotation) {
                return !this.blocked || this.next != null;
            }
            return PayloadBlock.blends(this, direction);
        }

        protected TextureRegion clipRegion(Rect bounds, Rect sprite, TextureRegion region) {
            Rect over = Tmp.r3;
            boolean overlaps = Intersector.intersectRectangles(bounds, sprite, over);
            TextureRegion out = Tmp.tr1;
            out.set(region.texture);
            out.scale = region.scale;
            if (overlaps) {
                float w = region.u2 - region.u;
                float h = region.v2 - region.v;
                float x = region.u;
                float y = region.v;
                float newX = (over.x - sprite.x) / sprite.width * w + x;
                float newY = (over.y - sprite.y) / sprite.height * h + y;
                float newW = over.width / sprite.width * w;
                float newH = over.height / sprite.height * h;
                out.set(newX, newY, newX + newW, newY + newH);
            } else {
                out.set(0.0f, 0.0f, 0.0f, 0.0f);
            }
            return out;
        }

        public int curStep() {
            return (int)(this.time() / PayloadConveyor.this.moveTime);
        }

        public float fract() {
            return PayloadConveyor.this.interp.apply(this.progress / PayloadConveyor.this.moveTime);
        }
    }
}

