/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.logic;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Bresenham2;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.style.Drawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.IntIntMap;
import arc.struct.IntSeq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.logic.LExecutor;
import mindustry.logic.LReadable;
import mindustry.logic.LVar;
import mindustry.logic.LWritable;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;

public class CanvasBlock
extends Block {
    public float padding = 0.0f;
    public int canvasSize = 8;
    public int[] palette = new int[]{908674303, -1000497153, -476402433, -254103041, 1684128511, 732542207, -1814776321, -252253953};
    public int bitsPerPixel;
    public IntIntMap colorToIndex = new IntIntMap();
    public TextureRegion side1;
    public TextureRegion side2;
    public TextureRegion corner1;
    public TextureRegion corner2;
    @Nullable
    protected Pixmap previewPixmap;
    @Nullable
    protected Texture previewTexture;
    protected int tempBlend = 0;

    public CanvasBlock(String name) {
        super(name);
        this.configurable = true;
        this.destructible = true;
        this.canOverdrive = false;
        this.solid = true;
        this.config(byte[].class, (build, bytes) -> {
            if (build.data.length == ((byte[])bytes).length) {
                System.arraycopy(bytes, 0, build.data, 0, ((byte[])bytes).length);
                build.updateTexture();
            }
        });
    }

    @Override
    public void init() {
        super.init();
        for (int i = 0; i < this.palette.length; ++i) {
            this.colorToIndex.put(this.palette[i], i);
        }
        this.bitsPerPixel = Mathf.log2(Mathf.nextPowerOfTwo(this.palette.length));
        this.clipSize = Math.max(this.clipSize, (float)(this.size * 8) - this.padding);
        this.previewPixmap = new Pixmap(this.canvasSize, this.canvasSize);
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Object object;
        if (!plan.worldContext && (object = plan.config) instanceof byte[]) {
            byte[] data = (byte[])object;
            Pixmap pix = this.makePixmap(data, this.previewPixmap);
            if (this.previewTexture == null) {
                this.previewTexture = new Texture(pix);
            } else {
                this.previewTexture.draw(pix);
            }
            this.tempBlend = 0;
            list.each(other -> {
                if (other.block == this) {
                    for (int i = 0; i < 4; ++i) {
                        if (other.x != plan.x + Geometry.d4x(i) * this.size || other.y != plan.y + Geometry.d4y(i) * this.size) continue;
                        this.tempBlend |= 1 << i;
                    }
                }
            });
            int blending = this.tempBlend;
            float x = plan.drawx();
            float y = plan.drawy();
            Tmp.tr1.set(this.previewTexture);
            float pad = blending == 0 ? this.padding : 0.0f;
            Draw.rect(Tmp.tr1, x, y, (float)(this.size * 8) - pad, (float)(this.size * 8) - pad);
            Draw.flush();
            for (int i = 0; i < 4; ++i) {
                if ((blending & 1 << i) != 0) continue;
                Draw.rect(i >= 2 ? this.side2 : this.side1, x, y, (float)(i * 90));
                if ((blending & 1 << (i + 1) % 4) != 0) {
                    Draw.rect(i >= 2 ? this.corner2 : this.corner1, x, y, (float)(i * 90));
                }
                if ((blending & 1 << Mathf.mod(i - 1, 4)) == 0) continue;
                Draw.yscl = -1.0f;
                Draw.rect(i >= 2 ? this.corner2 : this.corner1, x, y, (float)(i * 90));
                Draw.yscl = 1.0f;
            }
        } else {
            super.drawPlanRegion(plan, list);
        }
    }

    public Pixmap makePixmap(byte[] data, Pixmap target) {
        int bpp = this.bitsPerPixel;
        int pixels = this.canvasSize * this.canvasSize;
        for (int i = 0; i < pixels; ++i) {
            int bitOffset = i * bpp;
            int pal = this.getByte(data, bitOffset);
            target.set(i % this.canvasSize, i / this.canvasSize, this.palette[pal]);
        }
        return target;
    }

    protected int getByte(byte[] data, int bitOffset) {
        int result = 0;
        int bpp = this.bitsPerPixel;
        for (int i = 0; i < bpp; ++i) {
            int word = i + bitOffset >>> 3;
            result |= ((data[word] & 1 << (i + bitOffset & 7)) == 0 ? 0 : 1) << i;
        }
        return result;
    }

    public class CanvasBuild
    extends Building
    implements LReadable,
    LWritable {
        @Nullable
        public Texture texture;
        public byte[] data;
        public int blending;
        protected boolean updated;

        public CanvasBuild() {
            this.data = new byte[Mathf.ceil((float)(CanvasBlock.this.canvasSize * CanvasBlock.this.canvasSize * CanvasBlock.this.bitsPerPixel) / 8.0f)];
            this.updated = false;
        }

        public void setPixel(int pos, int index) {
            if (pos < CanvasBlock.this.canvasSize * CanvasBlock.this.canvasSize && pos >= 0 && index >= 0 && index < CanvasBlock.this.palette.length) {
                this.setByte(this.data, pos * CanvasBlock.this.bitsPerPixel, index);
                this.updated = true;
            }
        }

        public void setPixel(int x, int y, int index) {
            if (x >= 0 && y >= 0 && x < CanvasBlock.this.canvasSize && y < CanvasBlock.this.canvasSize && index >= 0 && index < CanvasBlock.this.palette.length) {
                this.setByte(this.data, (y * CanvasBlock.this.canvasSize + x) * CanvasBlock.this.bitsPerPixel, index);
                this.updated = true;
            }
        }

        public double getPixel(int pos) {
            if (pos >= 0 && pos < CanvasBlock.this.canvasSize * CanvasBlock.this.canvasSize) {
                return CanvasBlock.this.getByte(this.data, pos * CanvasBlock.this.bitsPerPixel);
            }
            return Double.NaN;
        }

        public int getPixel(int x, int y) {
            if (x >= 0 && y >= 0 && x < CanvasBlock.this.canvasSize && y < CanvasBlock.this.canvasSize) {
                return CanvasBlock.this.getByte(this.data, (y * CanvasBlock.this.canvasSize + x) * CanvasBlock.this.bitsPerPixel);
            }
            return 0;
        }

        public void updateTexture() {
            if (Vars.headless) {
                return;
            }
            Pixmap pix = CanvasBlock.this.makePixmap(this.data, CanvasBlock.this.previewPixmap);
            if (this.texture != null) {
                this.texture.draw(pix);
            } else {
                this.texture = new Texture(pix);
            }
        }

        public byte[] packPixmap(Pixmap pixmap) {
            byte[] bytes = new byte[this.data.length];
            int pixels = CanvasBlock.this.canvasSize * CanvasBlock.this.canvasSize;
            for (int i = 0; i < pixels; ++i) {
                int color = pixmap.get(i % CanvasBlock.this.canvasSize, i / CanvasBlock.this.canvasSize);
                int palIndex = CanvasBlock.this.colorToIndex.get(color);
                this.setByte(bytes, i * CanvasBlock.this.bitsPerPixel, palIndex);
            }
            return bytes;
        }

        protected void setByte(byte[] bytes, int bitOffset, int value) {
            int bpp = CanvasBlock.this.bitsPerPixel;
            for (int i = 0; i < bpp; ++i) {
                int word = i + bitOffset >>> 3;
                if ((value >>> i & 1) == 0) {
                    int n = word;
                    bytes[n] = (byte)(bytes[n] & ~(1 << (i + bitOffset & 7)));
                    continue;
                }
                int n = word;
                bytes[n] = (byte)(bytes[n] | 1 << (i + bitOffset & 7));
            }
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            this.blending = 0;
            for (int i = 0; i < 4; ++i) {
                if (!this.blends(Vars.world.tile(this.tile.x + Geometry.d4[i].x * CanvasBlock.this.size, this.tile.y + Geometry.d4[i].y * CanvasBlock.this.size))) continue;
                this.blending |= 1 << i;
            }
        }

        @Override
        public boolean readable(LExecutor exec) {
            return this.isValid() && (exec.privileged || this.team == exec.team);
        }

        @Override
        public void read(LVar position, LVar output) {
            output.setnum(this.getPixel(position.numi()));
        }

        @Override
        public boolean writable(LExecutor exec) {
            return this.readable(exec);
        }

        @Override
        public void write(LVar position, LVar value) {
            this.setPixel(position.numi(), value.numi());
        }

        boolean blends(Tile other) {
            return other != null && other.build != null && other.build.block == this.block && other.build.tileX() == other.x && other.build.tileY() == other.y;
        }

        @Override
        public void draw() {
            if (!Vars.renderer.drawDisplays) {
                super.draw();
                return;
            }
            if (this.blending == 0) {
                super.draw();
            }
            if (this.texture == null || this.updated) {
                this.updated = false;
                this.updateTexture();
            }
            Tmp.tr1.set(this.texture);
            float pad = this.blending == 0 ? CanvasBlock.this.padding : 0.0f;
            Draw.rect(Tmp.tr1, this.x, this.y, (float)(CanvasBlock.this.size * 8) - pad, (float)(CanvasBlock.this.size * 8) - pad);
            for (int i = 0; i < 4; ++i) {
                if ((this.blending & 1 << i) != 0) continue;
                Draw.rect(i >= 2 ? CanvasBlock.this.side2 : CanvasBlock.this.side1, this.x, this.y, (float)(i * 90));
                if ((this.blending & 1 << (i + 1) % 4) != 0) {
                    Draw.rect(i >= 2 ? CanvasBlock.this.corner2 : CanvasBlock.this.corner1, this.x, this.y, (float)(i * 90));
                }
                if ((this.blending & 1 << Mathf.mod(i - 1, 4)) == 0) continue;
                Draw.yscl = -1.0f;
                Draw.rect(i >= 2 ? CanvasBlock.this.corner2 : CanvasBlock.this.corner1, this.x, this.y, (float)(i * 90));
                Draw.yscl = 1.0f;
            }
        }

        @Override
        public double sense(LAccess sensor) {
            double d;
            switch (sensor) {
                case displayWidth: 
                case displayHeight: {
                    d = CanvasBlock.this.canvasSize;
                    break;
                }
                default: {
                    d = super.sense(sensor);
                }
            }
            return d;
        }

        @Override
        public void remove() {
            super.remove();
            if (this.texture != null) {
                this.texture.dispose();
                this.texture = null;
            }
        }

        @Override
        public void buildConfiguration(Table table) {
            table.button((Drawable)Icon.pencil, Styles.cleari, () -> {
                Dialog dialog = new Dialog();
                final Pixmap pix = CanvasBlock.this.makePixmap(this.data, new Pixmap(CanvasBlock.this.canvasSize, CanvasBlock.this.canvasSize));
                final Texture texture = new Texture(pix);
                final int[] curColor = new int[]{CanvasBlock.this.palette[0]};
                final boolean[] modified = new boolean[]{false};
                final boolean[] fill = new boolean[]{false};
                dialog.hidden(() -> {
                    texture.dispose();
                    pix.dispose();
                });
                dialog.resized(dialog::hide);
                dialog.cont.table(Tex.pane, body -> body.add(new Element(){
                    int lastX;
                    int lastY;
                    IntSeq stack = new IntSeq();
                    {
                        this.addListener(new InputListener(){

                            @Override
                            public boolean touchDown(InputEvent event, float ex, float ey, int pointer, KeyCode button) {
                                int cx = this.convertX(ex);
                                int cy = this.convertY(ey);
                                if (fill[0]) {
                                    stack.clear();
                                    int src = curColor[0];
                                    int dst = pix.get(cx, cy);
                                    if (src != dst) {
                                        stack.add(Point2.pack(cx, cy));
                                        while (!stack.isEmpty()) {
                                            int current = stack.pop();
                                            short x = Point2.x(current);
                                            short y = Point2.y(current);
                                            this.draw(x, y);
                                            for (int i = 0; i < 4; ++i) {
                                                int nx = x + Geometry.d4x(i);
                                                int ny = y + Geometry.d4y(i);
                                                if (nx < 0 || ny < 0 || nx >= pix.width || ny >= pix.height || pix.getRaw(nx, ny) != dst) continue;
                                                stack.add(Point2.pack(nx, ny));
                                            }
                                        }
                                    }
                                } else {
                                    this.draw(cx, cy);
                                    lastX = cx;
                                    lastY = cy;
                                }
                                return true;
                            }

                            @Override
                            public void touchDragged(InputEvent event, float ex, float ey, int pointer) {
                                if (fill[0]) {
                                    return;
                                }
                                int cx = this.convertX(ex);
                                int cy = this.convertY(ey);
                                Bresenham2.line(lastX, lastY, cx, cy, (x, y) -> this.draw(x, y));
                                lastX = cx;
                                lastY = cy;
                            }
                        });
                    }

                    int convertX(float ex) {
                        return (int)(ex / (this.width / (float)CanvasBlock.this.canvasSize));
                    }

                    int convertY(float ey) {
                        return pix.height - 1 - (int)(ey / (this.height / (float)CanvasBlock.this.canvasSize));
                    }

                    void draw(int x, int y) {
                        if (pix.get(x, y) != curColor[0]) {
                            pix.set(x, y, curColor[0]);
                            Pixmaps.drawPixel(texture, x, y, curColor[0]);
                            modified[0] = true;
                        }
                    }

                    @Override
                    public void draw() {
                        Tmp.tr1.set(texture);
                        Draw.alpha(this.parentAlpha);
                        Draw.rect(Tmp.tr1, this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.width, this.height);
                        float xspace = this.getWidth() / (float)CanvasBlock.this.canvasSize;
                        float yspace = this.getHeight() / (float)CanvasBlock.this.canvasSize;
                        float s = 1.0f;
                        int minspace = 10;
                        int jumpx = (int)(Math.max((float)minspace, xspace) / xspace);
                        int jumpy = (int)(Math.max((float)minspace, yspace) / yspace);
                        for (int x = 0; x <= CanvasBlock.this.canvasSize; x += jumpx) {
                            Fill.crect((int)(this.x + xspace * (float)x - s), this.y - s, 2.0f, this.getHeight() + (float)(x == CanvasBlock.this.canvasSize ? 1 : 0));
                        }
                        for (int y = 0; y <= CanvasBlock.this.canvasSize; y += jumpy) {
                            Fill.crect(this.x - s, (int)(this.y + (float)y * yspace - s), this.getWidth(), 2.0f);
                        }
                        if (!Vars.mobile) {
                            Vec2 s2 = this.screenToLocalCoordinates(Core.input.mouse());
                            if (s2.x >= 0.0f && s2.y >= 0.0f && s2.x < this.width && s2.y < this.height) {
                                float sx = Mathf.round(s2.x, this.width / (float)CanvasBlock.this.canvasSize);
                                float sy = Mathf.round(s2.y, this.height / (float)CanvasBlock.this.canvasSize);
                                Lines.stroke(Scl.scl(6.0f));
                                Draw.color(Pal.accent);
                                Lines.rect(sx + this.x, sy + this.y, this.width / (float)CanvasBlock.this.canvasSize, this.height / (float)CanvasBlock.this.canvasSize, Lines.getStroke() - 1.0f);
                                Draw.reset();
                            }
                        }
                    }
                }).size(Vars.mobile && !Core.graphics.isPortrait() ? Math.min(290.0f, (float)Core.graphics.getHeight() / Scl.scl(1.0f) - 75.0f / Scl.scl(1.0f)) : 480.0f)).colspan(3);
                dialog.cont.row();
                dialog.cont.add().size(60.0f);
                dialog.cont.table(Tex.button, p -> {
                    for (int i = 0; i < CanvasBlock.this.palette.length; ++i) {
                        int fi = i;
                        ImageButton button = p.button(Tex.whiteui, Styles.squareTogglei, 30.0f, () -> {
                            curColor[0] = CanvasBlock.this.palette[fi];
                        }).size(44.0f).checked(b -> curColor[0] == CanvasBlock.this.palette[fi]).get();
                        button.getStyle().imageUpColor = new Color(CanvasBlock.this.palette[i]);
                    }
                });
                dialog.cont.table(Tex.button, t -> t.button((Drawable)Icon.fill, Styles.clearNoneTogglei, () -> {
                    fill[0] = !fill[0];
                }).size(44.0f));
                dialog.closeOnBack();
                dialog.buttons.defaults().size(150.0f, 64.0f);
                dialog.buttons.button("@cancel", Icon.cancel, dialog::hide);
                dialog.buttons.button("@ok", Icon.ok, () -> {
                    if (modified[0]) {
                        this.configure(this.packPixmap(pix));
                    }
                    dialog.hide();
                });
                dialog.show();
            }).size(40.0f);
        }

        @Override
        public boolean onConfigureBuildTapped(Building other) {
            if (this == other) {
                this.deselect();
                return false;
            }
            return true;
        }

        public byte[] config() {
            return this.data;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.i(this.data.length);
            write.b(this.data);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            int len = read.i();
            if (this.data.length == len) {
                read.b(this.data);
            } else {
                read.skip(len);
            }
        }
    }
}

