/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.scene.Element;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.type.PayloadSeq;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.ui.MultiReqImage;
import mindustry.ui.ReqImage;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.consumers.ConsumePayloadFilter;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;
import mindustry.world.meta.Stats;

public class PayloadAmmoTurret
extends Turret {
    public ObjectMap<UnlockableContent, BulletType> ammoTypes = new ObjectMap();
    protected UnlockableContent[] ammoKeys;

    public PayloadAmmoTurret(String name) {
        super(name);
        this.maxAmmo = 3;
        this.acceptsPayload = true;
    }

    public void ammo(Object ... objects) {
        this.ammoTypes = ObjectMap.of(objects);
    }

    public void limitRange() {
        this.limitRange(1.0f);
    }

    public void limitRange(float margin) {
        for (ObjectMap.Entry entry : this.ammoTypes.copy().entries()) {
            ((BulletType)entry.value).lifetime = (this.range + margin) / ((BulletType)entry.value).speed;
        }
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.itemCapacity);
        this.stats.add(Stat.ammo, StatValues.ammo(this.ammoTypes, true));
    }

    @Override
    public void init() {
        this.consume(new ConsumePayloadFilter(i -> this.ammoTypes.containsKey((UnlockableContent)i)){

            @Override
            public void build(Building build, Table table) {
                MultiReqImage image = new MultiReqImage();
                for (Block block : Vars.content.blocks()) {
                    this.displayContent(build, image, block);
                }
                for (UnitType unit : Vars.content.units()) {
                    this.displayContent(build, image, unit);
                }
                table.add(image).size(32.0f);
            }

            void displayContent(Building build, MultiReqImage image, UnlockableContent content) {
                if (this.filter.get(content) && content.unlockedNow()) {
                    image.add(new ReqImage((Element)new Image(content.uiIcon), () -> {
                        if (!(build instanceof PayloadTurretBuild)) return false;
                        PayloadTurretBuild it = (PayloadTurretBuild)build;
                        if (it.payloads.isEmpty()) return false;
                        if (it.currentAmmo() != content) return false;
                        return true;
                    }));
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public float efficiency(Building build) {
                if (!(build instanceof PayloadTurretBuild)) return 0.0f;
                PayloadTurretBuild it = (PayloadTurretBuild)build;
                if (!it.payloads.any()) return 0.0f;
                return 1.0f;
            }

            @Override
            public void display(Stats stats) {
            }
        });
        this.ammoKeys = (UnlockableContent[])this.ammoTypes.keys().toSeq().toArray(UnlockableContent.class);
        super.init();
    }

    public class PayloadTurretBuild
    extends Turret.TurretBuild {
        public PayloadSeq payloads;

        public PayloadTurretBuild() {
            super(PayloadAmmoTurret.this);
            this.payloads = new PayloadSeq();
        }

        public UnlockableContent currentAmmo() {
            for (UnlockableContent content : PayloadAmmoTurret.this.ammoKeys) {
                if (!this.payloads.contains(content)) continue;
                return content;
            }
            return null;
        }

        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            return this.payloads.total() < PayloadAmmoTurret.this.maxAmmo && PayloadAmmoTurret.this.ammoTypes.containsKey(payload.content());
        }

        @Override
        public void handlePayload(Building source, Payload payload) {
            this.payloads.add(payload.content());
        }

        @Override
        public boolean hasAmmo() {
            return this.payloads.total() > 0;
        }

        @Override
        public BulletType useAmmo() {
            for (UnlockableContent content : PayloadAmmoTurret.this.ammoKeys) {
                if (!this.payloads.contains(content)) continue;
                this.payloads.remove(content);
                return PayloadAmmoTurret.this.ammoTypes.get(content);
            }
            return null;
        }

        @Override
        public BulletType peekAmmo() {
            for (UnlockableContent content : PayloadAmmoTurret.this.ammoKeys) {
                if (!this.payloads.contains(content)) continue;
                return PayloadAmmoTurret.this.ammoTypes.get(content);
            }
            return null;
        }

        @Override
        public PayloadSeq getPayloads() {
            return this.payloads;
        }

        @Override
        public void updateTile() {
            this.totalAmmo = this.payloads.total();
            this.unit.ammo((float)this.unit.type().ammoCapacity * (float)this.totalAmmo / (float)PayloadAmmoTurret.this.maxAmmo);
            super.updateTile();
        }

        @Override
        public void displayBars(Table bars) {
            super.displayBars(bars);
            bars.add(new Bar("stat.ammo", Pal.ammo, () -> (float)this.totalAmmo / (float)PayloadAmmoTurret.this.maxAmmo)).growX();
            bars.row();
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            this.payloads.write(write);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.payloads.read(read);
            this.payloads.removeAll(u -> !PayloadAmmoTurret.this.ammoTypes.containsKey((UnlockableContent)u));
        }
    }
}

