/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.math.Angles;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.type.Liquid;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;

public class LaserTurret
extends PowerTurret {
    public float firingMoveFract = 0.25f;
    public float shootDuration = 100.0f;

    public LaserTurret(String name) {
        super(name);
        this.coolantMultiplier = 1.0f;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.remove(Stat.booster);
        if (this.coolant != null) {
            this.stats.add(Stat.input, StatValues.boosters(this.reload, this.coolant.amount, this.coolantMultiplier, false, this::consumesLiquid));
        }
    }

    @Override
    public void init() {
        super.init();
        if (this.coolant == null) {
            this.coolant = (ConsumeLiquidBase)this.findConsumer(c -> c instanceof ConsumeLiquidBase);
        }
    }

    public class LaserTurretBuild
    extends PowerTurret.PowerTurretBuild {
        public Seq<Turret.BulletEntry> bullets;

        public LaserTurretBuild() {
            super(LaserTurret.this);
            this.bullets = new Seq();
        }

        @Override
        protected void updateCooling() {
        }

        @Override
        public boolean shouldConsume() {
            return this.bullets.any() || this.isActive() || this.isShooting();
        }

        @Override
        public void placed() {
            super.placed();
            this.reloadCounter = LaserTurret.this.reload;
        }

        @Override
        public void updateTile() {
            super.updateTile();
            this.bullets.removeAll(b -> !b.bullet.isAdded() || b.bullet.type == null || b.life <= 0.0f || b.bullet.owner != this);
            if (this.bullets.any()) {
                for (Turret.BulletEntry entry : this.bullets) {
                    float bulletX = this.x + Angles.trnsx(this.rotation - 90.0f, LaserTurret.this.shootX + entry.x, LaserTurret.this.shootY + entry.y);
                    float bulletY = this.y + Angles.trnsy(this.rotation - 90.0f, LaserTurret.this.shootX + entry.x, LaserTurret.this.shootY + entry.y);
                    float angle = this.rotation + entry.rotation;
                    entry.bullet.rotation(angle);
                    entry.bullet.set(bulletX, bulletY);
                    entry.bullet.time = entry.bullet.type.lifetime * entry.bullet.type.optimalLifeFract;
                    entry.bullet.keepAlive = true;
                    entry.life -= Time.delta * this.timeScale / Math.max(this.efficiency, 1.0E-5f);
                }
                this.wasShooting = true;
                this.heat = 1.0f;
                this.curRecoil = 1.0f;
            } else if (this.reloadCounter > 0.0f) {
                if (LaserTurret.this.coolant != null) {
                    Liquid liquid = this.liquids.current();
                    float maxUsed = LaserTurret.this.coolant.amount;
                    float used = (this.cheating() ? maxUsed : Math.min(this.liquids.get(liquid), maxUsed)) * this.delta();
                    this.reloadCounter -= used * liquid.heatCapacity * LaserTurret.this.coolantMultiplier;
                    this.liquids.remove(liquid, used);
                    if (Mathf.chance(0.06 * (double)used)) {
                        LaserTurret.this.coolEffect.at(this.x + Mathf.range((float)(LaserTurret.this.size * 8) / 2.0f), this.y + Mathf.range((float)(LaserTurret.this.size * 8) / 2.0f));
                    }
                } else {
                    this.reloadCounter -= this.edelta();
                }
            }
        }

        @Override
        public float progress() {
            return 1.0f - Mathf.clamp(this.reloadCounter / LaserTurret.this.reload);
        }

        @Override
        protected void updateReload() {
        }

        @Override
        protected void updateShooting() {
            if (this.bullets.any()) {
                return;
            }
            if (this.reloadCounter <= 0.0f && this.efficiency > 0.0f && !this.charging() && this.shootWarmup >= LaserTurret.this.minWarmup) {
                BulletType type = this.peekAmmo();
                this.shoot(type);
                this.reloadCounter = LaserTurret.this.reload;
            }
        }

        @Override
        protected void turnToTarget(float targetRot) {
            this.rotation = Angles.moveToward(this.rotation, targetRot, this.efficiency * LaserTurret.this.rotateSpeed * this.delta() * (this.bullets.any() ? LaserTurret.this.firingMoveFract : 1.0f));
        }

        @Override
        protected void handleBullet(@Nullable Bullet bullet, float offsetX, float offsetY, float angleOffset) {
            if (bullet != null) {
                this.bullets.add(new Turret.BulletEntry(bullet, offsetX, offsetY, angleOffset, LaserTurret.this.shootDuration));
            }
        }

        @Override
        public float activeSoundVolume() {
            return 1.0f;
        }

        @Override
        public boolean shouldActiveSound() {
            return this.bullets.any();
        }
    }
}

