/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.fragments;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.Button;
import arc.scene.ui.ImageButton;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Tmp;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.MenuRenderer;
import mindustry.graphics.Pal;
import mindustry.ui.Fonts;
import mindustry.ui.MobileButton;
import mindustry.ui.Styles;

public class MenuFragment {
    private Table container;
    private Table submenu;
    private Button currentMenu;
    private MenuRenderer renderer;
    private Seq<MenuButton> customButtons = new Seq();
    public Seq<MenuButton> desktopButtons = null;

    public void build(Group parent) {
        this.renderer = new MenuRenderer();
        WidgetGroup group = new WidgetGroup();
        ((Element)group).setFillParent(true);
        group.visible(() -> !Vars.ui.editor.isShown());
        parent.addChild(group);
        parent = group;
        parent.fill((x, y, w, h) -> this.renderer.render());
        parent.fill(c -> c.pane(Styles.noBarPane, cont -> {
            this.container = cont;
            cont.name = "menu container";
            if (!Vars.mobile) {
                c.left();
                this.buildDesktop();
                Events.on(EventType.ResizeEvent.class, event -> this.buildDesktop());
            } else {
                this.buildMobile();
                Events.on(EventType.ResizeEvent.class, event -> this.buildMobile());
            }
        }).with(pane -> pane.setOverscroll(false, false)).grow());
        parent.fill(c -> c.bottom().right().button((Drawable)Icon.discord, new ImageButton.ImageButtonStyle(){
            {
                this.up = Tex.discordBanner;
            }
        }, Vars.ui.discord::show).marginTop(9.0f).marginLeft(10.0f).tooltip("@discord").size(84.0f, 45.0f).name("discord"));
        if (Vars.mobile) {
            parent.fill(c -> c.bottom().left().button("", new TextButton.TextButtonStyle(){
                {
                    this.font = Fonts.def;
                    this.fontColor = Color.white;
                    this.up = Tex.infoBanner;
                }
            }, Vars.ui.about::show).size(84.0f, 45.0f).name("info"));
            parent.fill((x, y, w, h) -> {
                if (Core.scene.marginBottom > 0.0f) {
                    Tex.paneTop.draw(0.0f, 0.0f, Core.graphics.getWidth(), Core.scene.marginBottom);
                }
            });
        } else if (Vars.becontrol.active()) {
            parent.fill(c -> c.bottom().right().button("@be.check", Icon.refresh, () -> {
                Vars.ui.loadfrag.show();
                Vars.becontrol.checkUpdate(result -> {
                    Vars.ui.loadfrag.hide();
                    if (!result) {
                        Vars.ui.showInfo("@be.noupdates");
                    }
                });
            }).size(200.0f, 60.0f).name("becheck").update(t -> t.getLabel().setColor(Vars.becontrol.isUpdateAvailable() ? Tmp.c1.set(Color.white).lerp(Pal.accent, Mathf.absin(5.0f, 1.0f)) : Color.white)));
        }
        String versionText = (Version.build == -1 ? "[#fc8140aa]" : "[#ffffffba]") + Version.combined();
        parent.fill((Table.DrawRect)(Table.DrawRect)LambdaMetafactory.metafactory(null, null, null, (FFFF)V, lambda$build$14(java.lang.String float float float float ), (FFFF)V)((String)versionText)).touchable = Touchable.disabled;
    }

    private void buildMobile() {
        this.container.clear();
        this.container.name = "buttons";
        this.container.setSize(Core.graphics.getWidth(), Core.graphics.getHeight());
        float size = 120.0f;
        this.container.defaults().size(size).pad(5.0f).padTop(4.0f);
        MobileButton play = new MobileButton((Drawable)Icon.play, "@campaign", () -> this.checkPlay(Vars.ui.planet::show));
        MobileButton custom = new MobileButton((Drawable)Icon.rightOpenOut, "@customgame", () -> this.checkPlay(Vars.ui.custom::show));
        MobileButton maps = new MobileButton((Drawable)Icon.download, "@loadgame", () -> this.checkPlay(Vars.ui.load::show));
        MobileButton join = new MobileButton((Drawable)Icon.add, "@joingame", () -> this.checkPlay(Vars.ui.join::show));
        MobileButton editor = new MobileButton((Drawable)Icon.terrain, "@editor", () -> this.checkPlay(Vars.ui.maps::show));
        MobileButton tools = new MobileButton((Drawable)Icon.settings, "@settings", Vars.ui.settings::show);
        MobileButton mods = new MobileButton((Drawable)Icon.book, "@mods", Vars.ui.mods::show);
        MobileButton exit = new MobileButton((Drawable)Icon.exit, "@quit", () -> Core.app.exit());
        MobileButton about = new MobileButton((Drawable)Icon.info, "@about.button", Vars.ui.about::show);
        Seq<MobileButton> customs = this.customButtons.map(b -> new MobileButton(b.icon, b.text, b.runnable == null ? () -> {} : b.runnable));
        if (!Core.graphics.isPortrait()) {
            int i;
            this.container.marginTop(60.0f);
            this.container.add(play);
            this.container.add(join);
            this.container.add(custom);
            this.container.add(maps);
            for (i = 1; i < customs.size; i += 2) {
                this.container.add(customs.get(i));
            }
            this.container.row();
            this.container.add(editor);
            this.container.add(tools);
            this.container.add(mods);
            for (i = 0; i < customs.size; i += 2) {
                this.container.add(customs.get(i));
            }
            this.container.add(Vars.ios ? about : exit);
        } else {
            this.container.marginTop(0.0f);
            this.container.add(play);
            this.container.add(maps);
            this.container.row();
            this.container.add(custom);
            this.container.add(join);
            this.container.row();
            this.container.add(editor);
            this.container.add(tools);
            this.container.row();
            this.container.add(mods);
            for (int i = 0; i < customs.size; ++i) {
                this.container.add(customs.get(i));
                if (i % 2 != 0) continue;
                this.container.row();
            }
            this.container.add(Vars.ios ? about : exit);
        }
    }

    private void buildDesktop() {
        this.container.clear();
        this.container.setSize(Core.graphics.getWidth(), Core.graphics.getHeight());
        float width = 230.0f;
        Drawable background = Styles.black6;
        this.container.left();
        this.container.add().width((float)Core.graphics.getWidth() / 10.0f);
        this.container.table(background, t -> {
            t.defaults().width(width).height(70.0f);
            t.name = "buttons";
            if (this.desktopButtons == null) {
                MenuButton[] menuButtonArray = new MenuButton[6];
                menuButtonArray[0] = new MenuButton("@play", (Drawable)Icon.play, new MenuButton("@campaign", (Drawable)Icon.play, () -> this.checkPlay(Vars.ui.planet::show)), new MenuButton("@joingame", (Drawable)Icon.add, () -> this.checkPlay(Vars.ui.join::show)), new MenuButton("@customgame", (Drawable)Icon.terrain, () -> this.checkPlay(Vars.ui.custom::show)), new MenuButton("@loadgame", (Drawable)Icon.download, () -> this.checkPlay(Vars.ui.load::show)));
                MenuButton[] menuButtonArray2 = new MenuButton[3];
                menuButtonArray2[0] = new MenuButton("@schematics", (Drawable)Icon.paste, Vars.ui.schematics::show);
                menuButtonArray2[1] = new MenuButton("@database", (Drawable)Icon.book, Vars.ui.database::show);
                menuButtonArray2[2] = new MenuButton("@about.button", (Drawable)Icon.info, Vars.ui.about::show);
                menuButtonArray[1] = new MenuButton("@database.button", (Drawable)Icon.menu, menuButtonArray2);
                menuButtonArray[2] = new MenuButton("@editor", (Drawable)Icon.terrain, () -> this.checkPlay(Vars.ui.maps::show));
                menuButtonArray[3] = Vars.steam ? new MenuButton("@workshop", (Drawable)Icon.steam, Vars.platform::openWorkshop) : null;
                menuButtonArray[4] = new MenuButton("@mods", (Drawable)Icon.book, Vars.ui.mods::show);
                menuButtonArray[5] = new MenuButton("@settings", (Drawable)Icon.settings, Vars.ui.settings::show);
                this.desktopButtons = Seq.with(menuButtonArray);
            }
            this.buttons((Table)t, (MenuButton[])this.desktopButtons.toArray(MenuButton.class));
            this.buttons((Table)t, (MenuButton[])this.customButtons.toArray(MenuButton.class));
            MenuButton[] menuButtonArray = new MenuButton[1];
            menuButtonArray[0] = new MenuButton("@quit", (Drawable)Icon.exit, Core.app::exit);
            this.buttons((Table)t, menuButtonArray);
        }).width(width).growY();
        this.container.table(background, t -> {
            this.submenu = t;
            t.name = "submenu";
            t.color.a = 0.0f;
            t.top();
            t.defaults().width(width).height(70.0f);
            t.visible(() -> !t.getChildren().isEmpty());
        }).width(width).growY();
    }

    private void checkPlay(Runnable run) {
        if (!Vars.mods.hasContentErrors()) {
            run.run();
        } else {
            Vars.ui.showInfo("@mod.noerrorplay");
        }
    }

    private void fadeInMenu() {
        this.submenu.clearActions();
        this.submenu.actions(Actions.alpha(1.0f, 0.15f, Interp.fade));
    }

    private void fadeOutMenu() {
        if (this.submenu.getChildren().isEmpty()) {
            return;
        }
        this.submenu.clearActions();
        this.submenu.actions(Actions.alpha(1.0f), Actions.alpha(0.0f, 0.2f, Interp.fade), Actions.run(() -> this.submenu.clearChildren()));
    }

    private void buttons(Table t, MenuButton ... buttons) {
        for (MenuButton b : buttons) {
            if (b == null) continue;
            Button[] out = new Button[]{null};
            out[0] = t.button(b.text, b.icon, Styles.flatToggleMenut, () -> {
                if (this.currentMenu == out[0]) {
                    this.currentMenu = null;
                    this.fadeOutMenu();
                } else if (b.submenu != null && b.submenu.any()) {
                    this.currentMenu = out[0];
                    this.submenu.clearChildren();
                    this.fadeInMenu();
                    this.submenu.add().height(((float)Core.graphics.getHeight() - Core.scene.marginTop - Core.scene.marginBottom - out[0].getY(10)) / Scl.scl(1.0f));
                    this.submenu.row();
                    this.buttons(this.submenu, b.submenu.toArray());
                } else {
                    this.currentMenu = null;
                    this.fadeOutMenu();
                    b.runnable.run();
                }
            }).marginLeft(11.0f).get();
            out[0].update(() -> out[0].setChecked(this.currentMenu == out[0]));
            t.row();
        }
    }

    public void addButton(String text, Drawable icon, Runnable callback) {
        this.addButton(new MenuButton(text, icon, callback));
    }

    public void addButton(String text, Runnable callback) {
        this.addButton(text, Styles.none, callback);
    }

    public void addButton(MenuButton button) {
        this.customButtons.add(button);
    }

    private static /* synthetic */ void lambda$build$14(String versionText, float x, float y, float w, float h) {
        TextureAtlas.AtlasRegion logo = Core.atlas.find("logo");
        float width = Core.graphics.getWidth();
        float height = (float)Core.graphics.getHeight() - Core.scene.marginTop;
        float logoscl = Scl.scl(1.0f) * logo.scale;
        float logow = Math.min((float)logo.width * logoscl, (float)Core.graphics.getWidth() - Scl.scl(20.0f));
        float logoh = logow * (float)logo.height / (float)logo.width;
        float fx = (int)(width / 2.0f);
        float fy = (float)((int)(height - 6.0f - logoh)) + logoh / 2.0f - (Core.graphics.isPortrait() ? Scl.scl(30.0f) : 0.0f);
        if (Core.settings.getBool("macnotch")) {
            fy -= Scl.scl(Vars.macNotchHeight);
        }
        Draw.color();
        Draw.rect((TextureRegion)logo, fx, fy, logow, logoh);
        Fonts.outline.setColor(Color.white);
        Fonts.outline.draw(versionText, fx, fy - logoh / 2.0f - Scl.scl(2.0f), 1);
    }

    public static class MenuButton {
        public final Drawable icon;
        public final String text;
        public final Runnable runnable;
        @Nullable
        public final Seq<MenuButton> submenu;

        public MenuButton(String text, Drawable icon, Runnable runnable) {
            this.icon = icon;
            this.text = text;
            this.runnable = runnable;
            this.submenu = null;
        }

        public MenuButton(String text, Drawable icon, Runnable runnable, MenuButton ... submenu) {
            this.icon = icon;
            this.text = text;
            this.runnable = runnable;
            this.submenu = submenu != null ? Seq.with(submenu) : null;
        }

        MenuButton(String text, Drawable icon, MenuButton ... submenu) {
            this.icon = icon;
            this.text = text;
            this.runnable = () -> {};
            this.submenu = submenu != null ? Seq.with(submenu) : null;
        }
    }
}

