/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.scene.style.Drawable;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.gen.Player;
import mindustry.gen.Tex;
import mindustry.net.Administration;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class TraceDialog
extends BaseDialog {
    public TraceDialog() {
        super("@trace");
        this.addCloseButton();
    }

    public void show(Player player, Administration.TraceInfo info) {
        this.cont.clear();
        Table table = new Table(Tex.clear);
        table.margin(14.0f);
        table.defaults().pad(1.0f);
        table.defaults().left();
        ImageButton.ImageButtonStyle style = Styles.emptyi;
        float s = 28.0f;
        table.table((Table c) -> {
            c.left().defaults().left();
            c.button((Drawable)Icon.copySmall, style, () -> this.copy(player.name)).size(s).padRight(4.0f);
            c.add(Core.bundle.format("trace.playername", player.name)).row();
            c.button((Drawable)Icon.copySmall, style, () -> this.copy(info.ip)).size(s).padRight(4.0f);
            c.add(Core.bundle.format("trace.ip", info.ip)).row();
            c.button((Drawable)Icon.copySmall, style, () -> this.copy(info.locale)).size(s).padRight(4.0f);
            c.add(Core.bundle.format("trace.language", info.locale)).row();
            c.button((Drawable)Icon.copySmall, style, () -> this.copy(info.uuid)).size(s).padRight(4.0f);
            c.add(Core.bundle.format("trace.id", info.uuid)).row();
        }).row();
        table.add(Core.bundle.format("trace.modclient", info.modded)).row();
        table.add(Core.bundle.format("trace.mobile", info.mobile)).row();
        table.add(Core.bundle.format("trace.times.joined", info.timesJoined)).row();
        table.add(Core.bundle.format("trace.times.kicked", info.timesKicked)).row();
        for (int i = 0; i < 2; ++i) {
            table.add(i == 0 ? "@trace.ips" : "@trace.names").row();
            String[] list = i == 0 ? info.ips : info.names;
            table.pane((Table t) -> {
                t.left();
                for (String val : list) {
                    t.add("[lightgray]" + val).left().row();
                }
            }).padLeft(20.0f).fill().left().row();
        }
        table.add().pad(5.0f);
        table.row();
        this.cont.add(table);
        this.show();
    }

    private void copy(String content) {
        Core.app.setClipboardText(content);
        Vars.ui.showInfoFade("@copied");
    }
}

