/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui;

import arc.graphics.Color;
import arc.math.Interp;
import arc.scene.actions.Actions;
import arc.scene.style.Drawable;
import arc.scene.ui.Image;
import arc.scene.ui.Label;
import arc.scene.ui.layout.Collapser;
import arc.scene.ui.layout.Table;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.core.UI;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.ui.Styles;

public class ItemsDisplay
extends Table {
    boolean collapsed;

    public ItemsDisplay() {
        this.rebuild(new ItemSeq());
    }

    public void rebuild(ItemSeq items) {
        this.rebuild(items, null);
    }

    public void rebuild(ItemSeq items, @Nullable boolean[] shine) {
        this.clear();
        this.top().left();
        this.margin(0.0f);
        if (items == null) {
            return;
        }
        this.table(Tex.button, c -> {
            c.margin(10.0f).marginLeft(12.0f).marginTop(15.0f);
            c.marginRight(12.0f);
            c.left();
            Collapser col = new Collapser(base -> base.pane((Table t) -> {
                t.marginRight(30.0f);
                t.left();
                for (Item item : Vars.content.items()) {
                    if (!items.has(item)) continue;
                    Label label = t.add(UI.formatAmount(items.get(item))).left().get();
                    t.image(item.uiIcon).size(24.0f).padLeft(4.0f).padRight(4.0f);
                    t.add(item.localizedName).color(Color.lightGray).left();
                    t.row();
                    if (shine == null || !shine[item.id]) continue;
                    label.setColor(Pal.accent);
                    label.actions(Actions.color(Color.white, 0.75f, Interp.fade));
                }
            }).scrollX(false), false).setDuration(0.3f);
            col.setCollapsed(this.collapsed, false);
            c.button("@globalitems", (Drawable)Icon.downOpen, Styles.flatTogglet, col::toggle).update((T t) -> {
                t.setChecked(col.isCollapsed());
                this.collapsed = col.isCollapsed();
                ((Image)t.getChildren().get(1)).setDrawable(col.isCollapsed() ? Icon.upOpen : Icon.downOpen);
            }).padBottom(4.0f).left().fillX().margin(12.0f).minWidth(200.0f);
            c.row();
            c.add(col);
        });
    }
}

