/*
 * Decompiled with CFR 0.152.
 */
package mindustry.mod;

import arc.Core;
import arc.files.Fi;
import arc.util.Disposable;
import arc.util.Log;
import arc.util.Time;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mindustry.Vars;
import mindustry.mod.Mods;
import rhino.Context;
import rhino.ImporterTopLevel;
import rhino.NativeJavaObject;
import rhino.Scriptable;
import rhino.Undefined;
import rhino.module.RequireBuilder;
import rhino.module.provider.ModuleSource;
import rhino.module.provider.SoftCachingModuleScriptProvider;
import rhino.module.provider.UrlModuleSourceProvider;

public class Scripts
implements Disposable {
    public final Context context;
    public final Scriptable scope;
    private boolean errored;
    Mods.LoadedMod currentMod = null;

    public Scripts() {
        Time.mark();
        this.context = Vars.platform.getScriptContext();
        this.scope = new ImporterTopLevel(this.context);
        new RequireBuilder().setModuleScriptProvider(new SoftCachingModuleScriptProvider(new ScriptModuleProvider())).setSandboxed(true).createRequire(this.context, this.scope).install(this.scope);
        if (!this.run(Core.files.internal("scripts/global.js").readString(), "global.js", false)) {
            this.errored = true;
        }
        Log.debug("Time to load script engine: @", Float.valueOf(Time.elapsed()));
    }

    public boolean hasErrored() {
        return this.errored;
    }

    public String runConsole(String text) {
        try {
            Object o = this.context.evaluateString(this.scope, text, "console.js", 1);
            if (o instanceof NativeJavaObject) {
                NativeJavaObject n = (NativeJavaObject)o;
                o = n.unwrap();
            }
            if (o == null) {
                o = "null";
            } else if (o instanceof Undefined) {
                o = "undefined";
            } else if (o instanceof Object[]) {
                Object[] arr = (Object[])o;
                o = Arrays.toString(arr);
            } else if (o instanceof int[]) {
                int[] arr = (int[])o;
                o = Arrays.toString(arr);
            } else if (o instanceof float[]) {
                float[] arr = (float[])o;
                o = Arrays.toString(arr);
            } else if (o instanceof byte[]) {
                byte[] arr = (byte[])o;
                o = Arrays.toString(arr);
            } else if (o instanceof double[]) {
                double[] arr = (double[])o;
                o = Arrays.toString(arr);
            } else if (o instanceof long[]) {
                long[] arr = (long[])o;
                o = Arrays.toString(arr);
            } else if (o instanceof char[]) {
                char[] arr = (char[])o;
                o = Arrays.toString(arr);
            } else if (o instanceof boolean[]) {
                boolean[] arr = (boolean[])o;
                o = Arrays.toString(arr);
            }
            String out = o.toString();
            return out == null ? "null" : out;
        }
        catch (Throwable t) {
            return this.getError(t, false);
        }
    }

    private String getError(Throwable t, boolean log) {
        if (log) {
            Log.err(t);
        }
        return t.getClass().getSimpleName() + (t.getMessage() == null ? "" : ": " + t.getMessage());
    }

    public void log(String source, String message) {
        this.log(Log.LogLevel.info, source, message);
    }

    public void log(Log.LogLevel level, String source, String message) {
        Log.log(level, "[@]: @", source, message);
    }

    public float[] newFloats(int capacity) {
        return new float[capacity];
    }

    public void run(Mods.LoadedMod mod, Fi file) {
        this.currentMod = mod;
        this.run(file.readString(), mod.name + "/" + file.name(), true);
        this.currentMod = null;
    }

    private boolean run(String script, String file, boolean wrap) {
        try {
            if (this.currentMod != null) {
                this.context.evaluateString(this.scope, "modName = \"" + this.currentMod.name + "\"\nscriptName = \"" + file + "\"", "initscript.js", 1);
            }
            this.context.evaluateString(this.scope, wrap ? "(function(){'use strict';\n" + script + "\n})();" : script, file, 0);
            return true;
        }
        catch (Throwable t) {
            this.log(Log.LogLevel.err, file, this.getError(t, true));
            return false;
        }
    }

    @Override
    public void dispose() {
        Context.exit();
    }

    private class ScriptModuleProvider
    extends UrlModuleSourceProvider {
        private final Pattern directory;

        public ScriptModuleProvider() {
            super(null, null);
            this.directory = Pattern.compile("^(.+?)/(.+)");
        }

        @Override
        public ModuleSource loadSource(String moduleId, Scriptable paths, Object validator) throws URISyntaxException {
            if (Scripts.this.currentMod == null) {
                return null;
            }
            return this.loadSource(Scripts.this.currentMod, moduleId, Scripts.this.currentMod.root.child("scripts"), validator);
        }

        private ModuleSource loadSource(Mods.LoadedMod sourceMod, String moduleId, Fi root, Object validator) throws URISyntaxException {
            Matcher matched = this.directory.matcher(moduleId);
            if (matched.find()) {
                Mods.LoadedMod required = Vars.mods.locateMod(matched.group(1));
                String script = matched.group(2);
                if (required == null) {
                    Fi dir = root.child(matched.group(1));
                    if (!dir.exists()) {
                        return null;
                    }
                    return this.loadSource(sourceMod, script, dir, validator);
                }
                Scripts.this.currentMod = required;
                return this.loadSource(sourceMod, script, required.root.child("scripts"), validator);
            }
            Fi module = root.child(moduleId + ".js");
            if (!module.exists() || module.isDirectory()) {
                return null;
            }
            return new ModuleSource(module.reader(8192), new URI(sourceMod.name + "/" + moduleId + ".js"), root.file().toURI(), validator);
        }
    }
}

