/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.generators;

import arc.func.Cons;
import arc.func.Intc2;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.ai.Astar;
import mindustry.ai.BaseRegistry;
import mindustry.content.Blocks;
import mindustry.game.Schematic;
import mindustry.game.Schematics;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.type.Sector;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.Tiles;
import mindustry.world.blocks.defense.Door;
import mindustry.world.blocks.defense.ShockMine;
import mindustry.world.blocks.defense.Wall;
import mindustry.world.blocks.payloads.PayloadBlock;
import mindustry.world.blocks.payloads.PayloadConveyor;
import mindustry.world.blocks.power.Battery;
import mindustry.world.blocks.power.PowerNode;
import mindustry.world.blocks.production.Drill;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.BuildVisibility;

public class BaseGenerator {
    private static final Vec2 axis = new Vec2();
    private static final Vec2 rotator = new Vec2();
    private static final int range = 180;
    private static boolean insanity = false;
    private Tiles tiles;
    private Seq<Tile> cores;

    public static Block getDifficultyWall(int size, float difficulty) {
        Seq<Block> wallsSmall = Vars.content.blocks().select(b -> b instanceof Wall && b.isVanilla() && b.size == size && !b.insulated && b.buildVisibility == BuildVisibility.shown && !(b instanceof Door) && b.isOnPlanet(Vars.state.getPlanet()));
        wallsSmall.sort(b -> b.buildTime);
        return wallsSmall.getFrac(difficulty * 0.91f);
    }

    public void generate(Tiles tiles, Seq<Tile> cores, Tile spawn, Team team, Sector sector, float difficulty) {
        this.tiles = tiles;
        this.cores = cores;
        if (Vars.bases.cores.isEmpty()) {
            return;
        }
        Mathf.rand.setSeed(sector.id);
        Mathf.rand.nextDouble();
        float bracketRange = 0.17f;
        float baseChance = Mathf.lerp(0.7f, 2.1f, difficulty);
        int wallAngle = 70;
        double resourceChance = 0.5 * (double)baseChance;
        double nonResourceChance = 0.002 * (double)baseChance;
        int passes = (double)difficulty < 0.4 ? 1 : ((double)difficulty < 0.8 ? 3 : 5);
        Block wall = BaseGenerator.getDifficultyWall(1, difficulty);
        Block wallLarge = BaseGenerator.getDifficultyWall(2, difficulty);
        for (Tile tile2 : cores) {
            tile2.clearOverlay();
            Schematics.placeLoadout(Vars.bases.cores.getFrac((float)((difficulty + Mathf.rand.range((float)0.4f)) / 1.4f)).schematic, tile2.x, tile2.y, team, false);
            Building entity = tile2.build;
            for (Item item : Vars.content.items()) {
                entity.items.add(item, entity.block.itemCapacity);
            }
        }
        for (int i = 0; i < passes; ++i) {
            this.pass(tile -> {
                if (!tile.block().alwaysReplace) {
                    return;
                }
                if ((tile.overlay().asFloor().itemDrop != null || tile.drop() != null && Mathf.rand.chance(nonResourceChance) || tile.floor().liquidDrop != null && Mathf.rand.chance(nonResourceChance * 2.0)) && Mathf.rand.chance(resourceChance)) {
                    Seq<BaseRegistry.BasePart> parts = Vars.bases.forResource(tile.drop() != null ? tile.drop() : tile.floor().liquidDrop);
                    if (!parts.isEmpty()) {
                        BaseGenerator.tryPlace(parts.getFrac(difficulty + Mathf.rand.range(bracketRange)), tile.x, tile.y, team, Mathf.rand);
                    }
                } else if (Mathf.rand.chance(nonResourceChance)) {
                    BaseGenerator.tryPlace(Vars.bases.parts.getFrac(Mathf.rand.random(1.0f)), tile.x, tile.y, team, Mathf.rand);
                }
            });
        }
        if (wallAngle > 0) {
            this.pass(tile -> {
                if (tile.block().alwaysReplace) {
                    Tile o;
                    boolean any = false;
                    for (Point2 p : Geometry.d4) {
                        o = tiles.get(tile.x + p.x, tile.y + p.y);
                        if (o == null || !(o.block() instanceof PayloadConveyor) && !(o.block() instanceof PayloadBlock)) continue;
                        return;
                    }
                    for (Point2 p : Geometry.d8) {
                        if (Angles.angleDist(Angles.angle(p.x, p.y), spawn.angleTo((Position)tile)) > (float)wallAngle || (o = tiles.get(tile.x + p.x, tile.y + p.y)) == null || o.team() != team || o.block() instanceof Wall || o.block() instanceof ShockMine) continue;
                        any = true;
                        break;
                    }
                    if (any) {
                        tile.setBlock(wall, team);
                    }
                }
            });
            this.pass(curr -> {
                int walls = 0;
                for (int cx = 0; cx < 2; ++cx) {
                    for (int cy = 0; cy < 2; ++cy) {
                        Tile tile = tiles.get(curr.x + cx, curr.y + cy);
                        if (tile == null || tile.block().size != 1 || tile.block() != wall && !tile.block().alwaysReplace) {
                            return;
                        }
                        if (tile.block() != wall) continue;
                        ++walls;
                    }
                }
                if (walls >= 3) {
                    curr.setBlock(wallLarge, team);
                }
            });
        }
        float coreDst = 80.0f;
        for (Tile tile3 : cores) {
            Astar.pathfind(tile3, spawn, t -> t.team() == Vars.state.rules.waveTeam && !t.within(tile3, coreDst) ? 100000.0f : (t.floor().hasSurface() ? 1.0f : 10.0f), t -> !t.block().isStatic()).each(t -> {
                if (!t.within(tile3, coreDst)) {
                    if (t.team() == Vars.state.rules.waveTeam) {
                        t.setBlock(Blocks.air);
                    }
                    for (Point2 p : Geometry.d8) {
                        Tile other = t.nearby(p);
                        if (other == null || other.team() != Vars.state.rules.waveTeam) continue;
                        other.setBlock(Blocks.air);
                    }
                }
            });
        }
    }

    public void postGenerate() {
        if (this.tiles == null) {
            return;
        }
        for (Tile tile : this.tiles) {
            if (!tile.isCenter() || tile.team() != Vars.state.rules.waveTeam) continue;
            if (tile.block() instanceof PowerNode) {
                tile.build.configureAny(new Point2[0]);
                tile.build.placed();
                continue;
            }
            if (!(tile.block() instanceof Battery)) continue;
            tile.build.power.status = 1.0f;
        }
    }

    void pass(Cons<Tile> cons) {
        Tile core = this.cores.first();
        core.circle(180, (x, y) -> cons.get(this.tiles.getn(x, y)));
    }

    public static boolean tryPlace(BaseRegistry.BasePart part, int x, int y, Team team, Rand rand) {
        return BaseGenerator.tryPlace(part, x, y, team, rand, null);
    }

    public static boolean tryPlace(BaseRegistry.BasePart part, int x, int y, Team team, Rand random, @Nullable Intc2 posc) {
        Item item;
        int realY;
        int realX;
        int rotation = random.range(2);
        axis.set((int)((float)part.schematic.width / 2.0f), (int)((float)part.schematic.height / 2.0f));
        Schematic result = Schematics.rotate(part.schematic, rotation);
        rotator.set(part.centerX, part.centerY).rotateAround(axis, rotation * 90);
        int cx = x - (int)BaseGenerator.rotator.x;
        int cy = y - (int)BaseGenerator.rotator.y;
        if (!insanity) {
            for (Schematic.Stile tile : result.tiles) {
                realX = tile.x + cx;
                realY = tile.y + cy;
                if (!BaseGenerator.isTaken(tile.block, realX, realY) && (tile.block != Blocks.oilExtractor || !(tile.block.sumAttribute(Attribute.oil, realX, realY) <= 0.001f))) continue;
                return false;
            }
        }
        for (Schematic.Stile tile : result.tiles) {
            realX = tile.x + cx;
            realY = tile.y + cy;
            if (posc == null) continue;
            posc.get(realX, realY);
        }
        Object object = part.required;
        if (object instanceof Item) {
            item = (Item)object;
            for (Schematic.Stile tile : result.tiles) {
                if (!(tile.block instanceof Drill) || insanity && BaseGenerator.isTaken(tile.block, tile.x + cx, tile.y + cy)) continue;
                tile.block.iterateTaken(tile.x + cx, tile.y + cy, (ex, ey) -> {
                    Tile rand;
                    Tile placed = Vars.world.tiles.get(ex, ey);
                    if (placed == null) {
                        return;
                    }
                    if (placed.floor().hasSurface()) {
                        BaseGenerator.set(placed, item);
                    }
                    if ((rand = Vars.world.tiles.getc(ex + random.range(1), ey + random.range(1))).floor().hasSurface()) {
                        BaseGenerator.set(rand, item);
                    }
                });
            }
        }
        Schematics.place(result, cx + result.width / 2, cy + result.height / 2, team, false);
        object = part.required;
        if (object instanceof Item) {
            item = (Item)object;
            for (Schematic.Stile tile : result.tiles) {
                Building build;
                if (!(tile.block instanceof Drill) || (build = Vars.world.build(tile.x + cx, tile.y + cy)) == null || build.block != tile.block) continue;
                build.items.add(item, build.block.itemCapacity);
            }
        }
        return true;
    }

    static void set(Tile tile, Item item) {
        if (Vars.bases.ores.containsKey(item)) {
            tile.setOverlay(Vars.bases.ores.get(item));
        } else if (Vars.bases.oreFloors.containsKey(item)) {
            tile.setFloor(Vars.bases.oreFloors.get(item));
        }
    }

    static boolean isTaken(Block block, int x, int y) {
        if (Vars.state.teams.anyEnemyCoresWithin(Vars.state.rules.waveTeam, (float)(x * 8) + block.offset, (float)(y * 8) + block.offset, Vars.state.rules.enemyCoreBuildRadius + 8.0f)) {
            return true;
        }
        int offsetx = -(block.size - 1) / 2;
        int offsety = -(block.size - 1) / 2;
        int pad = 1;
        for (int dx = -pad; dx < block.size + pad; ++dx) {
            for (int dy = -pad; dy < block.size + pad; ++dy) {
                if (!BaseGenerator.overlaps(dx + offsetx + x, dy + offsety + y)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean overlaps(int x, int y) {
        Tile tile = Vars.world.tiles.get(x, y);
        return tile == null || !tile.block().alwaysReplace || Vars.world.getDarkness(x, y) > 0.0f;
    }

    private static /* synthetic */ void lambda$generate$3(Team team, Block wall, Block wallLarge, Tile tile) {
        if (tile.block() instanceof Wall && tile.team() == team && tile.block() != wall && tile.block() != wallLarge) {
            tile.setBlock(tile.block().size == 2 ? wallLarge : wall, team);
        }
    }
}

