/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import mindustry.content.Blocks;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Block;

public class ScatterFilter
extends GenerateFilter {
    public float chance = 0.013f;
    public Block flooronto = Blocks.air;
    public Block floor = Blocks.air;
    public Block block = Blocks.air;

    @Override
    public FilterOption[] options() {
        return new FilterOption[]{new FilterOption.SliderOption("chance", () -> this.chance, f -> {
            this.chance = f;
        }, 0.0f, 1.0f), new FilterOption.BlockOption("flooronto", () -> this.flooronto, b -> {
            this.flooronto = b;
        }, FilterOption.floorsOptional), new FilterOption.BlockOption("floor", () -> this.floor, b -> {
            this.floor = b;
        }, FilterOption.floorsOptional), new FilterOption.BlockOption("block", () -> this.block, b -> {
            this.block = b;
        }, FilterOption.wallsOresOptional)};
    }

    @Override
    public char icon() {
        return '\uf7cb';
    }

    @Override
    public void apply(GenerateFilter.GenerateInput in) {
        if (this.block != Blocks.air && (in.floor == this.flooronto || this.flooronto == Blocks.air) && in.block == Blocks.air && this.chance(in.x, in.y) <= this.chance) {
            if (!this.block.isOverlay()) {
                in.block = this.block;
            } else {
                in.overlay = this.block;
            }
        }
        if (this.floor != Blocks.air && (in.floor == this.flooronto || this.flooronto == Blocks.air) && this.chance(in.x, in.y) <= this.chance) {
            in.floor = this.floor;
        }
    }
}

