/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.filters;

import mindustry.content.Blocks;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.world.Block;

public class NoiseFilter
extends GenerateFilter {
    public float scl = 40.0f;
    public float threshold = 0.5f;
    public float octaves = 3.0f;
    public float falloff = 0.5f;
    public float tilt = 0.0f;
    public Block floor = Blocks.stone;
    public Block block = Blocks.stoneWall;
    public Block target = Blocks.air;

    @Override
    public FilterOption[] options() {
        return new FilterOption[]{new FilterOption.SliderOption("scale", () -> this.scl, f -> {
            this.scl = f;
        }, 1.0f, 500.0f), new FilterOption.SliderOption("threshold", () -> this.threshold, f -> {
            this.threshold = f;
        }, 0.0f, 1.0f), new FilterOption.SliderOption("octaves", () -> this.octaves, f -> {
            this.octaves = f;
        }, 1.0f, 10.0f), new FilterOption.SliderOption("falloff", () -> this.falloff, f -> {
            this.falloff = f;
        }, 0.0f, 1.0f), new FilterOption.SliderOption("tilt", () -> this.tilt, f -> {
            this.tilt = f;
        }, -4.0f, 4.0f), new FilterOption.BlockOption("target", () -> this.target, b -> {
            this.target = b;
        }, FilterOption.anyOptional), new FilterOption.BlockOption("floor", () -> this.floor, b -> {
            this.floor = b;
        }, FilterOption.floorsOptional), new FilterOption.BlockOption("wall", () -> this.block, b -> {
            this.block = b;
        }, FilterOption.wallsOptional)};
    }

    @Override
    public char icon() {
        return '\uf8c6';
    }

    @Override
    public void apply(GenerateFilter.GenerateInput in) {
        float noise = this.noise(in.x, (float)in.y + (float)in.x * this.tilt, this.scl, 1.0f, this.octaves, this.falloff);
        if (noise > this.threshold && (this.target == Blocks.air || in.floor == this.target || in.block == this.target)) {
            if (this.floor != Blocks.air) {
                in.floor = this.floor;
            }
            if (this.block != Blocks.air && in.block != Blocks.air && !in.block.breakable) {
                in.block = this.block;
            }
        }
    }
}

