/*
 * Decompiled with CFR 0.152.
 */
package mindustry.io;

import arc.Core;
import arc.func.Prov;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.struct.IntMap;
import arc.struct.IntSeq;
import arc.struct.IntSet;
import arc.struct.OrderedMap;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.CounterInputStream;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Planets;
import mindustry.content.TechTree;
import mindustry.core.Version;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.MappableContent;
import mindustry.entities.EntityGroup;
import mindustry.game.GameStats;
import mindustry.game.Rules;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.EntityMapping;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.io.JsonIO;
import mindustry.io.SaveFileReader;
import mindustry.io.SaveMeta;
import mindustry.io.TypeIO;
import mindustry.maps.Map;
import mindustry.type.MapLocales;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.WorldContext;

public abstract class SaveVersion
extends SaveFileReader {
    protected static OrderedMap<String, SaveFileReader.CustomChunk> customChunks = new OrderedMap();
    public final int version;
    protected int lastReadBuild;
    @Nullable
    protected Prov[] entityMapping;

    public static void addCustomChunk(String name, SaveFileReader.CustomChunk chunk) {
        customChunks.put(name, chunk);
    }

    public SaveVersion(int version) {
        this.version = version;
    }

    public SaveMeta getMeta(DataInput stream) throws IOException {
        stream.readInt();
        StringMap map = this.readStringMap(stream);
        return new SaveMeta(map.getInt("version"), map.getLong("saved"), map.getLong("playtime"), map.getInt("build"), (String)map.get("mapname"), map.getInt("wave"), JsonIO.read(Rules.class, map.get("rules", "{}")), map);
    }

    @Override
    public final void write(DataOutputStream stream) throws IOException {
        this.write(stream, new StringMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(DataInputStream stream, CounterInputStream counter, WorldContext context) throws IOException {
        this.region("meta", stream, counter, in -> this.readMeta((DataInput)in, context));
        this.region("content", stream, counter, this::readContentHeader);
        try {
            this.region("map", stream, counter, in -> this.readMap((DataInput)in, context));
            this.region("entities", stream, counter, this::readEntities);
            if (this.version >= 8) {
                this.region("markers", stream, counter, this::readMarkers);
            }
            this.region("custom", stream, counter, this::readCustomChunks);
        }
        finally {
            Vars.content.setTemporaryMapper(null);
        }
    }

    public void write(DataOutputStream stream, StringMap extraTags) throws IOException {
        this.region("meta", stream, out -> this.writeMeta((DataOutput)out, extraTags));
        this.region("content", stream, this::writeContentHeader);
        this.region("map", stream, this::writeMap);
        this.region("entities", stream, this::writeEntities);
        this.region("markers", stream, this::writeMarkers);
        this.region("custom", stream, s -> this.writeCustomChunks((DataOutput)s, false));
    }

    public void writeCustomChunks(DataOutput stream, boolean net) throws IOException {
        Seq<String> chunks = customChunks.orderedKeys().select(s -> ((SaveFileReader.CustomChunk)customChunks.get((String)s)).shouldWrite() && (!net || ((SaveFileReader.CustomChunk)customChunks.get((String)s)).writeNet()));
        stream.writeInt(chunks.size);
        for (String chunkName : chunks) {
            SaveFileReader.CustomChunk chunk = (SaveFileReader.CustomChunk)customChunks.get(chunkName);
            stream.writeUTF(chunkName);
            this.writeChunk(stream, false, chunk::write);
        }
    }

    public void readCustomChunks(DataInput stream) throws IOException {
        int amount = stream.readInt();
        for (int i = 0; i < amount; ++i) {
            String name = stream.readUTF();
            SaveFileReader.CustomChunk chunk = (SaveFileReader.CustomChunk)customChunks.get(name);
            if (chunk != null) {
                this.readChunk(stream, false, chunk::read);
                continue;
            }
            this.skipChunk(stream);
        }
    }

    public void writeMeta(DataOutput stream, StringMap tags) throws IOException {
        if (Vars.state.isCampaign()) {
            Vars.state.rules.sector.info.prepare(Vars.state.rules.sector);
            Vars.state.rules.sector.saveInfo();
        }
        for (TechTree.TechNode node : TechTree.all) {
            node.save();
        }
        StringMap result = new StringMap();
        result.putAll(tags);
        this.writeStringMap(stream, result.merge(StringMap.of("saved", Time.millis(), "playtime", Vars.headless ? 0L : Vars.control.saves.getTotalPlaytime(), "build", Version.build, "mapname", Vars.state.map.name(), "wave", Vars.state.wave, "tick", Vars.state.tick, "wavetime", Float.valueOf(Vars.state.wavetime), "stats", JsonIO.write(Vars.state.stats), "rules", JsonIO.write(Vars.state.rules), "sectorPreset", Vars.state.rules.sector != null && Vars.state.rules.sector.preset != null ? Vars.state.rules.sector.preset.name : "", "locales", JsonIO.write(Vars.state.mapLocales), "mods", JsonIO.write(Vars.mods.getModStrings().toArray(String.class)), "controlGroups", Vars.headless || Vars.control == null ? "null" : JsonIO.write(Vars.control.input.controlGroups), "width", Vars.world.width(), "height", Vars.world.height(), "viewpos", Tmp.v1.set(Vars.player == null ? Vec2.ZERO : Vars.player).toString(), "controlledType", Vars.headless || Vars.control.input.controlledType == null ? "null" : Vars.control.input.controlledType.name, "nocores", Vars.state.rules.defaultTeam.cores().isEmpty(), "playerteam", Vars.player == null ? Vars.state.rules.defaultTeam.id : Vars.player.team().id)));
    }

    public void readMeta(DataInput stream, WorldContext context) throws IOException {
        Map worldmap;
        StringMap map = this.readStringMap(stream);
        Vars.state.wave = map.getInt("wave");
        Vars.state.wavetime = map.getFloat("wavetime", Vars.state.rules.waveSpacing);
        Vars.state.tick = map.getFloat("tick");
        Vars.state.stats = JsonIO.read(GameStats.class, map.get("stats", "{}"));
        Vars.state.rules = JsonIO.read(Rules.class, map.get("rules", "{}"));
        Vars.state.mapLocales = JsonIO.read(MapLocales.class, map.get("locales", "{}"));
        if (Vars.state.rules.spawns.isEmpty()) {
            Vars.state.rules.spawns = Vars.waves.get();
        }
        this.lastReadBuild = map.getInt("build", -1);
        if (context.getSector() != null) {
            Vars.state.rules.sector = context.getSector();
            if (Vars.state.rules.sector != null) {
                Vars.state.rules.sector.planet.applyRules(Vars.state.rules);
            }
        }
        if (Vars.state.rules.planet == Planets.serpulo && Vars.state.rules.hasEnv(16)) {
            Vars.state.rules.planet = Planets.erekir;
        }
        if (!Vars.headless) {
            IntSeq[] groups;
            Tmp.v1.tryFromString((String)map.get("viewpos"));
            Core.camera.position.set(Tmp.v1);
            Vars.player.set(Tmp.v1);
            Vars.control.input.controlledType = (UnitType)Vars.content.getByName(ContentType.unit, map.get("controlledType", "<none>"));
            Team team = Team.get(map.getInt("playerteam", Vars.state.rules.defaultTeam.id));
            if (!Vars.net.client() && team != Team.derelict) {
                Vars.player.team(team);
            }
            if ((groups = JsonIO.read(IntSeq[].class, map.get("controlGroups", "null"))) != null && groups.length == Vars.control.input.controlGroups.length) {
                Vars.control.input.controlGroups = groups;
            }
        }
        Vars.state.map = (worldmap = Vars.maps.byName(map.get("mapname", "\\\\\\"))) == null ? new Map(StringMap.of("name", map.get("mapname", "Unknown"), "width", 1, "height", 1)) : worldmap;
    }

    public void writeMap(DataOutput stream) throws IOException {
        Tile tile;
        int i;
        stream.writeShort(Vars.world.width());
        stream.writeShort(Vars.world.height());
        for (i = 0; i < Vars.world.width() * Vars.world.height(); ++i) {
            Tile nextTile;
            tile = Vars.world.tiles.geti(i);
            stream.writeShort(tile.floorID());
            stream.writeShort(tile.overlayID());
            int consecutives = 0;
            for (int j = i + 1; j < Vars.world.width() * Vars.world.height() && consecutives < 255 && (nextTile = Vars.world.rawTile(j % Vars.world.width(), j / Vars.world.width())).floorID() == tile.floorID() && nextTile.overlayID() == tile.overlayID(); ++consecutives, ++j) {
            }
            stream.writeByte(consecutives);
            i += consecutives;
        }
        for (i = 0; i < Vars.world.width() * Vars.world.height(); ++i) {
            Tile nextTile;
            tile = Vars.world.tiles.geti(i);
            stream.writeShort(tile.blockID());
            boolean savedata = tile.shouldSaveData();
            byte packed = (byte)((tile.build != null ? 1 : 0) | (savedata ? 4 : 0));
            stream.writeByte(packed);
            if (savedata) {
                stream.writeByte(tile.data);
                stream.writeByte(tile.floorData);
                stream.writeByte(tile.overlayData);
                stream.writeInt(tile.extraData);
            }
            if (tile.build != null) {
                if (tile.isCenter()) {
                    stream.writeBoolean(true);
                    this.writeChunk(stream, true, out -> {
                        out.writeByte(tile.build.version());
                        tile.build.writeAll(Writes.get(out));
                    });
                    continue;
                }
                stream.writeBoolean(false);
                continue;
            }
            if (savedata) continue;
            int consecutives = 0;
            for (int j = i + 1; j < Vars.world.width() * Vars.world.height() && consecutives < 255 && (nextTile = Vars.world.rawTile(j % Vars.world.width(), j / Vars.world.width())).blockID() == tile.blockID() && savedata == nextTile.shouldSaveData(); ++consecutives, ++j) {
            }
            stream.writeByte(consecutives);
            i += consecutives;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readMap(DataInput stream, WorldContext context) throws IOException {
        int width = stream.readUnsignedShort();
        int height = stream.readUnsignedShort();
        boolean generating = context.isGenerating();
        if (!generating) {
            context.begin();
        }
        try {
            int i;
            context.resize(width, height);
            for (i = 0; i < width * height; ++i) {
                int x = i % width;
                int y = i / width;
                short floorid = stream.readShort();
                short oreid = stream.readShort();
                int consecutives = stream.readUnsignedByte();
                if (Vars.content.block(floorid) == Blocks.air) {
                    floorid = Blocks.stone.id;
                }
                context.create(x, y, floorid, oreid, 0);
                for (int j = i + 1; j < i + 1 + consecutives; ++j) {
                    int newx = j % width;
                    int newy = j / width;
                    context.create(newx, newy, floorid, oreid, 0);
                }
                i += consecutives;
            }
            for (i = 0; i < width * height; ++i) {
                Block block = Vars.content.block(stream.readShort());
                Tile tile = context.tile(i);
                if (block == null) {
                    block = Blocks.air;
                }
                boolean isCenter = true;
                byte packedCheck = stream.readByte();
                boolean hadEntity = (packedCheck & 1) != 0;
                boolean hadDataOld = (packedCheck & 2) != 0;
                boolean hadDataNew = (packedCheck & 4) != 0;
                byte data = 0;
                byte floorData = 0;
                byte overlayData = 0;
                int extraData = 0;
                if (hadDataNew) {
                    data = stream.readByte();
                    floorData = stream.readByte();
                    overlayData = stream.readByte();
                    extraData = stream.readInt();
                }
                if (hadEntity) {
                    isCenter = stream.readBoolean();
                }
                if (isCenter) {
                    tile.setBlock(block);
                }
                if (hadDataNew) {
                    tile.data = data;
                    tile.floorData = floorData;
                    tile.overlayData = overlayData;
                    tile.extraData = extraData;
                    context.onReadTileData();
                }
                if (hadEntity) {
                    if (!isCenter) continue;
                    if (block.hasBuilding()) {
                        try {
                            this.readChunk(stream, true, in -> {
                                byte revision = in.readByte();
                                tile.build.readAll(Reads.get(in), revision);
                            });
                        }
                        catch (Throwable e) {
                            throw new IOException("Failed to read tile entity of block: " + block, e);
                        }
                    } else {
                        this.skipChunk(stream, true);
                    }
                    context.onReadBuilding();
                    continue;
                }
                if (hadDataOld || hadDataNew) {
                    if (!hadDataOld) continue;
                    tile.setBlock(block);
                    tile.data = stream.readByte();
                    continue;
                }
                int consecutives = stream.readUnsignedByte();
                for (int j = i + 1; j < i + 1 + consecutives; ++j) {
                    context.tile(j).setBlock(block);
                }
                i += consecutives;
            }
        }
        finally {
            if (!generating) {
                context.end();
            }
        }
    }

    public void writeTeamBlocks(DataOutput stream) throws IOException {
        Seq<Teams.TeamData> data = Vars.state.teams.getActive().copy();
        if (!data.contains(Team.sharded.data())) {
            data.add(Team.sharded.data());
        }
        stream.writeInt(data.size);
        for (Teams.TeamData team : data) {
            stream.writeInt(team.team.id);
            stream.writeInt(team.plans.size);
            for (Teams.BlockPlan block : team.plans) {
                stream.writeShort(block.x);
                stream.writeShort(block.y);
                stream.writeShort(block.rotation);
                stream.writeShort(block.block.id);
                TypeIO.writeObject(Writes.get(stream), block.config);
            }
        }
    }

    public void writeWorldEntities(DataOutput stream) throws IOException {
        stream.writeInt(Groups.all.count(Entityc::serialize));
        for (Entityc entity : Groups.all) {
            if (!entity.serialize()) continue;
            this.writeChunk(stream, true, out -> {
                out.writeByte(entity.classId());
                out.writeInt(entity.id());
                entity.beforeWrite();
                entity.write(Writes.get(out));
            });
        }
    }

    public void writeEntityMapping(DataOutput stream) throws IOException {
        stream.writeShort(EntityMapping.customIdMap.size);
        for (IntMap.Entry<String> entry : EntityMapping.customIdMap.entries()) {
            stream.writeShort(entry.key);
            stream.writeUTF((String)entry.value);
        }
    }

    public void writeEntities(DataOutput stream) throws IOException {
        this.writeEntityMapping(stream);
        this.writeTeamBlocks(stream);
        this.writeWorldEntities(stream);
    }

    public void writeMarkers(DataOutput stream) throws IOException {
        Vars.state.markers.write(stream);
    }

    public void readMarkers(DataInput stream) throws IOException {
        Vars.state.markers.read(stream);
    }

    public void readTeamBlocks(DataInput stream) throws IOException {
        int teamc = stream.readInt();
        for (int i = 0; i < teamc; ++i) {
            Team team = Team.get(stream.readInt());
            Teams.TeamData data = team.data();
            int blocks = stream.readInt();
            data.plans.clear();
            data.plans.ensureCapacity(Math.min(blocks, 1000));
            Reads reads = Reads.get(stream);
            IntSet set = new IntSet();
            for (int j = 0; j < blocks; ++j) {
                short x = stream.readShort();
                short y = stream.readShort();
                short rot = stream.readShort();
                short bid = stream.readShort();
                Object obj = TypeIO.readObject(reads);
                if (!set.add(Point2.pack(x, y))) continue;
                data.plans.addLast(new Teams.BlockPlan(x, y, rot, Vars.content.block(bid), obj));
            }
        }
    }

    public void readWorldEntities(DataInput stream) throws IOException {
        Prov[] mapping = this.entityMapping == null ? EntityMapping.idMap : this.entityMapping;
        int amount = stream.readInt();
        for (int j = 0; j < amount; ++j) {
            this.readChunk(stream, true, in -> {
                int typeid = in.readUnsignedByte();
                if (mapping[typeid] == null) {
                    in.skipBytes(this.lastRegionLength - 1);
                    return;
                }
                int id = in.readInt();
                Entityc entity = (Entityc)mapping[typeid].get();
                EntityGroup.checkNextId(id);
                entity.id(id);
                entity.read(Reads.get(in));
                entity.add();
            });
        }
        Groups.all.each(Entityc::afterReadAll);
    }

    public void readEntityMapping(DataInput stream) throws IOException {
        this.entityMapping = Arrays.copyOf(EntityMapping.idMap, EntityMapping.idMap.length);
        int amount = stream.readShort();
        for (int i = 0; i < amount; ++i) {
            short id = stream.readShort();
            String name = stream.readUTF();
            this.entityMapping[id] = EntityMapping.map(name);
        }
    }

    public void readEntities(DataInput stream) throws IOException {
        this.readEntityMapping(stream);
        this.readTeamBlocks(stream);
        this.readWorldEntities(stream);
    }

    public void readContentHeader(DataInput stream) throws IOException {
        int mapped = stream.readByte();
        MappableContent[][] map = new MappableContent[ContentType.all.length][0];
        for (int i = 0; i < mapped; ++i) {
            ContentType type = ContentType.all[stream.readByte()];
            int total = stream.readShort();
            map[type.ordinal()] = new MappableContent[total];
            for (int j = 0; j < total; ++j) {
                String name = stream.readUTF();
                map[type.ordinal()][j] = Vars.content.getByName(type, type == ContentType.block ? fallback.get(name, name) : name);
            }
        }
        Vars.content.setTemporaryMapper(map);
    }

    public void writeContentHeader(DataOutput stream) throws IOException {
        Seq<Content>[] map = Vars.content.getContentMap();
        int mappable = 0;
        for (Seq<Content> arr : map) {
            if (arr.size <= 0 || !(arr.first() instanceof MappableContent)) continue;
            ++mappable;
        }
        stream.writeByte(mappable);
        for (Seq<Content> arr : map) {
            if (arr.size <= 0 || !(arr.first() instanceof MappableContent)) continue;
            stream.writeByte(arr.first().getContentType().ordinal());
            stream.writeShort(arr.size);
            for (Content c : arr) {
                stream.writeUTF(((MappableContent)c).name);
            }
        }
    }
}

