/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics.g3d;

import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.geom.Mat3D;
import arc.math.geom.Vec3;
import arc.util.Time;
import arc.util.noise.Simplex;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.HexMesher;
import mindustry.graphics.g3d.MeshBuilder;
import mindustry.graphics.g3d.PlanetMesh;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.type.Planet;

public class HexSkyMesh
extends PlanetMesh {
    static Mat3D mat = new Mat3D();
    public float speed = 0.0f;

    public HexSkyMesh(Planet planet, final int seed, float speed, float radius, int divisions, final Color color, final int octaves, final float persistence, final float scl, final float thresh) {
        super(planet, MeshBuilder.buildHex(new HexMesher(){

            @Override
            public float getHeight(Vec3 position) {
                return 1.0f;
            }

            @Override
            public void getColor(Vec3 position, Color out) {
                out.set(color);
            }

            @Override
            public boolean skip(Vec3 position) {
                return Simplex.noise3d(7 + seed, octaves, persistence, scl, position.x, position.y * 3.0f, position.z) >= thresh;
            }
        }, divisions, planet.radius, radius), Shaders.clouds);
        this.speed = speed;
    }

    public HexSkyMesh() {
    }

    public float relRot() {
        return Time.globalTime * this.speed / 40.0f;
    }

    @Override
    public void render(PlanetParams params, Mat3D projection, Mat3D transform) {
        if (params.planet == this.planet && Mathf.zero(1.0f - params.uiAlpha, 0.01f)) {
            return;
        }
        this.preRender(params);
        this.shader.bind();
        this.shader.setUniformMatrix4("u_proj", projection.val);
        this.shader.setUniformMatrix4("u_trans", HexSkyMesh.mat.setToTranslation((Vec3)this.planet.position).rotate((Vec3)Vec3.Y, (float)(this.planet.getRotation() + this.relRot())).val);
        this.shader.apply();
        this.mesh.render(this.shader, 4);
    }

    @Override
    public void preRender(PlanetParams params) {
        Shaders.clouds.planet = this.planet;
        Shaders.clouds.lightDir.set(this.planet.solarSystem.position).sub(this.planet.position).rotate(Vec3.Y, this.planet.getRotation() + this.relRot()).nor();
        Shaders.clouds.ambientColor.set(this.planet.solarSystem.lightColor);
        Shaders.clouds.alpha = params.planet == this.planet ? 1.0f - params.uiAlpha : 1.0f;
    }
}

