/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics.g3d;

import arc.graphics.gl.Shader;
import arc.math.geom.Vec3;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.HexMesher;
import mindustry.graphics.g3d.MeshBuilder;
import mindustry.graphics.g3d.PlanetMesh;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.type.Planet;

public class HexMesh
extends PlanetMesh {
    public HexMesh(Planet planet, int divisions) {
        super(planet, MeshBuilder.buildHex(planet.generator, divisions, planet.radius, 0.2f), Shaders.planet);
    }

    public HexMesh(Planet planet, HexMesher mesher, int divisions, Shader shader) {
        super(planet, MeshBuilder.buildHex(mesher, divisions, planet.radius, 0.2f), shader);
    }

    public HexMesh() {
    }

    @Override
    public void preRender(PlanetParams params) {
        Shaders.planet.planet = this.planet;
        Shaders.planet.emissive = this.planet.generator != null && this.planet.generator.isEmissive();
        Shaders.planet.lightDir.set(this.planet.solarSystem.position).sub(this.planet.position).rotate(Vec3.Y, this.planet.getRotation()).nor();
        Shaders.planet.ambientColor.set(this.planet.solarSystem.lightColor);
    }
}

