/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.Events;
import arc.assets.loaders.TextureLoader;
import arc.files.Fi;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.g3d.Camera3D;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.Shader;
import arc.math.geom.Mat3D;
import arc.math.geom.Vec3;
import arc.scene.ui.layout.Scl;
import arc.struct.FloatSeq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.type.Planet;

public class Shaders {
    public static BlockBuildShader blockbuild;
    @Nullable
    public static ShieldShader shield;
    public static BuildBeamShader buildBeam;
    public static UnitBuildShader build;
    public static UnitArmorShader armor;
    public static DarknessShader darkness;
    public static FogShader fog;
    public static LightShader light;
    public static SurfaceShader water;
    public static SurfaceShader mud;
    public static SurfaceShader tar;
    public static SurfaceShader slag;
    public static SurfaceShader cryofluid;
    public static SurfaceShader space;
    public static SurfaceShader caustics;
    public static SurfaceShader arkycite;
    public static PlanetShader planet;
    public static CloudShader clouds;
    public static PlanetGridShader planetGrid;
    public static AtmosphereShader atmosphere;
    public static ShockwaveShader shockwave;
    public static MeshShader mesh;
    public static Shader unlit;
    public static Shader screenspace;

    public static void init() {
        mesh = new MeshShader();
        blockbuild = new BlockBuildShader();
        try {
            shield = new ShieldShader();
        }
        catch (Throwable t) {
            shield = null;
            t.printStackTrace();
        }
        fog = new FogShader();
        buildBeam = new BuildBeamShader();
        build = new UnitBuildShader();
        armor = new UnitArmorShader();
        darkness = new DarknessShader();
        light = new LightShader();
        water = new SurfaceShader("water");
        arkycite = new SurfaceShader("arkycite");
        mud = new SurfaceShader("mud");
        tar = new SurfaceShader("tar");
        slag = new SurfaceShader("slag");
        cryofluid = new SurfaceShader("cryofluid");
        space = new SpaceShader("space");
        caustics = new SurfaceShader("caustics"){

            @Override
            public String textureName() {
                return "caustics";
            }
        };
        planet = new PlanetShader();
        clouds = new CloudShader();
        planetGrid = new PlanetGridShader();
        atmosphere = new AtmosphereShader();
        unlit = new LoadShader("planet", "unlit");
        screenspace = new LoadShader("screenspace", "screenspace");
    }

    public static Fi getShaderFi(String file) {
        return Vars.tree.get("shaders/" + file);
    }

    public static class MeshShader
    extends LoadShader {
        public MeshShader() {
            super("planet", "mesh");
        }
    }

    public static class BlockBuildShader
    extends LoadShader {
        public float progress;
        public float alpha = 1.0f;
        public TextureRegion region = new TextureRegion();
        public float time;

        public BlockBuildShader() {
            super("blockbuild", "default");
        }

        @Override
        public void apply() {
            this.setUniformf("u_progress", this.progress);
            this.setUniformf("u_time", this.time);
            this.setUniformf("u_alpha", this.alpha);
            if (this.region.texture == null) {
                this.setUniformf("u_uv", 0.0f, 0.0f);
                this.setUniformf("u_uv2", 1.0f, 1.0f);
                this.setUniformf("u_texsize", 1.0f, 1.0f);
            } else {
                this.setUniformf("u_uv", this.region.u, this.region.v);
                this.setUniformf("u_uv2", this.region.u2, this.region.v2);
                this.setUniformf("u_texsize", (float)this.region.texture.width, (float)this.region.texture.height);
            }
        }
    }

    public static class ShieldShader
    extends LoadShader {
        public ShieldShader() {
            super("shield", "screenspace");
        }

        @Override
        public void apply() {
            this.setUniformf("u_dp", Scl.scl(1.0f));
            this.setUniformf("u_time", Time.time / Scl.scl(1.0f));
            this.setUniformf("u_offset", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
            this.setUniformf("u_texsize", Core.camera.width, Core.camera.height);
            this.setUniformf("u_invsize", 1.0f / Core.camera.width, 1.0f / Core.camera.height);
        }
    }

    public static class FogShader
    extends LoadShader {
        public FogShader() {
            super("fog", "default");
        }
    }

    public static class BuildBeamShader
    extends LoadShader {
        public BuildBeamShader() {
            super("buildbeam", "screenspace");
        }

        @Override
        public void apply() {
            this.setUniformf("u_dp", Scl.scl(1.0f));
            this.setUniformf("u_time", Time.time / Scl.scl(1.0f));
            this.setUniformf("u_offset", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
            this.setUniformf("u_texsize", Core.camera.width, Core.camera.height);
            this.setUniformf("u_invsize", 1.0f / Core.camera.width, 1.0f / Core.camera.height);
        }
    }

    public static class UnitBuildShader
    extends LoadShader {
        public float progress;
        public float time;
        public Color color = new Color();
        public TextureRegion region;

        public UnitBuildShader() {
            super("unitbuild", "default");
        }

        @Override
        public void apply() {
            this.setUniformf("u_time", this.time);
            this.setUniformf("u_color", this.color);
            this.setUniformf("u_progress", this.progress);
            this.setUniformf("u_uv", this.region.u, this.region.v);
            this.setUniformf("u_uv2", this.region.u2, this.region.v2);
            this.setUniformf("u_texsize", (float)this.region.texture.width, (float)this.region.texture.height);
        }
    }

    public static class UnitArmorShader
    extends LoadShader {
        public float progress;
        public float time;
        public TextureRegion region;

        public UnitArmorShader() {
            super("unitarmor", "default");
        }

        @Override
        public void apply() {
            this.setUniformf("u_time", this.time);
            this.setUniformf("u_progress", this.progress);
            this.setUniformf("u_uv", this.region.u, this.region.v);
            this.setUniformf("u_uv2", this.region.u2, this.region.v2);
            this.setUniformf("u_texsize", (float)this.region.texture.width, (float)this.region.texture.height);
        }
    }

    public static class DarknessShader
    extends LoadShader {
        public DarknessShader() {
            super("darkness", "default");
        }
    }

    public static class LightShader
    extends LoadShader {
        public Color ambient = new Color(0.01f, 0.01f, 0.04f, 0.99f);

        public LightShader() {
            super("light", "screenspace");
        }

        @Override
        public void apply() {
            this.setUniformf("u_ambient", this.ambient);
        }
    }

    public static class SurfaceShader
    extends Shader {
        Texture noiseTex;

        public SurfaceShader(String frag) {
            super(Shaders.getShaderFi("screenspace.vert"), Shaders.getShaderFi(frag + ".frag"));
            this.loadNoise();
        }

        public SurfaceShader(String vertRaw, String fragRaw) {
            super(vertRaw, fragRaw);
            this.loadNoise();
        }

        public String textureName() {
            return "noise";
        }

        public void loadNoise() {
            Core.assets.load((String)new StringBuilder().append((String)"sprites/").append((String)this.textureName()).append((String)".png").toString(), Texture.class).loaded = t -> {
                t.setFilter(Texture.TextureFilter.linear);
                t.setWrap(Texture.TextureWrap.repeat);
            };
        }

        @Override
        public void apply() {
            this.setUniformf("u_campos", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
            this.setUniformf("u_resolution", Core.camera.width, Core.camera.height);
            this.setUniformf("u_time", Time.time);
            if (this.hasUniform("u_noise")) {
                if (this.noiseTex == null) {
                    this.noiseTex = Core.assets.get("sprites/" + this.textureName() + ".png", Texture.class);
                }
                this.noiseTex.bind(1);
                ((Texture)Vars.renderer.effectBuffer.getTexture()).bind(0);
                this.setUniformi("u_noise", 1);
            }
        }
    }

    public static class SpaceShader
    extends SurfaceShader {
        Texture texture;

        public SpaceShader(String frag) {
            super(frag);
            Core.assets.load((String)"sprites/space.png", Texture.class, new TextureLoader.TextureParameter(){
                {
                    this.magFilter = Texture.TextureFilter.linear;
                    this.minFilter = Texture.TextureFilter.mipMapLinearLinear;
                    this.wrapU = this.wrapV = Texture.TextureWrap.mirroredRepeat;
                    this.genMipMaps = true;
                }
            }).loaded = t -> {
                this.texture = t;
            };
        }

        @Override
        public void apply() {
            this.setUniformf("u_campos", Core.camera.position.x, Core.camera.position.y);
            this.setUniformf("u_ccampos", Core.camera.position);
            this.setUniformf("u_resolution", (float)Core.graphics.getWidth(), (float)Core.graphics.getHeight());
            this.setUniformf("u_time", Time.time);
            this.texture.bind(1);
            ((Texture)Vars.renderer.effectBuffer.getTexture()).bind(0);
            this.setUniformi("u_stars", 1);
        }
    }

    public static class PlanetShader
    extends LoadShader {
        public Vec3 lightDir = new Vec3(1.0f, 1.0f, 1.0f).nor();
        public Color ambientColor = Color.white.cpy();
        public Vec3 camDir = new Vec3();
        public Vec3 camPos = new Vec3();
        public boolean emissive;
        public Planet planet;

        public PlanetShader() {
            super("planet", "planet");
        }

        @Override
        public void apply() {
            this.camDir.set(Vars.renderer.planets.cam.direction).rotate(Vec3.Y, this.planet.getRotation());
            this.setUniformf("u_lightdir", this.lightDir);
            this.setUniformf("u_ambientColor", this.ambientColor.r, this.ambientColor.g, this.ambientColor.b);
            this.setUniformf("u_camdir", this.camDir);
            this.setUniformf("u_campos", Vars.renderer.planets.cam.position);
            this.setUniformf("u_emissive", this.emissive ? 1.0f : 0.0f);
        }
    }

    public static class CloudShader
    extends LoadShader {
        public Vec3 lightDir = new Vec3(1.0f, 1.0f, 1.0f).nor();
        public Color ambientColor = Color.white.cpy();
        public Vec3 camDir = new Vec3();
        public float alpha = 1.0f;
        public Planet planet;

        public CloudShader() {
            super("planet", "clouds");
        }

        @Override
        public void apply() {
            this.camDir.set(Vars.renderer.planets.cam.direction).rotate(Vec3.Y, this.planet.getRotation());
            this.setUniformf("u_alpha", this.alpha);
            this.setUniformf("u_lightdir", this.lightDir);
            this.setUniformf("u_ambientColor", this.ambientColor.r, this.ambientColor.g, this.ambientColor.b);
        }
    }

    public static class PlanetGridShader
    extends LoadShader {
        public Vec3 mouse = new Vec3();

        public PlanetGridShader() {
            super("planetgrid", "planetgrid");
        }

        @Override
        public void apply() {
            this.setUniformf("u_mouse", this.mouse);
        }
    }

    public static class AtmosphereShader
    extends LoadShader {
        public Camera3D camera;
        public Planet planet;
        Mat3D mat = new Mat3D();

        public AtmosphereShader() {
            super("atmosphere", "atmosphere");
        }

        @Override
        public void apply() {
            this.setUniformf("u_resolution", (float)Core.graphics.getWidth(), (float)Core.graphics.getHeight());
            this.setUniformf("u_time", Time.globalTime / 10.0f);
            this.setUniformf("u_campos", this.camera.position);
            this.setUniformf("u_rcampos", Tmp.v31.set(this.camera.position).sub(this.planet.position));
            this.setUniformf("u_light", this.planet.getLightNormal());
            this.setUniformf("u_color", this.planet.atmosphereColor.r, this.planet.atmosphereColor.g, this.planet.atmosphereColor.b);
            this.setUniformf("u_innerRadius", this.planet.radius + this.planet.atmosphereRadIn);
            this.setUniformf("u_outerRadius", this.planet.radius + this.planet.atmosphereRadOut);
            this.setUniformMatrix4("u_model", this.planet.getTransform((Mat3D)this.mat).val);
            this.setUniformMatrix4("u_projection", this.camera.combined.val);
            this.setUniformMatrix4("u_invproj", this.camera.invProjectionView.val);
        }
    }

    public static class LoadShader
    extends Shader {
        public LoadShader(String frag, String vert) {
            super(Shaders.getShaderFi(vert + ".vert"), Shaders.getShaderFi(frag + ".frag"));
        }
    }

    public static class ShockwaveShader
    extends LoadShader {
        static final int max = 64;
        static final int size = 5;
        protected FloatSeq data = new FloatSeq();
        protected FloatSeq uniforms = new FloatSeq();
        protected boolean hadAny = false;
        protected FrameBuffer buffer = new FrameBuffer();
        public float lifetime = 20.0f;

        public ShockwaveShader() {
            super("shockwave", "screenspace");
            Events.run((Object)EventType.Trigger.update, () -> {
                if (Vars.state.isPaused()) {
                    return;
                }
                if (Vars.state.isMenu()) {
                    this.data.size = 0;
                    return;
                }
                float[] items = this.data.items;
                for (int i = 0; i < this.data.size; i += 5) {
                    int n = i + 3;
                    items[n] = items[n] - Time.delta / items[i + 4];
                    if (!(items[i + 3] <= 0.0f)) continue;
                    if (this.data.size > 5) {
                        System.arraycopy(items, this.data.size - 5, items, i, 5);
                    }
                    this.data.size -= 5;
                    i -= 5;
                }
            });
            Events.run((Object)EventType.Trigger.preDraw, () -> {
                boolean bl = this.hadAny = this.data.size > 0;
                if (this.hadAny) {
                    this.buffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
                    this.buffer.begin(Color.clear);
                }
            });
            Events.run((Object)EventType.Trigger.postDraw, () -> {
                if (this.hadAny) {
                    this.buffer.end();
                    Draw.blend(Blending.disabled);
                    this.buffer.blit(this);
                    Draw.blend();
                }
            });
        }

        @Override
        public void apply() {
            int count = this.data.size / 5;
            this.setUniformi("u_shockwave_count", count);
            if (count > 0) {
                this.setUniformf("u_resolution", Core.camera.width, Core.camera.height);
                this.setUniformf("u_campos", Core.camera.position.x - Core.camera.width / 2.0f, Core.camera.position.y - Core.camera.height / 2.0f);
                this.uniforms.clear();
                float[] items = this.data.items;
                for (int i = 0; i < count; ++i) {
                    int offset = i * 5;
                    this.uniforms.add(items[offset], items[offset + 1], items[offset + 2] * (1.0f - items[offset + 3]), items[offset + 3]);
                }
                this.setUniform4fv("u_shockwaves", this.uniforms.items, 0, this.uniforms.size);
            }
        }

        public void add(float x, float y, float radius) {
            this.add(x, y, radius, 20.0f);
        }

        public void add(float x, float y, float radius, float lifetime) {
            if (this.data.size / 5 >= 64) {
                float[] items = this.data.items;
                items[0] = x;
                items[1] = y;
                items[2] = radius;
                items[3] = 1.0f;
                items[4] = lifetime;
            } else {
                this.data.addAll(x, y, radius, 1.0f, lifetime);
            }
        }
    }
}

