/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.ScissorStack;
import arc.graphics.gl.FrameBuffer;
import arc.math.geom.Rect;
import arc.struct.Bits;
import arc.struct.LongSeq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.FogEvent;
import mindustry.gen.Unit;
import mindustry.graphics.Shaders;
import mindustry.world.Tile;
import mindustry.world.meta.BlockFlag;

public final class FogRenderer {
    private FrameBuffer staticFog = new FrameBuffer();
    private FrameBuffer dynamicFog = new FrameBuffer();
    private LongSeq events = new LongSeq();
    private Rect rect = new Rect();
    @Nullable
    private Team lastTeam;

    public FogRenderer() {
        Events.on(EventType.WorldLoadEvent.class, event -> {
            this.lastTeam = null;
            this.events.clear();
        });
    }

    public void handleEvent(long event) {
        this.events.add(event);
    }

    public Texture getStaticTexture() {
        return (Texture)this.staticFog.getTexture();
    }

    public Texture getDynamicTexture() {
        return (Texture)this.dynamicFog.getTexture();
    }

    public void drawFog() {
        if (Vars.fogControl.getDiscovered(Vars.player.team()) == null) {
            return;
        }
        boolean clearStatic = this.staticFog.resizeCheck(Vars.world.width(), Vars.world.height());
        this.dynamicFog.resize(Vars.world.width(), Vars.world.height());
        if (Vars.state.rules.staticFog && Vars.player.team() != this.lastTeam) {
            this.copyFromCpu();
            this.lastTeam = Vars.player.team();
            clearStatic = false;
        }
        Draw.proj(0.0f, 0.0f, this.staticFog.getWidth() * 8, this.staticFog.getHeight() * 8);
        this.dynamicFog.begin(Color.black);
        ScissorStack.push(this.rect.set(1.0f, 1.0f, this.staticFog.getWidth() - 2, this.staticFog.getHeight() - 2));
        Team team = Vars.player.team();
        for (Building build : Vars.indexer.getFlagged(team, BlockFlag.hasFogRadius)) {
            this.poly(build.x, build.y, build.fogRadius() * 8.0f);
        }
        for (Unit unit : team.data().units) {
            this.poly(unit.x, unit.y, unit.type.fogRadius * 8.0f);
        }
        this.dynamicFog.end();
        ScissorStack.pop();
        Draw.proj(Core.camera);
        if (Vars.state.rules.staticFog && (clearStatic || this.events.size > 0)) {
            Draw.proj(0.0f, 0.0f, this.staticFog.getWidth(), this.staticFog.getHeight());
            if (clearStatic) {
                this.staticFog.begin(Color.black);
            } else {
                this.staticFog.begin();
            }
            ScissorStack.push(this.rect.set(1.0f, 1.0f, this.staticFog.getWidth() - 2, this.staticFog.getHeight() - 2));
            Draw.color(Color.white);
            for (int i = 0; i < this.events.size; ++i) {
                this.renderEvent(this.events.items[i]);
            }
            this.events.clear();
            this.staticFog.end();
            ScissorStack.pop();
            Draw.proj(Core.camera);
        }
        if (Vars.state.rules.staticFog) {
            ((Texture)this.staticFog.getTexture()).setFilter(Texture.TextureFilter.linear);
        }
        ((Texture)this.dynamicFog.getTexture()).setFilter(Texture.TextureFilter.linear);
        Draw.shader(Shaders.fog);
        Draw.color(Vars.state.rules.dynamicColor, 0.5f);
        Draw.fbo((Texture)this.dynamicFog.getTexture(), Vars.world.width(), Vars.world.height(), 8);
        if (Vars.state.rules.staticFog) {
            Draw.color(Vars.state.rules.staticColor, 1.0f);
            Draw.fbo((Texture)this.staticFog.getTexture(), Vars.world.width(), Vars.world.height(), 8, 4.0f);
        }
        Draw.shader();
    }

    void poly(float x, float y, float rad) {
        Fill.poly(x, y, 20, rad);
    }

    void renderEvent(long e) {
        Tile tile = Vars.world.tile(FogEvent.x(e), FogEvent.y(e));
        float o = 0.0f;
        if (tile != null && tile.block().size % 2 == 0 && tile.isCenter()) {
            o = 0.5f;
        }
        Fill.poly((float)FogEvent.x(e) + 0.5f + o, (float)FogEvent.y(e) + 0.5f + o, 20, (float)FogEvent.radius(e) + 0.3f);
    }

    public void copyFromCpu() {
        this.staticFog.resize(Vars.world.width(), Vars.world.height());
        this.staticFog.begin(Color.black);
        Draw.proj(0.0f, 0.0f, this.staticFog.getWidth(), this.staticFog.getHeight());
        Draw.color();
        int ww = Vars.world.width();
        int wh = Vars.world.height();
        Bits data = Vars.fogControl.getDiscovered(Vars.player.team());
        int len = Vars.world.width() * Vars.world.height();
        if (data != null) {
            for (int i = 0; i < len; ++i) {
                if (!data.get(i)) continue;
                int x = i % ww;
                int y = i / ww;
                if (x <= 0 || y <= 0 || x >= ww - 1 || y >= wh - 1) continue;
                Fill.rect((float)x + 0.5f, (float)y + 0.5f, 1.0f, 1.0f);
            }
        }
        this.staticFog.end();
        Draw.proj(Core.camera);
    }
}

