/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.Core;
import arc.Events;
import arc.assets.Loadable;
import arc.files.Fi;
import arc.func.Boolf;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.gl.FrameBuffer;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.struct.IntMap;
import arc.struct.IntSet;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.OrderedMap;
import arc.struct.OrderedSet;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Eachable;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.ScreenUtils;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Streams;
import arc.util.io.Writes;
import arc.util.pooling.Pools;
import arc.util.serialization.Base64Coder;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Loadouts;
import mindustry.core.World;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.MappableContent;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Schematic;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.input.Placement;
import mindustry.io.JsonIO;
import mindustry.io.SaveFileReader;
import mindustry.io.TypeIO;
import mindustry.world.Block;
import mindustry.world.Build;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.blocks.distribution.MassDriver;
import mindustry.world.blocks.distribution.Sorter;
import mindustry.world.blocks.legacy.LegacyBlock;
import mindustry.world.blocks.power.LightBlock;
import mindustry.world.blocks.sandbox.ItemSource;
import mindustry.world.blocks.sandbox.LiquidSource;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.blocks.storage.Unloader;
import mindustry.world.meta.BuildVisibility;

public class Schematics
implements Loadable {
    private static final Schematic tmpSchem = new Schematic(new Seq<Schematic.Stile>(), new StringMap(), 0, 0);
    private static final Schematic tmpSchem2 = new Schematic(new Seq<Schematic.Stile>(), new StringMap(), 0, 0);
    private static final byte[] header = new byte[]{109, 115, 99, 104};
    private static final byte version = 1;
    private static final int padding = 2;
    private static final int maxPreviewsMobile = 32;
    private static final int resolution = 32;
    private Streams.OptimizedByteArrayOutputStream out = new Streams.OptimizedByteArrayOutputStream(1024);
    private Seq<Schematic> all = new Seq();
    private OrderedMap<Schematic, FrameBuffer> previews = new OrderedMap();
    private ObjectSet<Schematic> errored = new ObjectSet();
    private ObjectMap<CoreBlock, Seq<Schematic>> loadouts = new ObjectMap();
    private ObjectMap<CoreBlock, Schematic> defaultLoadouts = new ObjectMap();
    private FrameBuffer shadowBuffer;
    private Texture errorTexture;
    private long lastClearTime;

    public Schematics() {
        Events.on(EventType.ClientLoadEvent.class, event -> {
            this.errorTexture = new Texture("sprites/error.png");
        });
    }

    @Override
    public void loadSync() {
        this.load();
    }

    public void load() {
        this.all.clear();
        this.loadLoadouts();
        Vars.schematicDirectory.walk(file -> {
            if (file.extEquals("msch")) {
                this.loadFile((Fi)file);
            }
        });
        Vars.platform.getWorkshopContent(Schematic.class).each(this::loadFile);
        Vars.mods.listFiles("schematics", (mod, file) -> {
            Schematic s = this.loadFile((Fi)file);
            if (s != null) {
                s.mod = mod;
            }
        });
        this.all.sort();
        if (this.shadowBuffer == null && !Vars.headless) {
            Core.app.post(() -> {
                this.shadowBuffer = new FrameBuffer(Vars.maxSchematicSize + 2 + 8, Vars.maxSchematicSize + 2 + 8);
            });
        }
    }

    private void loadLoadouts() {
        Seq.with(Loadouts.basicShard, Loadouts.basicFoundation, Loadouts.basicNucleus, Loadouts.basicBastion).each(s -> this.checkLoadout((Schematic)s, false));
    }

    public void overwrite(Schematic target, Schematic newSchematic) {
        if (this.previews.containsKey(target)) {
            ((FrameBuffer)this.previews.get(target)).dispose();
            this.previews.remove(target);
        }
        target.tiles.clear();
        target.tiles.addAll(newSchematic.tiles);
        target.width = newSchematic.width;
        target.height = newSchematic.height;
        newSchematic.labels = target.labels;
        newSchematic.tags.putAll(target.tags);
        newSchematic.file = target.file;
        this.loadouts.each((block, list) -> list.remove(target));
        this.checkLoadout(target, true);
        try {
            Schematics.write(newSchematic, target.file);
        }
        catch (Exception e) {
            Log.err("Failed to overwrite schematic '@' (@)", newSchematic.name(), target.file);
            Log.err(e);
            Vars.ui.showException(e);
        }
    }

    @Nullable
    private Schematic loadFile(Fi file) {
        if (!file.extension().equals("msch")) {
            return null;
        }
        try {
            Schematic s = Schematics.read(file);
            this.all.add(s);
            this.checkLoadout(s, true);
            if (!s.file.parent().equals(Vars.schematicDirectory)) {
                s.tags.put("steamid", s.file.parent().name());
            }
            return s;
        }
        catch (Throwable e) {
            Log.err("Failed to read schematic from file '@'", file);
            Log.err(e);
            return null;
        }
    }

    public Seq<Schematic> all() {
        return this.all;
    }

    public void saveChanges(Schematic s) {
        if (s.file != null) {
            try {
                Schematics.write(s, s.file);
            }
            catch (Exception e) {
                Vars.ui.showException(e);
            }
        }
        this.all.sort();
    }

    public void savePreview(Schematic schematic, Fi file) {
        FrameBuffer buffer = this.getBuffer(schematic);
        Draw.flush();
        buffer.begin();
        Pixmap pixmap = ScreenUtils.getFrameBufferPixmap(0, 0, buffer.getWidth(), buffer.getHeight());
        file.writePng(pixmap);
        buffer.end();
    }

    public Texture getPreview(Schematic schematic) {
        if (this.errored.contains(schematic)) {
            return this.errorTexture;
        }
        try {
            return (Texture)this.getBuffer(schematic).getTexture();
        }
        catch (Throwable t) {
            Log.err("Failed to get preview for schematic '@' (@)", schematic.name(), schematic.file);
            Log.err(t);
            this.errored.add(schematic);
            return this.errorTexture;
        }
    }

    public boolean hasPreview(Schematic schematic) {
        return this.previews.containsKey(schematic);
    }

    public FrameBuffer getBuffer(Schematic schematic) {
        if (Vars.mobile && Time.timeSinceMillis(this.lastClearTime) > 2000L && this.previews.size > 32) {
            Seq<Schematic> keys = this.previews.orderedKeys().copy();
            for (int i = 0; i < this.previews.size - 32; ++i) {
                this.previews.remove(keys.get(i)).dispose();
            }
            this.lastClearTime = Time.millis();
        }
        if (!this.previews.containsKey(schematic)) {
            Draw.blend();
            Draw.reset();
            Tmp.m1.set(Draw.proj());
            Tmp.m2.set(Draw.trans());
            FrameBuffer buffer = new FrameBuffer((schematic.width + 2) * 32, (schematic.height + 2) * 32);
            this.shadowBuffer.begin(Color.clear);
            Draw.trans().idt();
            Draw.proj().setOrtho(0.0f, 0.0f, this.shadowBuffer.getWidth(), this.shadowBuffer.getHeight());
            Draw.color();
            schematic.tiles.each(t -> {
                int size = t.block.size;
                int offsetx = -(size - 1) / 2;
                int offsety = -(size - 1) / 2;
                for (int dx = 0; dx < size; ++dx) {
                    for (int dy = 0; dy < size; ++dy) {
                        int wx = t.x + dx + offsetx;
                        int wy = t.y + dy + offsety;
                        Fill.square(1.0f + (float)wx + 0.5f, 1.0f + (float)wy + 0.5f, 0.5f);
                    }
                }
            });
            this.shadowBuffer.end();
            buffer.begin(Color.clear);
            Draw.proj().setOrtho(0.0f, buffer.getHeight(), buffer.getWidth(), -buffer.getHeight());
            Tmp.tr1.set((Texture)this.shadowBuffer.getTexture(), 0, 0, schematic.width + 2, schematic.height + 2);
            Draw.color(0.0f, 0.0f, 0.0f, 1.0f);
            Draw.rect(Tmp.tr1, (float)buffer.getWidth() / 2.0f, (float)buffer.getHeight() / 2.0f, (float)buffer.getWidth(), (float)(-buffer.getHeight()));
            Draw.color();
            Seq<BuildPlan> plans = schematic.tiles.map(t -> new BuildPlan(t.x, t.y, t.rotation, t.block, t.config));
            Draw.flush();
            Draw.trans().scale(4.0f, 4.0f).translate(12.0f, 12.0f);
            plans.each(req -> {
                req.animScale = 1.0f;
                req.worldContext = false;
                req.block.drawPlanRegion((BuildPlan)req, (Eachable<BuildPlan>)plans);
            });
            plans.each(req -> req.block.drawPlanConfigTop((BuildPlan)req, (Eachable<BuildPlan>)plans));
            Draw.flush();
            Draw.trans().idt();
            buffer.end();
            Draw.proj(Tmp.m1);
            Draw.trans(Tmp.m2);
            this.previews.put(schematic, buffer);
        }
        return (FrameBuffer)this.previews.get(schematic);
    }

    public Seq<BuildPlan> toPlans(Schematic schem, int x, int y) {
        return this.toPlans(schem, x, y, true);
    }

    public Seq<BuildPlan> toPlans(Schematic schem, int x, int y, boolean checkHidden) {
        return schem.tiles.map(t -> new BuildPlan(t.x + x - schem.width / 2, t.y + y - schem.height / 2, t.rotation, t.block, t.config)).removeAll(s -> checkHidden && !s.block.isVisible() && !(s.block instanceof CoreBlock) || !s.block.unlockedNow()).sort(Structs.comparingInt(s -> -s.block.schematicPriority));
    }

    public Seq<Schematic> getLoadouts(CoreBlock block) {
        return (Seq)((Object)this.loadouts.get(block, (Seq<Schematic>)((Object)((Prov<Seq>)Seq::new))));
    }

    public ObjectMap<CoreBlock, Seq<Schematic>> getLoadouts() {
        return this.loadouts;
    }

    @Nullable
    public Schematic getDefaultLoadout(CoreBlock block) {
        return this.defaultLoadouts.get(block);
    }

    public boolean isDefaultLoadout(Schematic schem) {
        return this.defaultLoadouts.containsValue(schem, true);
    }

    private void checkLoadout(Schematic s, boolean customSchem) {
        Schematic.Stile core = s.tiles.find(t -> t.block instanceof CoreBlock);
        if (core == null) {
            return;
        }
        int cores = s.tiles.count(t -> t.block instanceof CoreBlock);
        int maxSize = this.getMaxLaunchSize(core.block);
        if (customSchem && (s.width > maxSize || s.height > maxSize || s.tiles.contains((Schematic.Stile)((Object)((Boolf<Schematic.Stile>)t -> t.block.buildVisibility == BuildVisibility.sandboxOnly || !t.block.unlocked()))) || cores > 1)) {
            return;
        }
        ((Seq)((Object)this.loadouts.get((CoreBlock)core.block, (Seq<Schematic>)((Object)((Prov<Seq>)Seq::new))))).add(s);
        if (!customSchem) {
            this.defaultLoadouts.put((CoreBlock)core.block, s);
        }
    }

    public int getMaxLaunchSize(Block block) {
        return block.size + 10;
    }

    Fi findFile(String schematicName) {
        if (schematicName.isEmpty()) {
            schematicName = "empty";
        }
        Fi result = null;
        int index = 0;
        while (result == null || result.exists()) {
            result = Vars.schematicDirectory.child(schematicName + (index == 0 ? "" : "_" + index) + "." + "msch");
            ++index;
        }
        return result;
    }

    public void add(Schematic schematic) {
        this.all.add(schematic);
        try {
            Fi file = this.findFile(Strings.sanitizeFilename(schematic.name()));
            Schematics.write(schematic, file);
            schematic.file = file;
        }
        catch (Exception e) {
            Vars.ui.showException(e);
            Log.err(e);
        }
        this.checkLoadout(schematic, true);
        this.all.sort();
    }

    public void remove(Schematic s) {
        this.all.remove(s);
        this.loadouts.each((block, seq) -> seq.remove(s));
        if (s.file != null) {
            s.file.delete();
        }
        if (this.previews.containsKey(s)) {
            ((FrameBuffer)this.previews.get(s)).dispose();
            this.previews.remove(s);
        }
        this.all.sort();
    }

    public Schematic create(int x, int y, int x2, int y2) {
        Team team = Vars.headless ? null : Vars.player.team();
        Placement.NormalizeResult result = Placement.normalizeArea(x, y, x2, y2, 0, false, Vars.maxSchematicSize);
        x = result.x;
        y = result.y;
        x2 = result.x2;
        y2 = result.y2;
        int ox = x;
        int oy = y;
        int ox2 = x2;
        int oy2 = y2;
        Seq<Schematic.Stile> tiles = new Seq<Schematic.Stile>();
        int minx = x2;
        int miny = y2;
        int maxx = x;
        int maxy = y;
        boolean found = false;
        for (int cx = x; cx <= x2; ++cx) {
            for (int cy = y; cy <= y2; ++cy) {
                Block realBlock;
                Block block;
                Building linked = Vars.world.build(cx, cy);
                if (linked != null && (!linked.isDiscovered(team) || !linked.wasVisible)) continue;
                if (linked == null) {
                    block = null;
                } else if (linked instanceof ConstructBlock.ConstructBuild) {
                    ConstructBlock.ConstructBuild cons = (ConstructBlock.ConstructBuild)linked;
                    block = cons.current;
                } else {
                    block = realBlock = linked.block;
                }
                if (linked == null || realBlock == null || !realBlock.isVisible() && !(realBlock instanceof CoreBlock)) continue;
                int top = realBlock.size / 2;
                int bot = realBlock.size % 2 == 1 ? -realBlock.size / 2 : -(realBlock.size - 1) / 2;
                minx = Math.min(linked.tileX() + bot, minx);
                miny = Math.min(linked.tileY() + bot, miny);
                maxx = Math.max(linked.tileX() + top, maxx);
                maxy = Math.max(linked.tileY() + top, maxy);
                found = true;
            }
        }
        if (!found) {
            return new Schematic(new Seq<Schematic.Stile>(), new StringMap(), 1, 1);
        }
        x = minx;
        y = miny;
        x2 = maxx;
        y2 = maxy;
        int width = x2 - x + 1;
        int height = y2 - y + 1;
        int offsetX = -x;
        int offsetY = -y;
        IntSet counted = new IntSet();
        for (int cx = ox; cx <= ox2; ++cx) {
            for (int cy = oy; cy <= oy2; ++cy) {
                Object object;
                Block realBlock;
                Block block;
                Building tile = Vars.world.build(cx, cy);
                if (tile != null && (!tile.isDiscovered(team) || !tile.wasVisible)) continue;
                if (tile == null) {
                    block = null;
                } else if (tile instanceof ConstructBlock.ConstructBuild) {
                    ConstructBlock.ConstructBuild cons = (ConstructBlock.ConstructBuild)tile;
                    block = cons.current;
                } else {
                    block = realBlock = tile.block;
                }
                if (tile == null || counted.contains(tile.pos()) || realBlock == null || !realBlock.isVisible() && !(realBlock instanceof CoreBlock)) continue;
                if (tile instanceof ConstructBlock.ConstructBuild) {
                    ConstructBlock.ConstructBuild cons = (ConstructBlock.ConstructBuild)tile;
                    object = cons.lastConfig;
                } else {
                    object = tile.config();
                }
                Object config = object;
                tiles.add(new Schematic.Stile(realBlock, tile.tileX() + offsetX, tile.tileY() + offsetY, config, (byte)tile.rotation));
                counted.add(tile.pos());
            }
        }
        return new Schematic(tiles, new StringMap(), width, height);
    }

    public String writeBase64(Schematic schematic) {
        try {
            this.out.reset();
            Schematics.write(schematic, this.out);
            return new String(Base64Coder.encode(this.out.getBuffer(), this.out.size()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void placeLaunchLoadout(int x, int y) {
        Schematics.placeLoadout(Vars.universe.getLastLoadout(), x, y, Vars.state.rules.defaultTeam);
        if (Vars.world.tile((int)x, (int)y).build == null) {
            throw new RuntimeException("No core at loadout coordinates!");
        }
        Vars.world.tile((int)x, (int)y).build.items.add(Vars.universe.getLaunchResources());
    }

    public static void placeLoadout(Schematic schem, int x, int y) {
        Schematics.placeLoadout(schem, x, y, Vars.state.rules.defaultTeam);
    }

    public static void placeLoadout(Schematic schem, int x, int y, Team team) {
        Schematics.placeLoadout(schem, x, y, team, true);
    }

    public static void placeLoadout(Schematic schem, int x, int y, Team team, boolean check) {
        Schematic.Stile coreTile = schem.tiles.find(s -> s.block instanceof CoreBlock);
        Seq seq = new Seq();
        if (coreTile == null) {
            throw new IllegalArgumentException("Loadout schematic has no core tile!");
        }
        int ox = x - coreTile.x;
        int oy = y - coreTile.y;
        schem.tiles.copy().sort(s -> -s.block.schematicPriority).each(st -> {
            Building patt17588$temp;
            Tile tile = Vars.world.tile(st.x + ox, st.y + oy);
            if (tile == null) {
                return;
            }
            if (check && !(st.block instanceof CoreBlock)) {
                seq.clear();
                tile.getLinkedTilesAs(st.block, seq);
                for (Tile t : seq) {
                    if (t.block() == Blocks.air) continue;
                    t.remove();
                }
            }
            tile.setBlock(st.block, team, st.rotation);
            Object config = st.config;
            if (tile.build != null) {
                tile.build.configureAny(config);
            }
            if ((patt17588$temp = tile.build) instanceof CoreBlock.CoreBuild) {
                CoreBlock.CoreBuild cb = (CoreBlock.CoreBuild)patt17588$temp;
                Vars.state.teams.registerCore(cb);
            }
        });
    }

    public static void place(Schematic schem, int x, int y, Team team) {
        Schematics.place(schem, x, y, team, true);
    }

    public static void place(Schematic schem, int x, int y, Team team, boolean overwrite) {
        int ox = x - schem.width / 2;
        int oy = y - schem.height / 2;
        schem.tiles.each(st -> {
            Tile tile = Vars.world.tile(st.x + ox, st.y + oy);
            if (tile == null || !overwrite && !Build.validPlace(st.block, team, tile.x, tile.y, st.rotation)) {
                return;
            }
            tile.setBlock(st.block, team, st.rotation);
            Object config = st.config;
            if (tile.build != null) {
                tile.build.configureAny(config);
            }
        });
    }

    public static Schematic readBase64(String schematic) {
        try {
            return Schematics.read(new ByteArrayInputStream(Base64Coder.decode(schematic.trim())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Schematic read(Fi file) throws IOException {
        Schematic s = Schematics.read(new DataInputStream(file.read(1024)));
        if (!s.tags.containsKey("name")) {
            s.tags.put("name", file.nameWithoutExtension());
        }
        s.file = file;
        return s;
    }

    public static Schematic read(InputStream input) throws IOException {
        for (byte b : header) {
            if (input.read() == b) continue;
            throw new IOException("Not a schematic file (missing header).");
        }
        int ver = input.read();
        if (ver > 1) {
            throw new IOException("Unknown version: " + ver + " (are you trying to load a schematic from a newer version of the game?)");
        }
        try (DataInputStream stream = new DataInputStream(new InflaterInputStream(input));){
            short width = stream.readShort();
            short height = stream.readShort();
            if (width > 128 || height > 128) {
                throw new IOException("Invalid schematic: Too large (max possible size is 128x128)");
            }
            StringMap map = new StringMap();
            int tags = stream.readUnsignedByte();
            for (int i = 0; i < tags; ++i) {
                map.put(stream.readUTF(), stream.readUTF());
            }
            TypeIO.ContentMapper mapper = null;
            if (map.containsKey("contentMap")) {
                IntMap nameMap = JsonIO.json.fromJson(IntMap.class, ObjectIntMap.class, map.get("contentMap", "{}"));
                IntMap contentMap = new IntMap();
                for (IntMap.Entry entry : nameMap) {
                    IntMap inner = new IntMap();
                    contentMap.put(entry.key, inner);
                    for (ObjectIntMap.Entry ce : (ObjectIntMap)entry.value) {
                        inner.put(ce.value, Vars.content.getByName(ContentType.all[entry.key], (String)ce.key));
                    }
                }
                mapper = (type, id) -> (Content)((IntMap)((Object)contentMap.get(type.ordinal(), IntMap::new))).get(id);
            }
            String[] labels = null;
            try {
                labels = JsonIO.read(String[].class, map.get("labels", "[]"));
            }
            catch (Exception contentMap) {
                // empty catch block
            }
            IntMap<Block> blocks = new IntMap<Block>();
            int length = stream.readUnsignedByte();
            for (int i = 0; i < length; ++i) {
                String name = stream.readUTF();
                Block block = (Block)Vars.content.getByName(ContentType.block, SaveFileReader.fallback.get(name, name));
                blocks.put(i, block == null || block instanceof LegacyBlock ? Blocks.air : block);
            }
            int total = stream.readInt();
            if (total > 16384) {
                throw new IOException("Invalid schematic: Too many blocks.");
            }
            Seq<Schematic.Stile> tiles = new Seq<Schematic.Stile>(total);
            for (int i = 0; i < total; ++i) {
                Block block = (Block)blocks.get(stream.readByte());
                int position = stream.readInt();
                Object config = ver == 0 ? Schematics.mapConfig(block, stream.readInt(), position) : TypeIO.readObject(Reads.get(stream), false, mapper);
                byte rotation = stream.readByte();
                if (block == Blocks.air) continue;
                tiles.add(new Schematic.Stile(block, Point2.x(position), Point2.y(position), config, rotation));
            }
            Schematic out = new Schematic(tiles, map, width, height);
            if (labels != null) {
                out.labels.addAll((String[])labels);
            }
            Schematic schematic = out;
            return schematic;
        }
    }

    public static void write(Schematic schematic, Fi file) throws IOException {
        Schematics.write(schematic, file.write(false, 1024));
    }

    /*
     * WARNING - void declaration
     */
    public static void write(Schematic schematic, OutputStream output) throws IOException {
        output.write(header);
        output.write(1);
        try (DataOutputStream stream = new DataOutputStream(new DeflaterOutputStream(output));){
            void var5_11;
            stream.writeShort(schematic.width);
            stream.writeShort(schematic.height);
            schematic.tags.put("labels", JsonIO.write(schematic.labels.toArray(String.class)));
            IntMap<Prov<ObjectIntMap>> contentMap = new IntMap<Prov<ObjectIntMap>>();
            for (Schematic.Stile stile : schematic.tiles) {
                Object object = stile.config;
                if (!(object instanceof MappableContent)) continue;
                MappableContent c = (MappableContent)object;
                ((ObjectIntMap)((Object)contentMap.get(c.getContentType().ordinal(), ObjectIntMap::new))).put(c.name, c.id);
            }
            schematic.tags.put("contentMap", JsonIO.write(contentMap));
            stream.writeByte(schematic.tags.size);
            for (ObjectMap.Entry entry : schematic.tags.entries()) {
                stream.writeUTF((String)entry.key);
                stream.writeUTF((String)entry.value);
            }
            OrderedSet blocks = new OrderedSet();
            schematic.tiles.each(t -> blocks.add(t.block));
            stream.writeByte(blocks.size);
            boolean bl = false;
            while (var5_11 < blocks.size) {
                stream.writeUTF(((Block)blocks.orderedItems().get((int)var5_11)).name);
                ++var5_11;
            }
            stream.writeInt(schematic.tiles.size);
            for (Schematic.Stile tile : schematic.tiles) {
                stream.writeByte(blocks.orderedItems().indexOf(tile.block));
                stream.writeInt(Point2.pack(tile.x, tile.y));
                TypeIO.writeObject(Writes.get(stream), tile.config);
                stream.writeByte(tile.rotation);
            }
        }
    }

    private static Object mapConfig(Block block, int value, int position) {
        if (block instanceof Sorter || block instanceof Unloader || block instanceof ItemSource) {
            return Vars.content.item(value);
        }
        if (block instanceof LiquidSource) {
            return Vars.content.liquid(value);
        }
        if (block instanceof MassDriver || block instanceof ItemBridge) {
            return Point2.unpack(value).sub(Point2.x(position), Point2.y(position));
        }
        if (block instanceof LightBlock) {
            return value;
        }
        return null;
    }

    public static Schematic rotate(Schematic input, int times) {
        if (times == 0) {
            return input;
        }
        boolean sign = times > 0;
        for (int i = 0; i < Math.abs(times); ++i) {
            input = Schematics.rotated(input, sign);
        }
        return input;
    }

    private static Schematic rotated(Schematic input, boolean counter) {
        int direction = Mathf.sign(counter);
        Schematic schem = input == tmpSchem ? tmpSchem2 : tmpSchem;
        schem.width = input.width;
        schem.height = input.height;
        Pools.freeAll(schem.tiles);
        schem.tiles.clear();
        for (Schematic.Stile tile : input.tiles) {
            schem.tiles.add(Pools.obtain(Schematic.Stile.class, Schematic.Stile::new).set(tile));
        }
        int ox = schem.width / 2;
        int oy = schem.height / 2;
        schem.tiles.each(req -> {
            req.config = BuildPlan.pointConfig(req.block, req.config, p -> {
                int cx = p.x;
                int cy = p.y;
                int lx = cx;
                if (direction >= 0) {
                    cx = -cy;
                    cy = lx;
                } else {
                    cx = cy;
                    cy = -lx;
                }
                p.set(cx, cy);
            });
            float wx = (float)((req.x - ox) * 8) + req.block.offset;
            float wy = (float)((req.y - oy) * 8) + req.block.offset;
            float x = wx;
            if (direction >= 0) {
                wx = -wy;
                wy = x;
            } else {
                wx = wy;
                wy = -x;
            }
            req.x = (short)(World.toTile(wx - req.block.offset) + ox);
            req.y = (short)(World.toTile(wy - req.block.offset) + oy);
            req.rotation = (byte)Mathf.mod(req.rotation + direction, 4);
        });
        schem.width = input.height;
        schem.height = input.width;
        return schem;
    }
}

