/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.pattern;

import arc.math.Mathf;
import arc.util.Nullable;
import mindustry.entities.pattern.ShootPattern;

public class ShootAlternate
extends ShootPattern {
    public int barrels = 2;
    public float spread = 5.0f;
    public int barrelOffset = 0;
    public boolean mirror = false;

    public ShootAlternate(float spread) {
        this.spread = spread;
    }

    public ShootAlternate() {
    }

    @Override
    public void flip() {
        this.mirror = !this.mirror;
    }

    @Override
    public void shoot(int totalShots, ShootPattern.BulletHandler handler, @Nullable Runnable barrelIncrementer) {
        for (int i = 0; i < this.shots; ++i) {
            float index = (float)((totalShots + i + this.barrelOffset) % this.barrels) - (float)(this.barrels - 1) / 2.0f;
            handler.shoot(index * this.spread * (float)(-Mathf.sign(this.mirror)), 0.0f, 0.0f, this.firstShotDelay + this.shotDelay * (float)i);
            if (barrelIncrementer == null) continue;
            barrelIncrementer.run();
        }
    }
}

