/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.effect;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Vec2;
import arc.util.Nullable;
import mindustry.entities.Effect;
import mindustry.graphics.Drawf;

public class ParticleEffect
extends Effect {
    private static final Rand rand = new Rand();
    private static final Vec2 rv = new Vec2();
    public Color colorFrom = Color.white.cpy();
    public Color colorTo = Color.white.cpy();
    public int particles = 6;
    public boolean randLength = true;
    public boolean casingFlip;
    public float cone = 180.0f;
    public float length = 20.0f;
    public float baseLength = 0.0f;
    public Interp interp = Interp.linear;
    @Nullable
    public Interp sizeInterp = null;
    public float offsetX;
    public float offsetY;
    public float lightScl = 2.0f;
    public float lightOpacity = 0.6f;
    @Nullable
    public Color lightColor;
    public float spin = 0.0f;
    public float sizeFrom = 2.0f;
    public float sizeTo = 0.0f;
    public float sizeChangeStart = 0.0f;
    public boolean useRotation = true;
    public float offset = 0.0f;
    public String region = "circle";
    public boolean line;
    public float strokeFrom = 2.0f;
    public float strokeTo = 0.0f;
    public float lenFrom = 4.0f;
    public float lenTo = 2.0f;
    public boolean cap = true;
    @Nullable
    private TextureRegion tex;

    @Override
    public void init() {
        this.clip = Math.max(this.clip, this.length + Math.max(this.sizeFrom, this.sizeTo));
        this.sizeChangeStart = Mathf.clamp(this.sizeChangeStart, 0.0f, this.lifetime);
        if (this.sizeInterp == null) {
            this.sizeInterp = this.interp;
        }
    }

    @Override
    public void render(Effect.EffectContainer e) {
        Color lightColor;
        if (this.tex == null) {
            this.tex = Core.atlas.find(this.region);
        }
        float realRotation = this.useRotation ? (this.casingFlip ? Math.abs(e.rotation) : e.rotation) : this.baseRotation;
        int flip = this.casingFlip ? -Mathf.sign(e.rotation) : 1;
        float rawfin = e.fin();
        float fin = e.fin(this.interp);
        float rad = this.sizeInterp.apply(this.sizeFrom, this.sizeTo, Mathf.curve(rawfin, this.sizeChangeStart / this.lifetime, 1.0f)) * 2.0f;
        float ox = e.x + Angles.trnsx(realRotation, this.offsetX * (float)flip, this.offsetY);
        float oy = e.y + Angles.trnsy(realRotation, this.offsetX * (float)flip, this.offsetY);
        Draw.color(this.colorFrom, this.colorTo, fin);
        Color color = lightColor = this.lightColor == null ? Draw.getColor() : this.lightColor;
        if (this.line) {
            Lines.stroke(this.sizeInterp.apply(this.strokeFrom, this.strokeTo, rawfin));
            float len = this.sizeInterp.apply(this.lenFrom, this.lenTo, rawfin);
            rand.setSeed(e.id);
            for (int i = 0; i < this.particles; ++i) {
                float l = this.length * fin + this.baseLength;
                rv.trns(realRotation + rand.range(this.cone), !this.randLength ? l : rand.random(l));
                float x = ParticleEffect.rv.x;
                float y = ParticleEffect.rv.y;
                Lines.lineAngle(ox + x, oy + y, Mathf.angle(x, y), len, this.cap);
                Drawf.light(ox + x, oy + y, len * this.lightScl, lightColor, this.lightOpacity * Draw.getColorAlpha());
            }
        } else {
            rand.setSeed(e.id);
            for (int i = 0; i < this.particles; ++i) {
                float l = this.length * fin + this.baseLength;
                rv.trns(realRotation + rand.range(this.cone), !this.randLength ? l : rand.random(l));
                float x = ParticleEffect.rv.x;
                float y = ParticleEffect.rv.y;
                Draw.rect(this.tex, ox + x, oy + y, rad, rad / this.tex.ratio(), realRotation + this.offset + e.time * this.spin);
                Drawf.light(ox + x, oy + y, rad * this.lightScl, lightColor, this.lightOpacity * Draw.getColorAlpha());
            }
        }
    }
}

