/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Interp;
import mindustry.content.Fx;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.type.Liquid;

public class SpaceLiquidBulletType
extends BulletType {
    public float orbSize = 5.5f;

    public SpaceLiquidBulletType() {
        super(3.5f, 0.0f);
        this.collides = false;
        this.lifetime = 90.0f;
        this.despawnEffect = Fx.none;
        this.hitEffect = Fx.none;
        this.smokeEffect = Fx.none;
        this.shootEffect = Fx.none;
        this.drag = 0.002f;
        this.hittable = false;
    }

    @Override
    public void draw(Bullet b) {
        super.draw(b);
        Object object = b.data;
        if (!(object instanceof Liquid)) {
            return;
        }
        Liquid liquid = (Liquid)object;
        Draw.color(liquid.color);
        Fill.circle(b.x, b.y, Interp.pow3Out.apply(b.fslope()) * this.orbSize);
        Draw.reset();
    }
}

