/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.bullet.ContinuousBulletType;
import mindustry.gen.Bullet;
import mindustry.graphics.Drawf;

public class ContinuousFlameBulletType
extends ContinuousBulletType {
    public float lightStroke = 40.0f;
    public float width = 3.7f;
    public float oscScl = 1.2f;
    public float oscMag = 0.02f;
    public int divisions = 25;
    public boolean drawFlare = true;
    public Color flareColor = Color.valueOf("e189f5");
    public float flareWidth = 3.0f;
    public float flareInnerScl = 0.5f;
    public float flareLength = 40.0f;
    public float flareInnerLenScl = 0.5f;
    public float flareLayer = 99.9999f;
    public float flareRotSpeed = 1.2f;
    public boolean rotateFlare = false;
    public Interp lengthInterp = Interp.slope;
    public float[] lengthWidthPans = new float[]{1.12f, 1.3f, 0.32f, 1.0f, 1.0f, 0.3f, 0.8f, 0.9f, 0.2f, 0.5f, 0.8f, 0.15f, 0.25f, 0.7f, 0.1f};
    public Color[] colors = new Color[]{Color.valueOf("eb7abe").a(0.55f), Color.valueOf("e189f5").a(0.7f), Color.valueOf("907ef7").a(0.8f), Color.valueOf("91a4ff"), Color.white.cpy()};

    public ContinuousFlameBulletType(float damage) {
        this.optimalLifeFract = 0.5f;
        this.length = 120.0f;
        this.hitEffect = Fx.hitFlameBeam;
        this.hitSize = 4.0f;
        this.drawSize = 420.0f;
        this.lifetime = 16.0f;
        this.lightColor = this.hitColor = this.colors[1].cpy().a(1.0f);
        this.lightOpacity = 0.7f;
        this.laserAbsorb = false;
        this.ammoMultiplier = 1.0f;
        this.pierceArmor = true;
        this.damage = damage;
    }

    public ContinuousFlameBulletType() {
        this.optimalLifeFract = 0.5f;
        this.length = 120.0f;
        this.hitEffect = Fx.hitFlameBeam;
        this.hitSize = 4.0f;
        this.drawSize = 420.0f;
        this.lifetime = 16.0f;
        this.lightColor = this.hitColor = this.colors[1].cpy().a(1.0f);
        this.lightOpacity = 0.7f;
        this.laserAbsorb = false;
        this.ammoMultiplier = 1.0f;
        this.pierceArmor = true;
    }

    @Override
    public void draw(Bullet b) {
        float mult = b.fin(this.lengthInterp);
        float realLength = Damage.findLength(b, this.length * mult, this.laserAbsorb, this.pierceCap);
        float sin = Mathf.sin(Time.time, this.oscScl, this.oscMag);
        for (int i = 0; i < this.colors.length; ++i) {
            Draw.color(this.colors[i].write(Tmp.c1).mul(0.9f).mul(1.0f + Mathf.absin(Time.time, 1.0f, 0.1f)));
            Drawf.flame(b.x, b.y, this.divisions, b.rotation(), realLength * this.lengthWidthPans[i * 3] * (1.0f - sin), this.width * this.lengthWidthPans[i * 3 + 1] * mult * (1.0f + sin), this.lengthWidthPans[i * 3 + 2]);
        }
        if (this.drawFlare) {
            int i;
            Draw.color(this.flareColor);
            Draw.z(this.flareLayer);
            float angle = Time.time * this.flareRotSpeed + (this.rotateFlare ? b.rotation() : 0.0f);
            for (i = 0; i < 4; ++i) {
                Drawf.tri(b.x, b.y, this.flareWidth, this.flareLength * (mult + sin), (float)(i * 90 + 45) + angle);
            }
            Draw.color();
            for (i = 0; i < 4; ++i) {
                Drawf.tri(b.x, b.y, this.flareWidth * this.flareInnerScl, this.flareLength * this.flareInnerLenScl * (mult + sin), (float)(i * 90 + 45) + angle);
            }
        }
        Tmp.v1.trns(b.rotation(), realLength * 1.1f);
        Drawf.light(b.x, b.y, b.x + Tmp.v1.x, b.y + Tmp.v1.y, this.lightStroke, this.lightColor, this.lightOpacity);
        Draw.reset();
    }

    @Override
    public float currentLength(Bullet b) {
        return this.length * b.fin(this.lengthInterp);
    }

    @Override
    public void drawLight(Bullet b) {
    }
}

