/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.Core;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Time;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;

public class ShieldRegenFieldAbility
extends Ability {
    public float amount = 1.0f;
    public float max = 100.0f;
    public float reload = 100.0f;
    public float range = 60.0f;
    public Effect applyEffect = Fx.shieldApply;
    public Effect activeEffect = Fx.shieldWave;
    public boolean parentizeEffects;
    protected float timer;
    protected boolean applied = false;

    ShieldRegenFieldAbility() {
    }

    public ShieldRegenFieldAbility(float amount, float max, float reload, float range) {
        this.amount = amount;
        this.max = max;
        this.reload = reload;
        this.range = range;
    }

    @Override
    public void addStats(Table t) {
        super.addStats(t);
        t.add(Core.bundle.format("bullet.range", Strings.autoFixed(this.range / 8.0f, 2)));
        t.row();
        t.add(this.abilityStat("firingrate", Strings.autoFixed(60.0f / this.reload, 2)));
        t.row();
        t.add(this.abilityStat("pulseregen", Strings.autoFixed(this.amount, 2)));
        t.row();
        t.add(this.abilityStat("shield", Strings.autoFixed(this.max, 2)));
    }

    @Override
    public void update(Unit unit) {
        this.timer += Time.delta;
        if (this.timer >= this.reload) {
            this.applied = false;
            Units.nearby(unit.team, unit.x, unit.y, this.range, other -> {
                if (other.shield < this.max) {
                    other.shield = Math.min(other.shield + this.amount, this.max);
                    other.shieldAlpha = 1.0f;
                    this.applyEffect.at(other.x, other.y, 0.0f, other.type.shieldColor((Unit)other), this.parentizeEffects ? other : null);
                    this.applied = true;
                }
            });
            if (this.applied) {
                this.activeEffect.at(unit.x, unit.y, unit.type.shieldColor(unit));
            }
            this.timer = 0.0f;
        }
    }
}

