/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.func.Boolc;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Prov;
import arc.graphics.Color;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.event.HandCursorListener;
import arc.scene.style.Drawable;
import arc.scene.ui.Button;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Reflect;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.serialization.Json;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.content.UnitTypes;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.editor.MapObjectivesCanvas;
import mindustry.game.MapObjectives;
import mindustry.game.Team;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.logic.LStatement;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;

public class MapObjectivesDialog
extends BaseDialog {
    public MapObjectivesCanvas canvas;
    protected Cons<Seq<MapObjectives.MapObjective>> out = arr -> {};
    private static final ObjectMap<Class<?>, FieldProvider<?>> providers = new ObjectMap();
    private static final ObjectMap<Class<? extends Annotation>, ObjectMap<Class<?>, FieldInterpreter<?>>> interpreters = new ObjectMap();

    public static <T> FieldInterpreter<T> defaultInterpreter() {
        return (cont, name, type, field, remover, indexer, get, set) -> cont.table((Table main) -> {
            main.margin(0.0f, 10.0f, 0.0f, 10.0f);
            Table header = main.table(Tex.button, t -> {
                t.left();
                t.margin(10.0f);
                if (name.length() > 0) {
                    t.add(name + ":").color(Pal.accent);
                }
                t.add().growX();
                Cell<ImageButton> remove = null;
                if (remover != null) {
                    remove = t.button((Drawable)Icon.trash, Styles.emptyi, remover).fill();
                }
                if (indexer != null) {
                    if (remove != null) {
                        remove.padRight(4.0f);
                    }
                    t.button((Drawable)Icon.upOpen, Styles.emptyi, () -> indexer.get(true)).fill().padRight(4.0f);
                    t.button((Drawable)Icon.downOpen, Styles.emptyi, () -> indexer.get(false)).fill();
                }
            }).growX().height(46.0f).pad(0.0f, -10.0f, -0.0f, -10.0f).get();
            main.row().table(Tex.button, t -> {
                t.left();
                t.top().margin(10.0f).marginTop(20.0f);
                t.defaults().minHeight(40.0f).left();
                Object obj = get.get();
                int i = 0;
                for (Json.FieldMetadata e : JsonIO.json.getFields(type.raw).values()) {
                    if (i++ > 0) {
                        t.row();
                    }
                    Field f = e.field;
                    Class<?> ft = f.getType();
                    int mods = f.getModifiers();
                    if (!Modifier.isPublic(mods) || Modifier.isFinal(mods) && (String.class.isAssignableFrom(ft) || MapObjectivesDialog.unbox(ft).isPrimitive())) continue;
                    Annotation anno = Structs.find(f.getDeclaredAnnotations(), a -> MapObjectivesDialog.hasInterpreter(a.annotationType(), ft));
                    MapObjectivesDialog.getInterpreter(anno == null ? Override.class : anno.annotationType(), ft).build((Table)t, f.getName(), new TypeInfo(f), f, null, null, () -> Reflect.get(obj, f), Modifier.isFinal(mods) ? res -> {} : res -> Reflect.set(obj, f, res));
                }
            }).padTop(-10.0f).growX().fillY();
            header.toFront();
        }).growX().fillY().pad(4.0f).colspan(2);
    }

    public static void name(Table cont, CharSequence name, @Nullable Runnable remover, @Nullable Boolc indexer) {
        if (indexer != null || remover != null) {
            cont.table((Table t) -> {
                if (remover != null) {
                    t.button((Drawable)Icon.trash, Styles.emptyi, remover).fill().padRight(4.0f);
                }
                if (indexer != null) {
                    t.button((Drawable)Icon.upOpen, Styles.emptyi, () -> indexer.get(true)).fill().padRight(4.0f);
                    t.button((Drawable)Icon.downOpen, Styles.emptyi, () -> indexer.get(false)).fill().padRight(4.0f);
                }
            }).fill();
        } else {
            cont.add(name + ": ");
        }
    }

    public MapObjectivesDialog() {
        super("@editor.objectives");
        this.clear();
        this.margin(0.0f);
        Element[] elementArray = new Element[3];
        elementArray[0] = new Image(Styles.black5);
        this.canvas = new MapObjectivesCanvas();
        elementArray[1] = this.canvas;
        elementArray[2] = new Table(){
            {
                MapObjectivesDialog.this.buttons.defaults().size(160.0f, 64.0f).pad(2.0f);
                MapObjectivesDialog.this.buttons.button("@back", Icon.left, MapObjectivesDialog.this::hide);
                MapObjectivesDialog.this.buttons.button("@add", Icon.add, () -> MapObjectivesDialog.getProvider(MapObjectives.MapObjective.class).get(new TypeInfo(MapObjectives.MapObjective.class), MapObjectivesDialog.this.canvas::query));
                MapObjectivesDialog.this.buttons.button("@waves.edit", Icon.edit, () -> {
                    BaseDialog dialog = new BaseDialog("@waves.edit");
                    dialog.addCloseButton();
                    dialog.setFillParent(false);
                    dialog.cont.table(Tex.button, t -> {
                        TextButton.TextButtonStyle style = Styles.cleart;
                        t.defaults().size(280.0f, 64.0f).pad(2.0f);
                        t.button("@waves.copy", (Drawable)Icon.copy, style, () -> {
                            Vars.ui.showInfoFade("@copied");
                            Core.app.setClipboardText(JsonIO.write(new MapObjectives(MapObjectivesDialog.this.canvas.objectives)));
                            dialog.hide();
                        }).disabled(b -> MapObjectivesDialog.this.canvas.objectives.isEmpty()).marginLeft(12.0f).row();
                        t.button("@waves.load", (Drawable)Icon.download, style, () -> {
                            try {
                                MapObjectivesDialog.this.rebuildObjectives(new Seq<MapObjectives.MapObjective>(JsonIO.read(MapObjectives.class, (String)Core.app.getClipboardText()).all));
                            }
                            catch (Exception e) {
                                Log.err(e);
                                Vars.ui.showErrorMessage("@waves.invalid");
                            }
                            dialog.hide();
                        }).disabled(Core.app.getClipboardText() == null || !Core.app.getClipboardText().startsWith("[")).marginLeft(12.0f).row();
                        t.button("@clear", (Drawable)Icon.none, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clear.confirm", () -> {
                            MapObjectivesDialog.this.rebuildObjectives(new Seq<MapObjectives.MapObjective>());
                            dialog.hide();
                        })).marginLeft(12.0f).row();
                    });
                    dialog.show();
                });
                if (Vars.mobile) {
                    MapObjectivesDialog.this.buttons.button("@cancel", Icon.cancel, MapObjectivesDialog.this.canvas::stopQuery).visible(() -> MapObjectivesDialog.this.canvas.isQuerying());
                    MapObjectivesDialog.this.buttons.button("@ok", Icon.ok, MapObjectivesDialog.this.canvas::placeQuery).visible(() -> MapObjectivesDialog.this.canvas.isQuerying());
                }
                this.setFillParent(true);
                this.margin(3.0f);
                this.add(MapObjectivesDialog.this.titleTable).growX().fillY();
                this.row().add().grow();
                this.row().add(MapObjectivesDialog.this.buttons).fill();
                MapObjectivesDialog.this.addCloseListener();
            }
        };
        this.stack(elementArray).grow().pad(0.0f).margin(0.0f);
        this.hidden(() -> {
            this.out.get(this.canvas.objectives);
            this.out = arr -> {};
        });
    }

    public void show(Seq<MapObjectives.MapObjective> objectives, Cons<Seq<MapObjectives.MapObjective>> out) {
        this.out = out;
        this.rebuildObjectives(objectives);
        this.show();
    }

    public void rebuildObjectives(Seq<MapObjectives.MapObjective> objectives) {
        this.canvas.clearObjectives();
        objectives.each(MapObjectives.MapObjective::validate);
        if (objectives.any() && (objectives.contains((MapObjectives.MapObjective)((Object)((Boolf<MapObjectives.MapObjective>)obj -> obj.editorX == -1 || obj.editorY == -1))) || objectives.contains((MapObjectives.MapObjective)((Object)((Boolf<MapObjectives.MapObjective>)obj -> !this.canvas.tilemap.createTile((MapObjectives.MapObjective)obj)))))) {
            this.canvas.clearObjectives();
            int w = 7;
            int len = objectives.size * w;
            int columns = objectives.size;
            int rows = 1;
            if (len > 100) {
                rows = len / 100;
                columns = 100 / w;
            }
            int i = 0;
            block0: for (int y = 0; y < rows; ++y) {
                for (int x = 0; x < columns; ++x) {
                    if (this.canvas.tilemap.createTile(x * w, y, objectives.get(i))) {
                        ++i;
                    }
                    if (i >= objectives.size) break block0;
                }
            }
        }
        this.canvas.objectives.set(objectives);
    }

    public static <T extends UnlockableContent> void showContentSelect(@Nullable ContentType type, Cons<T> cons, Boolf<T> check) {
        BaseDialog dialog = new BaseDialog("");
        dialog.cont.pane(Styles.noBarPane, (Table t) -> {
            int i = 0;
            for (UnlockableContent unlockableContent : type == null ? Vars.content.blocks().copy().as().add(Vars.content.items()).add(Vars.content.liquids()).add(Vars.content.units()) : Vars.content.getBy(type).as()) {
                if (unlockableContent.isHidden() || !check.get(unlockableContent)) continue;
                t.image(unlockableContent == Blocks.air ? Icon.none.getRegion() : unlockableContent.uiIcon).size(32.0f).pad(3.0f).scaling(Scaling.fit).with(b -> b.addListener(new HandCursorListener())).tooltip(unlockableContent.localizedName).get().clicked(() -> {
                    cons.get(content);
                    dialog.hide();
                });
                if (++i % 10 != 0) continue;
                t.row();
            }
        }).fill();
        dialog.closeOnBack();
        dialog.show();
    }

    public static void showTeamSelect(Cons<Team> cons) {
        MapObjectivesDialog.showTeamSelect(false, cons);
    }

    public static void showTeamSelect(boolean allowNull, Cons<Team> cons) {
        BaseDialog dialog = new BaseDialog("");
        dialog.cont.defaults().size(40.0f).pad(4.0f);
        if (allowNull) {
            dialog.cont.button((Drawable)Icon.cancel, Styles.emptyi, () -> {
                cons.get(null);
                dialog.hide();
            }).tooltip("@none");
        }
        for (Team team : Team.baseTeams) {
            dialog.cont.image(Tex.whiteui).color(team.color).with(i -> i.addListener(new HandCursorListener())).tooltip(team.localized()).get().clicked(() -> {
                cons.get(team);
                dialog.hide();
            });
        }
        dialog.closeOnBack();
        dialog.show();
    }

    public static Class<?> unbox(Class<?> boxed) {
        Class<Comparable<Boolean>> clazz;
        switch (boxed.getSimpleName()) {
            case "Boolean": {
                clazz = Boolean.TYPE;
                break;
            }
            case "Byte": {
                clazz = Byte.TYPE;
                break;
            }
            case "Character": {
                clazz = Character.TYPE;
                break;
            }
            case "Short": {
                clazz = Short.TYPE;
                break;
            }
            case "Integer": {
                clazz = Integer.TYPE;
                break;
            }
            case "Long": {
                clazz = Long.TYPE;
                break;
            }
            case "Float": {
                clazz = Float.TYPE;
                break;
            }
            case "Double": {
                clazz = Double.TYPE;
                break;
            }
            default: {
                clazz = boxed;
            }
        }
        return clazz;
    }

    public static <T> void setInterpreter(Class<T> type, FieldInterpreter<? super T> interpreter) {
        MapObjectivesDialog.setInterpreter(Override.class, type, interpreter);
    }

    public static <T> void setInterpreter(Class<? extends Annotation> anno, Class<T> type, FieldInterpreter<? super T> interpreter) {
        ((ObjectMap)((Object)interpreters.get((Class<Annotation>)anno, (ObjectMap<Class<?>, FieldInterpreter<?>>)((Object)((Prov<ObjectMap>)ObjectMap::new))))).put(type, interpreter);
    }

    public static boolean hasInterpreter(Class<?> type) {
        return MapObjectivesDialog.hasInterpreter(Override.class, type);
    }

    public static boolean hasInterpreter(Class<? extends Annotation> anno, Class<?> type) {
        return ((ObjectMap)((Object)interpreters.get((Class<Annotation>)anno, (ObjectMap<Class<?>, FieldInterpreter<?>>)((Object)((Prov<ObjectMap>)ObjectMap::new))))).containsKey(MapObjectivesDialog.unbox(type));
    }

    public static <T> FieldInterpreter<T> getInterpreter(Class<T> type) {
        return MapObjectivesDialog.getInterpreter(Override.class, type);
    }

    public static <T> FieldInterpreter<T> getInterpreter(Class<? extends Annotation> anno, Class<T> type) {
        if (MapObjectivesDialog.hasInterpreter(anno, type)) {
            return (FieldInterpreter)((ObjectMap)((Object)interpreters.get((Class<Annotation>)anno, (ObjectMap<Class<?>, FieldInterpreter<?>>)((Object)((Prov<ObjectMap>)ObjectMap::new))))).get(MapObjectivesDialog.unbox(type));
        }
        if (MapObjectivesDialog.hasInterpreter(Override.class, type)) {
            return (FieldInterpreter)((ObjectMap)((Object)interpreters.get((Class<Annotation>)Override.class, (ObjectMap<Class<?>, FieldInterpreter<?>>)((Object)((Prov<ObjectMap>)ObjectMap::new))))).get(MapObjectivesDialog.unbox(type));
        }
        if (type.isArray() && !type.getComponentType().isPrimitive()) {
            return MapObjectivesDialog.hasInterpreter(anno, Object[].class) ? interpreters.get(anno).get(Object[].class) : interpreters.get(Override.class).get(Object[].class);
        }
        throw new IllegalArgumentException("Interpreter for type " + type + " not set up yet.");
    }

    public static <T> void setProvider(Class<T> type, FieldProvider<T> provider) {
        providers.put(MapObjectivesDialog.unbox(type), provider);
    }

    public static boolean hasProvider(Class<?> type) {
        return providers.containsKey(MapObjectivesDialog.unbox(type));
    }

    public static <T> FieldProvider<T> getProvider(Class<T> type) {
        return providers.getThrow(MapObjectivesDialog.unbox(type), () -> new IllegalArgumentException("Provider for type " + type + " not set up yet."));
    }

    static {
        MapObjectivesDialog.setProvider(String.class, (type, cons) -> cons.get(""));
        MapObjectivesDialog.setInterpreter(String.class, (cont, name, type, field, remover, indexer, get, set) -> {
            MapObjectivesDialog.name(cont, name, remover, indexer);
            if (field != null && field.isAnnotationPresent(MapObjectives.Multiline.class)) {
                cont.area((String)get.get(), set).height(100.0f).growX();
            } else {
                cont.field((String)get.get(), set).growX();
            }
        });
        MapObjectivesDialog.setProvider(Boolean.TYPE, (type, cons) -> cons.get(false));
        MapObjectivesDialog.setInterpreter(Boolean.TYPE, (cont, name, type, field, remover, indexer, get, set) -> {
            MapObjectivesDialog.name(cont, name, remover, indexer);
            cont.check("", (Boolean)get.get(), set::get).growX().fillY().get().getLabelCell().growX();
        });
        MapObjectivesDialog.setProvider(Byte.TYPE, (type, cons) -> cons.get((byte)0));
        MapObjectivesDialog.setInterpreter(Byte.TYPE, (cont, name, type, field, remover, indexer, get, set) -> {
            MapObjectivesDialog.name(cont, name, remover, indexer);
            cont.field(Byte.toString((Byte)get.get()), str -> set.get((byte)Strings.parseInt(str))).growX().fillY().valid(Strings::canParseInt).get().setFilter(TextField.TextFieldFilter.digitsOnly);
        });
        MapObjectivesDialog.setProvider(Integer.TYPE, (type, cons) -> cons.get(0));
        MapObjectivesDialog.setInterpreter(Integer.TYPE, (cont, name, type, field, remover, indexer, get, set) -> {
            MapObjectivesDialog.name(cont, name, remover, indexer);
            cont.field(Integer.toString((Integer)get.get()), str -> set.get(Strings.parseInt(str))).growX().fillY().valid(Strings::canParseInt).get().setFilter(TextField.TextFieldFilter.digitsOnly);
        });
        MapObjectivesDialog.setProvider(Float.TYPE, (type, cons) -> cons.get(Float.valueOf(0.0f)));
        MapObjectivesDialog.setInterpreter(Float.TYPE, (cont, name, type, field, remover, indexer, get, set) -> {
            float m = 1.0f;
            if (field != null) {
                if (field.isAnnotationPresent(MapObjectives.Second.class)) {
                    m = 60.0f;
                } else if (field.isAnnotationPresent(MapObjectives.TilePos.class)) {
                    m = 8.0f;
                }
            }
            float mult = m;
            MapObjectivesDialog.name(cont, name, remover, indexer);
            cont.field(Float.toString(((Float)get.get()).floatValue() / mult), str -> set.get(Float.valueOf(Strings.parseFloat(str) * mult))).growX().fillY().valid(Strings::canParseFloat).get().setFilter(TextField.TextFieldFilter.floatsOnly);
        });
        MapObjectivesDialog.setProvider(UnlockableContent.class, (type, cons) -> cons.get(Blocks.coreShard));
        MapObjectivesDialog.setInterpreter(UnlockableContent.class, (cont, name, type, field, remover, indexer, get, set) -> {
            MapObjectivesDialog.name(cont, name, remover, indexer);
            cont.table((Table t) -> t.left().button((Button b) -> b.image().size(24.0f).scaling(Scaling.fit).update((T i) -> i.setDrawable(((UnlockableContent)get.get()).uiIcon)), () -> MapObjectivesDialog.showContentSelect(null, set, b -> field != null && !field.isAnnotationPresent(MapObjectives.Researchable.class) || b.techNode != null)).fill().pad(4.0f)).growX().fillY();
        });
        MapObjectivesDialog.setProvider(Block.class, (type, cons) -> cons.get(Blocks.copperWall));
        MapObjectivesDialog.setInterpreter(Block.class, (cont, name, type, field, remover, indexer, get, set) -> {
            MapObjectivesDialog.name(cont, name, remover, indexer);
            cont.table((Table t) -> t.left().button((Button b) -> b.image().size(24.0f).update((T i) -> i.setDrawable(((Block)get.get()).uiIcon)), () -> MapObjectivesDialog.showContentSelect(ContentType.block, set, b -> field != null && !field.isAnnotationPresent(MapObjectives.Synthetic.class) || b.synthetic())).fill().pad(4.0f)).growX().fillY();
        });
        MapObjectivesDialog.setProvider(Item.class, (type, cons) -> cons.get(Items.copper));
        MapObjectivesDialog.setInterpreter(Item.class, (cont, name, type, field, remover, indexer, get, set) -> {
            MapObjectivesDialog.name(cont, name, remover, indexer);
            cont.table((Table t) -> t.left().button((Button b) -> b.image().size(24.0f).update((T i) -> i.setDrawable(((Item)get.get()).uiIcon)), () -> MapObjectivesDialog.showContentSelect(ContentType.item, set, item -> true)).fill().pad(4.0f)).growX().fillY();
        });
        MapObjectivesDialog.setProvider(UnitType.class, (type, cons) -> cons.get(UnitTypes.dagger));
        MapObjectivesDialog.setInterpreter(UnitType.class, (cont, name, type, field, remover, indexer, get, set) -> {
            MapObjectivesDialog.name(cont, name, remover, indexer);
            cont.table((Table t) -> t.left().button((Button b) -> b.image().size(24.0f).update((T i) -> i.setDrawable(((UnitType)get.get()).uiIcon)), () -> MapObjectivesDialog.showContentSelect(ContentType.unit, set, unit -> true)).fill().pad(4.0f)).growX().fillY();
        });
        MapObjectivesDialog.setProvider(Team.class, (type, cons) -> cons.get(Team.sharded));
        MapObjectivesDialog.setInterpreter(Team.class, (cont, name, type, field, remover, indexer, get, set) -> {
            MapObjectivesDialog.name(cont, name, remover, indexer);
            cont.table((Table t) -> t.left().button((Button b) -> b.image(Tex.whiteui).size(24.0f).update((T i) -> i.setColor(((Team)get.get()).color)), (Button.ButtonStyle)Styles.squarei, () -> MapObjectivesDialog.showTeamSelect(set)).fill().pad(4.0f)).growX().fillY();
        });
        MapObjectivesDialog.setProvider(Color.class, (type, cons) -> cons.get(Pal.accent.cpy()));
        MapObjectivesDialog.setInterpreter(Color.class, (cont, name, type, field, remover, indexer, get, set) -> {
            final Color out = (Color)get.get();
            MapObjectivesDialog.name(cont, name, remover, indexer);
            cont.table((Table t) -> t.left().button((Button b) -> b.stack(new Image(Tex.alphaBg), new Image(Tex.whiteui){
                {
                    super(arg0);
                    this.update(() -> this.setColor(out));
                }
            }).grow(), (Button.ButtonStyle)Styles.squarei, () -> Vars.ui.picker.show(out, (Color res) -> set.get(out.set((Color)res)))).margin(4.0f).pad(4.0f).size(50.0f)).growX().fillY();
        });
        MapObjectivesDialog.setProvider(Vec2.class, (type, cons) -> cons.get(new Vec2()));
        MapObjectivesDialog.setInterpreter(Vec2.class, (cont, name, type, field, remover, indexer, get, set) -> {
            Vec2 obj = (Vec2)get.get();
            MapObjectivesDialog.name(cont, name, remover, indexer);
            cont.table((Table t) -> {
                boolean isInt = type.raw == Integer.TYPE;
                FieldInterpreter<Number> in = MapObjectivesDialog.getInterpreter(Float.TYPE);
                if (isInt) {
                    in = MapObjectivesDialog.getInterpreter(Integer.TYPE);
                }
                in.build((Table)t, "x", new TypeInfo(isInt ? Integer.TYPE : Float.TYPE), field, null, null, (Prov<Number>)(isInt ? () -> (int)obj.x : () -> Float.valueOf(obj.x)), res -> {
                    obj.x = isInt ? (float)((Integer)res).intValue() : ((Float)res).floatValue();
                    set.get(obj);
                });
                in.build(t.row(), "y", new TypeInfo(isInt ? Integer.TYPE : Float.TYPE), field, null, null, isInt ? () -> (int)obj.y : () -> Float.valueOf(obj.y), res -> {
                    obj.y = isInt ? (float)((Integer)res).intValue() : ((Float)res).floatValue();
                    set.get(obj);
                });
            }).growX().fillY();
        });
        MapObjectivesDialog.setProvider(Point2.class, (type, cons) -> cons.get(new Point2()));
        MapObjectivesDialog.setInterpreter(Point2.class, (cont, name, type, field, remover, indexer, get, set) -> {
            Point2 obj = (Point2)get.get();
            Vec2 vec = new Vec2(obj.x, obj.y);
            MapObjectivesDialog.getInterpreter(Vec2.class).build(cont, name, new TypeInfo(Integer.TYPE), field, remover, indexer, () -> vec, res -> {
                vec.set((Vec2)res);
                set.get(obj.set((int)vec.x, (int)vec.y));
            });
        });
        MapObjectivesDialog.setProvider(MapObjectives.MapObjective.class, (type, cons) -> new BaseDialog("@add"){
            {
                super(arg0);
                this.cont.pane((Table p) -> {
                    p.background(Tex.button);
                    p.marginRight(14.0f);
                    p.defaults().size(195.0f, 56.0f);
                    int i = 0;
                    for (Prov<? extends MapObjectives.MapObjective> gen : MapObjectives.allObjectiveTypes) {
                        MapObjectives.MapObjective obj = gen.get();
                        p.button(obj.typeName(), Styles.flatt, () -> {
                            cons.get(obj);
                            this.hide();
                        }).with(Table::left).get().getLabelCell().growX().left().padLeft(5.0f).labelAlign(8);
                        if (++i % 3 != 0) continue;
                        p.row();
                    }
                }).scrollX(false);
                this.addCloseButton();
                this.show();
            }
        });
        MapObjectivesDialog.setProvider(MapObjectives.ObjectiveMarker.class, (type, cons) -> new BaseDialog("@add"){
            {
                super(arg0);
                this.cont.pane((Table p) -> {
                    p.background(Tex.button);
                    p.marginRight(14.0f);
                    p.defaults().size(195.0f, 56.0f);
                    int i = 0;
                    for (Prov<? extends MapObjectives.ObjectiveMarker> gen : MapObjectives.allMarkerTypes) {
                        MapObjectives.ObjectiveMarker marker = gen.get();
                        p.button(marker.typeName(), Styles.flatt, () -> {
                            cons.get(marker);
                            this.hide();
                        }).with(Table::left).get().getLabelCell().growX().left().padLeft(5.0f).labelAlign(8);
                        if (++i % 3 != 0) continue;
                        p.row();
                    }
                }).scrollX(false);
                this.addCloseButton();
                this.show();
            }
        });
        MapObjectivesDialog.setInterpreter(MapObjectives.Vertices.class, float[].class, (cont, name, type, field, remover, indexer, get, set) -> cont.table((Table main) -> {
            float[] data = (float[])get.get();
            MapObjectivesDialog.name(cont, name, remover, indexer);
            cont.table((Table t) -> {
                t.left().defaults().left();
                String[] names = new String[]{"x", "y", "color", "u", "v"};
                int stride = 6;
                int vertices = data.length / stride;
                for (int i = 0; i < vertices; ++i) {
                    int offset = i * stride;
                    t.table((Table row) -> {
                        for (int j = 0; j < names.length; ++j) {
                            int index = offset + j;
                            if ("color".equals(names[j])) {
                                MapObjectivesDialog.getInterpreter(Color.class).build((Table)row, names[j], new TypeInfo(Color.class), null, null, null, () -> new Color().abgr8888(data[index]), value -> {
                                    data[index] = value.toFloatBits();
                                });
                            } else {
                                float scale = j <= 1 ? 8.0f : 1.0f;
                                MapObjectivesDialog.getInterpreter(Float.TYPE).build((Table)row, names[j], new TypeInfo(Float.TYPE), null, null, null, () -> Float.valueOf(data[index] / scale), value -> {
                                    data[index] = value.floatValue() * scale;
                                });
                            }
                            row.add().pad(4.0f);
                        }
                    }).row();
                }
            });
        }));
        MapObjectivesDialog.setInterpreter(MapObjectives.Alignment.class, Integer.TYPE, (cont, name, type, field, remover, indexer, get, set) -> {
            MapObjectives.Alignment align = field.getAnnotation(MapObjectives.Alignment.class);
            MapObjectivesDialog.name(cont, name, remover, indexer);
            cont.button((Button b) -> {
                b.label(() -> LStatement.alignToName.get((int)((Integer)get.get()), "center"));
                b.clicked(() -> LStatement.showAlignSelect(b, (Integer)get.get(), set::get, align.hor(), align.ver()));
            }, () -> {});
        });
        for (Prov<? extends MapObjectives.MapObjective> prov : MapObjectives.allObjectiveTypes) {
            MapObjectivesDialog.setInterpreter(prov.get().getClass(), MapObjectivesDialog.defaultInterpreter());
        }
        for (Prov<Object> prov : MapObjectives.allMarkerTypes) {
            MapObjectivesDialog.setInterpreter(((MapObjectives.ObjectiveMarker)prov.get()).getClass(), MapObjectivesDialog.defaultInterpreter());
        }
        MapObjectivesDialog.setInterpreter(MapObjectives.LabelFlag.class, Byte.TYPE, (cont, name, type, field, remover, indexer, get, set) -> {
            MapObjectivesDialog.name(cont, name, remover, indexer);
            cont.table((Table t) -> {
                t.left().defaults().left();
                byte value = (Byte)get.get();
                byte bg = 1;
                byte out = 2;
                t.check("@marker.background", (value & bg) == bg, res -> set.get((byte)(res ? value | bg : value & ~bg))).growX().fillY().padTop(4.0f).padBottom(4.0f).get().getLabelCell().growX();
                t.row();
                t.check("@marker.outline", (value & out) == out, res -> set.get((byte)(res ? value | out : value & ~out))).growX().fillY().get().getLabelCell().growX();
            }).growX().fillY();
        });
        MapObjectivesDialog.setProvider(Seq.class, (type, cons) -> cons.get(new Seq(type.element.raw)));
        MapObjectivesDialog.setInterpreter(Seq.class, (cont, name, type, field, remover, indexer, get, set) -> cont.table((Table main) -> {
            Runnable[] rebuild = new Runnable[]{null};
            Seq arr = (Seq)get.get();
            main.margin(0.0f, 10.0f, 0.0f, 10.0f);
            Table header = main.table(Tex.button, t -> {
                t.left();
                t.margin(10.0f);
                if (name.length() > 0) {
                    t.add(name + ":").color(Pal.accent);
                }
                t.add().growX();
                if (remover != null) {
                    t.button((Drawable)Icon.trash, Styles.emptyi, remover).fill().padRight(4.0f);
                }
                if (indexer != null) {
                    t.button((Drawable)Icon.upOpen, Styles.emptyi, () -> indexer.get(true)).fill().padRight(4.0f);
                    t.button((Drawable)Icon.downOpen, Styles.emptyi, () -> indexer.get(false)).fill().padRight(4.0f);
                }
                if (!field.isAnnotationPresent(MapObjectives.Immutable.class)) {
                    t.button((Drawable)Icon.add, Styles.emptyi, () -> MapObjectivesDialog.getProvider(type.element.raw).get(type.element, res -> {
                        arr.add(res);
                        rebuild[0].run();
                    })).fill();
                }
            }).growX().height(46.0f).pad(0.0f, -10.0f, 0.0f, -10.0f).get();
            main.row().table(Tex.button, t -> {
                rebuild[0] = () -> {
                    t.clear();
                    t.top();
                    if (arr.isEmpty()) {
                        t.background(Tex.clear).margin(0.0f).setSize(0.0f);
                    } else {
                        t.background(Tex.button).margin(10.0f).marginTop(20.0f);
                    }
                    int len = arr.size;
                    for (int i = 0; i < len; ++i) {
                        int index = i;
                        if (index > 0) {
                            t.row();
                        }
                        MapObjectivesDialog.getInterpreter(arr.get(index).getClass()).build((Table)t, "", new TypeInfo(arr.get(index).getClass()), field, field == null || !field.isAnnotationPresent(MapObjectives.Immutable.class) ? () -> {
                            arr.remove(index);
                            rebuild[0].run();
                        } : null, field == null || !field.isAnnotationPresent(MapObjectives.Unordered.class) ? in -> {
                            if (in && index > 0) {
                                arr.swap(index, index - 1);
                                rebuild[0].run();
                            } else if (!in && index < len - 1) {
                                arr.swap(index, index + 1);
                                rebuild[0].run();
                            }
                        } : null, () -> arr.get(index), res -> {
                            arr.set(index, res);
                            set.get(arr);
                        });
                    }
                    set.get(arr);
                };
            }).padTop(-10.0f).growX().fillY();
            rebuild[0].run();
            header.toFront();
        }).growX().fillY().pad(4.0f).colspan(2));
        MapObjectivesDialog.setProvider(Object[].class, (type, cons) -> cons.get(Reflect.newArray(type.element.raw, 0)));
        MapObjectivesDialog.setInterpreter(Object[].class, (cont, name, type, field, remover, indexer, get, set) -> {
            Seq<Object> arr = Seq.with((Object[])get.get());
            MapObjectivesDialog.getInterpreter(Seq.class).build(cont, name, new TypeInfo(Seq.class, type.element), field, remover, indexer, () -> arr, res -> set.get(arr.toArray(type.element.raw)));
        });
    }

    public static interface FieldInterpreter<T> {
        public void build(Table var1, CharSequence var2, TypeInfo var3, @Nullable Field var4, @Nullable Runnable var5, @Nullable Boolc var6, Prov<T> var7, Cons<T> var8);
    }

    public static interface FieldProvider<T> {
        public void get(TypeInfo var1, Cons<T> var2);
    }

    public static class TypeInfo {
        public final Class<?> raw;
        public final TypeInfo element;
        public final TypeInfo key;

        public TypeInfo(Field field) {
            this(field.getType(), field.getGenericType());
        }

        public TypeInfo(Class<?> raw) {
            this(raw, raw);
        }

        public TypeInfo(Class<?> raw, TypeInfo element) {
            this.raw = MapObjectivesDialog.unbox(raw);
            this.element = element;
            this.key = null;
        }

        public TypeInfo(Class<?> raw, Type generic) {
            this.raw = MapObjectivesDialog.unbox(raw);
            if (raw.isArray()) {
                Type type;
                this.key = null;
                Class<?> clazz = raw.getComponentType();
                if (generic instanceof GenericArrayType) {
                    GenericArrayType type2 = (GenericArrayType)generic;
                    type = type2.getGenericComponentType();
                } else {
                    type = raw.getComponentType();
                }
                this.element = new TypeInfo(clazz, type);
            } else if (Seq.class.isAssignableFrom(raw)) {
                this.key = null;
                this.element = TypeInfo.getParam(generic, 0);
            } else if (ObjectMap.class.isAssignableFrom(raw)) {
                this.key = TypeInfo.getParam(generic, 0);
                this.element = TypeInfo.getParam(generic, 1);
            } else {
                this.element = null;
                this.key = null;
            }
        }

        public static TypeInfo getParam(Type generic, int index) {
            Type[] params;
            Type[] typeArray;
            if (generic instanceof ParameterizedType) {
                ParameterizedType type = (ParameterizedType)generic;
                typeArray = type.getActualTypeArguments();
            } else if (generic instanceof GenericDeclaration) {
                GenericDeclaration type = (GenericDeclaration)((Object)generic);
                typeArray = type.getTypeParameters();
            } else {
                typeArray = params = null;
            }
            if (params != null && index < params.length) {
                Type target = params[index];
                return new TypeInfo(TypeInfo.raw(target), target);
            }
            return new TypeInfo((Class<?>)Object.class, (Type)((Object)Object.class));
        }

        public static Class<?> raw(Type type) {
            if (type instanceof Class) {
                Class c = (Class)type;
                return c;
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType c = (ParameterizedType)type;
                return (Class)c.getRawType();
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType c = (GenericArrayType)type;
                return Reflect.newArray(TypeInfo.raw(c.getGenericComponentType()), 0).getClass();
            }
            if (type instanceof TypeVariable) {
                TypeVariable c = (TypeVariable)type;
                return TypeInfo.raw(c.getBounds()[0]);
            }
            return Object.class;
        }
    }
}

