/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.event.ElementGestureListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.ui.Button;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.editor.MapObjectivesDialog;
import mindustry.game.MapObjectives;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class MapObjectivesCanvas
extends WidgetGroup {
    public static final int objWidth = 5;
    public static final int objHeight = 2;
    public static final int bounds = 100;
    public final float unitSize = Scl.scl(48.0f);
    public Seq<MapObjectives.MapObjective> objectives = new Seq();
    public ObjectiveTilemap tilemap;
    protected MapObjectives.MapObjective query;
    private boolean pressed;
    private long visualPressed;
    private int queryX = -5;
    private int queryY = -2;

    public MapObjectivesCanvas() {
        this.setFillParent(true);
        this.tilemap = new ObjectiveTilemap();
        this.addChild(this.tilemap);
        this.addCaptureListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                if (MapObjectivesCanvas.this.query != null && button == KeyCode.mouseRight) {
                    MapObjectivesCanvas.this.stopQuery();
                    event.stop();
                    return true;
                }
                return false;
            }
        });
        this.addCaptureListener(new ElementGestureListener(){
            int pressPointer = -1;

            @Override
            public void pan(InputEvent event, float x, float y, float deltaX, float deltaY) {
                if (MapObjectivesCanvas.this.tilemap.moving != null || MapObjectivesCanvas.this.tilemap.connecting != null) {
                    return;
                }
                MapObjectivesCanvas.this.tilemap.x = Mathf.clamp(MapObjectivesCanvas.this.tilemap.x + deltaX, -100.0f * MapObjectivesCanvas.this.unitSize + MapObjectivesCanvas.this.width, 100.0f * MapObjectivesCanvas.this.unitSize);
                MapObjectivesCanvas.this.tilemap.y = Mathf.clamp(MapObjectivesCanvas.this.tilemap.y + deltaY, -100.0f * MapObjectivesCanvas.this.unitSize + MapObjectivesCanvas.this.height, 100.0f * MapObjectivesCanvas.this.unitSize);
            }

            @Override
            public void tap(InputEvent event, float x, float y, int count, KeyCode button) {
                if (MapObjectivesCanvas.this.query == null) {
                    return;
                }
                Vec2 pos = MapObjectivesCanvas.this.localToDescendantCoordinates(MapObjectivesCanvas.this.tilemap, Tmp.v1.set(x, y));
                MapObjectivesCanvas.this.queryX = Mathf.round((pos.x - 5.0f * MapObjectivesCanvas.this.unitSize / 2.0f) / MapObjectivesCanvas.this.unitSize);
                MapObjectivesCanvas.this.queryY = Mathf.floor((pos.y - MapObjectivesCanvas.this.unitSize) / MapObjectivesCanvas.this.unitSize);
                if (!Vars.mobile) {
                    MapObjectivesCanvas.this.placeQuery();
                }
            }

            @Override
            public void touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                if (this.pressPointer != -1) {
                    return;
                }
                this.pressPointer = pointer;
                MapObjectivesCanvas.this.pressed = true;
                MapObjectivesCanvas.this.visualPressed = Time.millis() + 100L;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                if (pointer == this.pressPointer) {
                    this.pressPointer = -1;
                    MapObjectivesCanvas.this.pressed = false;
                }
            }
        });
    }

    public void clearObjectives() {
        this.stopQuery();
        this.tilemap.clearTiles();
        this.tilemap.x = 0.0f;
        this.tilemap.y = 0.0f;
    }

    protected void stopQuery() {
        if (this.query == null) {
            return;
        }
        this.query = null;
        Core.graphics.restoreCursor();
    }

    public void query(MapObjectives.MapObjective obj) {
        this.stopQuery();
        this.query = obj;
    }

    public void placeQuery() {
        if (this.isQuerying() && this.tilemap.createTile(this.queryX, this.queryY, this.query)) {
            this.objectives.add(this.query);
            this.stopQuery();
        }
    }

    public boolean isQuerying() {
        return this.query != null;
    }

    public boolean isVisualPressed() {
        return this.pressed || this.visualPressed > Time.millis();
    }

    public class ObjectiveTilemap
    extends WidgetGroup {
        @Nullable
        protected ObjectiveTile.Connector connecting;
        @Nullable
        protected ObjectiveTile moving;

        public ObjectiveTilemap() {
            this.setTransform(false);
            this.setSize(this.getPrefWidth(), this.getPrefHeight());
            this.touchable(() -> MapObjectivesCanvas.this.isQuerying() ? Touchable.disabled : Touchable.childrenOnly);
        }

        @Override
        public void draw() {
            Vec2 pos;
            int ty;
            int tx;
            this.validate();
            int minX = Math.max(Mathf.floor((this.x - this.width - 1.0f) / MapObjectivesCanvas.this.unitSize), -100);
            int minY = Math.max(Mathf.floor((this.y - this.height - 1.0f) / MapObjectivesCanvas.this.unitSize), -100);
            int maxX = Math.min(Mathf.ceil((this.x + this.width + 1.0f) / MapObjectivesCanvas.this.unitSize), 100);
            int maxY = Math.min(Mathf.ceil((this.y + this.height + 1.0f) / MapObjectivesCanvas.this.unitSize), 100);
            float progX = this.x % MapObjectivesCanvas.this.unitSize;
            float progY = this.y % MapObjectivesCanvas.this.unitSize;
            Lines.stroke(3.0f);
            Draw.color(Pal.darkestGray, this.parentAlpha);
            for (int x = minX; x <= maxX; ++x) {
                Lines.line(progX + (float)x * MapObjectivesCanvas.this.unitSize, (float)minY * MapObjectivesCanvas.this.unitSize, progX + (float)x * MapObjectivesCanvas.this.unitSize, (float)maxY * MapObjectivesCanvas.this.unitSize);
            }
            for (int y = minY; y <= maxY; ++y) {
                Lines.line((float)minX * MapObjectivesCanvas.this.unitSize, progY + (float)y * MapObjectivesCanvas.this.unitSize, (float)maxX * MapObjectivesCanvas.this.unitSize, progY + (float)y * MapObjectivesCanvas.this.unitSize);
            }
            if (MapObjectivesCanvas.this.isQuerying()) {
                if (Vars.mobile) {
                    tx = MapObjectivesCanvas.this.queryX;
                    ty = MapObjectivesCanvas.this.queryY;
                } else {
                    pos = this.screenToLocalCoordinates(Core.input.mouse());
                    tx = Mathf.round((pos.x - 5.0f * MapObjectivesCanvas.this.unitSize / 2.0f) / MapObjectivesCanvas.this.unitSize);
                    ty = Mathf.floor((pos.y - MapObjectivesCanvas.this.unitSize) / MapObjectivesCanvas.this.unitSize);
                }
                Lines.stroke(4.0f);
                Draw.color(MapObjectivesCanvas.this.isVisualPressed() ? Pal.metalGrayDark : (this.validPlace(tx, ty, null) ? Pal.accent : Pal.remove), this.parentAlpha);
                Lines.rect(this.x + (float)tx * MapObjectivesCanvas.this.unitSize, this.y + (float)ty * MapObjectivesCanvas.this.unitSize, 5.0f * MapObjectivesCanvas.this.unitSize, 2.0f * MapObjectivesCanvas.this.unitSize);
            }
            if (this.moving != null) {
                tx = Mathf.round(this.moving.x / MapObjectivesCanvas.this.unitSize);
                float x = this.x + (float)tx * MapObjectivesCanvas.this.unitSize;
                ty = Mathf.round(this.moving.y / MapObjectivesCanvas.this.unitSize);
                float y = this.y + (float)ty * MapObjectivesCanvas.this.unitSize;
                Draw.color(this.validPlace(tx, ty, this.moving) ? Pal.accent : Pal.remove, 0.5f * this.parentAlpha);
                Fill.crect(x, y, 5.0f * MapObjectivesCanvas.this.unitSize, 2.0f * MapObjectivesCanvas.this.unitSize);
            }
            Draw.reset();
            super.draw();
            Draw.reset();
            Seq tiles = this.getChildren().as();
            Element conTarget = null;
            if (this.connecting != null) {
                ObjectiveTile.Connector con;
                pos = this.connecting.localToAscendantCoordinates(this, Tmp.v1.set(this.connecting.pointX, this.connecting.pointY));
                Element element = this.hit(pos.x, pos.y, true);
                if (element instanceof ObjectiveTile.Connector && this.connecting.canConnectTo(con = (ObjectiveTile.Connector)element)) {
                    conTarget = con;
                }
            }
            boolean removing = false;
            for (ObjectiveTile tile : tiles) {
                for (MapObjectives.MapObjective parent : tile.obj.parents) {
                    ObjectiveTile parentTile = tiles.find((T t) -> t.obj == parent);
                    if (parentTile == null) continue;
                    ObjectiveTile.Connector conFrom = parentTile.conChildren;
                    ObjectiveTile.Connector conTo = tile.conParent;
                    if (conTarget != null && (this.connecting.findParent && this.connecting == conTo && conTarget == conFrom || !this.connecting.findParent && this.connecting == conFrom && conTarget == conTo)) {
                        removing = true;
                        continue;
                    }
                    Vec2 from = conFrom.localToAscendantCoordinates(this, Tmp.v1.set(conFrom.getWidth() / 2.0f, conFrom.getHeight() / 2.0f)).add(this.x, this.y);
                    Vec2 to = conTo.localToAscendantCoordinates(this, Tmp.v2.set(conTo.getWidth() / 2.0f, conTo.getHeight() / 2.0f)).add(this.x, this.y);
                    this.drawCurve(false, from.x, from.y, to.x, to.y);
                }
            }
            if (this.connecting != null) {
                Vec2 mouse = (conTarget == null ? this.connecting.localToAscendantCoordinates(this, Tmp.v1.set(this.connecting.pointX, this.connecting.pointY)) : conTarget.localToAscendantCoordinates(this, Tmp.v1.set(conTarget.getWidth() / 2.0f, conTarget.getHeight() / 2.0f))).add(this.x, this.y);
                Vec2 anchor = this.connecting.localToAscendantCoordinates(this, Tmp.v2.set(this.connecting.getWidth() / 2.0f, this.connecting.getHeight() / 2.0f)).add(this.x, this.y);
                Vec2 from = this.connecting.findParent ? mouse : anchor;
                Vec2 to = this.connecting.findParent ? anchor : mouse;
                this.drawCurve(removing, from.x, from.y, to.x, to.y);
            }
            Draw.reset();
        }

        protected void drawCurve(boolean remove, float x1, float y1, float x2, float y2) {
            Lines.stroke(4.0f);
            Draw.color(remove ? Pal.remove : Pal.accent, this.parentAlpha);
            Fill.square(x1, y1, 8.0f, 45.0f);
            Fill.square(x2, y2, 8.0f, 45.0f);
            float dist = Math.abs(x1 - x2) / 2.0f;
            float cx1 = x1 + dist;
            float cx2 = x2 - dist;
            Lines.curve(x1, y1, cx1, y1, cx2, y2, x2, y2, Math.max(4, (int)(Mathf.dst(x1, y1, x2, y2) / 4.0f)));
            float progress = Time.time % 240.0f / 240.0f;
            float t2 = progress * progress;
            float t3 = progress * t2;
            float t1 = 1.0f - progress;
            float t13 = t1 * t1 * t1;
            float kx1 = t13 * x1 + 3.0f * progress * t1 * t1 * cx1 + 3.0f * t2 * t1 * cx2 + t3 * x2;
            float ky1 = t13 * y1 + 3.0f * progress * t1 * t1 * y1 + 3.0f * t2 * t1 * y2 + t3 * y2;
            Fill.circle(kx1, ky1, 6.0f);
            Draw.reset();
        }

        public boolean validPlace(int x, int y, @Nullable ObjectiveTile ignore) {
            Tmp.r1.set(x, y, 5.0f, 2.0f).grow(-0.001f);
            if (!Tmp.r2.setCentered(0.0f, 0.0f, 200.0f, 200.0f).contains(Tmp.r1)) {
                return false;
            }
            for (Element other : this.children) {
                ObjectiveTile tile;
                if (!(other instanceof ObjectiveTile) || (tile = (ObjectiveTile)other) == ignore || !Tmp.r2.set(tile.tx, tile.ty, 5.0f, 2.0f).overlaps(Tmp.r1)) continue;
                return false;
            }
            return true;
        }

        public boolean createTile(MapObjectives.MapObjective obj) {
            return this.createTile(obj.editorX, obj.editorY, obj);
        }

        public boolean createTile(int x, int y, MapObjectives.MapObjective obj) {
            if (!this.validPlace(x, y, null)) {
                return false;
            }
            ObjectiveTile tile = new ObjectiveTile(obj, x, y);
            tile.pack();
            this.addChild(tile);
            return true;
        }

        public boolean moveTile(ObjectiveTile tile, int newX, int newY) {
            if (!this.validPlace(newX, newY, tile)) {
                return false;
            }
            tile.pos(newX, newY);
            return true;
        }

        public void removeTile(ObjectiveTile tile) {
            if (!tile.isDescendantOf(this)) {
                return;
            }
            tile.remove();
        }

        public void clearTiles() {
            this.clearChildren();
        }

        @Override
        public float getPrefWidth() {
            return 100.0f * MapObjectivesCanvas.this.unitSize;
        }

        @Override
        public float getPrefHeight() {
            return 100.0f * MapObjectivesCanvas.this.unitSize;
        }

        public class ObjectiveTile
        extends Table {
            public final MapObjectives.MapObjective obj;
            public int tx;
            public int ty;
            public final Mover mover;
            public final Connector conParent;
            public final Connector conChildren;

            public ObjectiveTile(MapObjectives.MapObjective obj, int x, int y) {
                this.obj = obj;
                this.setTransform(false);
                this.setClip(false);
                this.conParent = new Connector(true);
                this.add(this.conParent).size(MapObjectivesCanvas.this.unitSize / Scl.scl(1.0f), MapObjectivesCanvas.this.unitSize * 2.0f / Scl.scl(1.0f));
                this.mover = new Mover();
                this.table(Tex.whiteui, t -> {
                    float pad = (MapObjectivesCanvas.this.unitSize / Scl.scl(1.0f) - 32.0f) / 2.0f - 4.0f;
                    t.margin(pad);
                    t.touchable(() -> Touchable.enabled);
                    t.setColor(Pal.gray);
                    t.labelWrap(obj.typeName()).style(Styles.outlineLabel).left().grow().get().setAlignment(8);
                    t.row();
                    t.table((Table b) -> {
                        b.left().defaults().size(40.0f);
                        b.button(Icon.pencilSmall, () -> {
                            BaseDialog dialog = new BaseDialog("@editor.objectives");
                            dialog.cont.pane(Styles.noBarPane, (Table list) -> list.top().table((Table e) -> {
                                e.margin(0.0f);
                                MapObjectivesDialog.getInterpreter(obj.getClass()).build((Table)e, obj.typeName(), new MapObjectivesDialog.TypeInfo(obj.getClass()), null, null, null, () -> obj, res -> {});
                            }).width(Math.min((float)Core.graphics.getWidth() * 0.95f / Scl.scl(1.0f) - Scl.scl(20.0f), 700.0f)).fillY()).grow();
                            dialog.addCloseButton();
                            dialog.show();
                        });
                        b.button(Icon.trashSmall, () -> ObjectiveTilemap.this.removeTile(this));
                    }).left().grow();
                }).growX().height(MapObjectivesCanvas.this.unitSize / Scl.scl(1.0f) * 2.0f).get().addCaptureListener(this.mover);
                this.conChildren = new Connector(false);
                this.add(this.conChildren).size(MapObjectivesCanvas.this.unitSize / Scl.scl(1.0f), MapObjectivesCanvas.this.unitSize / Scl.scl(1.0f) * 2.0f);
                this.setSize(this.getPrefWidth(), this.getPrefHeight());
                this.pos(x, y);
            }

            public void pos(int x, int y) {
                this.tx = this.obj.editorX = x;
                this.ty = this.obj.editorY = y;
                this.x = (float)x * MapObjectivesCanvas.this.unitSize;
                this.y = (float)y * MapObjectivesCanvas.this.unitSize;
            }

            @Override
            public float getPrefWidth() {
                return 5.0f * MapObjectivesCanvas.this.unitSize;
            }

            @Override
            public float getPrefHeight() {
                return 2.0f * MapObjectivesCanvas.this.unitSize;
            }

            @Override
            public boolean remove() {
                if (super.remove()) {
                    this.obj.parents.clear();
                    Iterator<MapObjectives.MapObjective> it = MapObjectivesCanvas.this.objectives.iterator();
                    while (it.hasNext()) {
                        MapObjectives.MapObjective next = it.next();
                        if (next == this.obj) {
                            it.remove();
                            continue;
                        }
                        next.parents.remove(this.obj);
                    }
                    return true;
                }
                return false;
            }

            public class Connector
            extends Button {
                public float pointX;
                public float pointY;
                public final boolean findParent;

                public Connector(final boolean findParent) {
                    super(new Button.ButtonStyle(){
                        {
                            this.down = findParent ? Tex.buttonSideLeftDown : Tex.buttonSideRightDown;
                            this.up = findParent ? Tex.buttonSideLeft : Tex.buttonSideRight;
                            this.over = findParent ? Tex.buttonSideLeftOver : Tex.buttonSideRightOver;
                        }
                    });
                    this.findParent = findParent;
                    this.clearChildren();
                    this.addCaptureListener(new InputListener(){
                        int conPointer = -1;

                        @Override
                        public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                            if (this.conPointer != -1) {
                                return false;
                            }
                            this.conPointer = pointer;
                            if (ObjectiveTilemap.this.connecting != null) {
                                return false;
                            }
                            ObjectiveTilemap.this.connecting = Connector.this;
                            Connector.this.pointX = x;
                            Connector.this.pointY = y;
                            return true;
                        }

                        @Override
                        public void touchDragged(InputEvent event, float x, float y, int pointer) {
                            if (this.conPointer != pointer) {
                                return;
                            }
                            Connector.this.pointX = x;
                            Connector.this.pointY = y;
                        }

                        @Override
                        public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                            Connector con;
                            if (this.conPointer != pointer || ObjectiveTilemap.this.connecting != Connector.this) {
                                return;
                            }
                            this.conPointer = -1;
                            Vec2 pos = Connector.this.localToAscendantCoordinates(ObjectiveTilemap.this, Tmp.v1.set(x, y));
                            Element element = ObjectiveTilemap.this.hit(pos.x, pos.y, true);
                            if (element instanceof Connector && (con = (Connector)element).canConnectTo(Connector.this)) {
                                if (findParent) {
                                    if (!ObjectiveTile.this.obj.parents.remove(con.tile().obj)) {
                                        ObjectiveTile.this.obj.parents.add(con.tile().obj);
                                    }
                                } else if (!con.tile().obj.parents.remove(ObjectiveTile.this.obj)) {
                                    con.tile().obj.parents.add(ObjectiveTile.this.obj);
                                }
                            }
                            ObjectiveTilemap.this.connecting = null;
                        }
                    });
                }

                public boolean canConnectTo(Connector other) {
                    return this.findParent != other.findParent && this.tile() != other.tile();
                }

                @Override
                public void draw() {
                    super.draw();
                    float cx = this.x + this.width / 2.0f;
                    float cy = this.y + this.height / 2.0f;
                    Lines.stroke(3.0f, Pal.accent);
                    if (this.findParent) {
                        Lines.line(cx, cy + 9.0f, cx + 9.0f, cy);
                        Lines.line(cx + 9.0f, cy, cx, cy - 9.0f);
                    } else {
                        Lines.square(cx, cy, 9.0f, 45.0f);
                    }
                }

                public ObjectiveTile tile() {
                    return ObjectiveTile.this;
                }

                @Override
                public boolean isPressed() {
                    return super.isPressed() || ObjectiveTilemap.this.connecting == this;
                }

                @Override
                public boolean isOver() {
                    return super.isOver() && (ObjectiveTilemap.this.connecting == null || ObjectiveTilemap.this.connecting.canConnectTo(this));
                }
            }

            public class Mover
            extends InputListener {
                public int prevX;
                public int prevY;
                public float lastX;
                public float lastY;

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                    if (ObjectiveTilemap.this.moving != null) {
                        return false;
                    }
                    ObjectiveTilemap.this.moving = ObjectiveTile.this;
                    ObjectiveTilemap.this.moving.toFront();
                    this.prevX = ObjectiveTilemap.this.moving.tx;
                    this.prevY = ObjectiveTilemap.this.moving.ty;
                    Vec2 pos = event.listenerActor.localToStageCoordinates(Tmp.v1.set(x, y));
                    this.lastX = pos.x;
                    this.lastY = pos.y;
                    return true;
                }

                @Override
                public void touchDragged(InputEvent event, float x, float y, int pointer) {
                    Vec2 pos = event.listenerActor.localToStageCoordinates(Tmp.v1.set(x, y));
                    ObjectiveTilemap.this.moving.moveBy(pos.x - this.lastX, pos.y - this.lastY);
                    this.lastX = pos.x;
                    this.lastY = pos.y;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                    if (!ObjectiveTilemap.this.moveTile(ObjectiveTilemap.this.moving, Mathf.round(ObjectiveTilemap.this.moving.x / MapObjectivesCanvas.this.unitSize), Mathf.round(ObjectiveTilemap.this.moving.y / MapObjectivesCanvas.this.unitSize))) {
                        ObjectiveTilemap.this.moving.pos(this.prevX, this.prevY);
                    }
                    ObjectiveTilemap.this.moving = null;
                }
            }
        }
    }
}

