/*
 * Decompiled with CFR 0.152.
 */
package mindustry.async;

import arc.Events;
import arc.struct.Seq;
import arc.util.Threads;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mindustry.Vars;
import mindustry.async.AsyncProcess;
import mindustry.async.AvoidanceProcess;
import mindustry.async.PhysicsProcess;
import mindustry.game.EventType;

public class AsyncCore {
    public final Seq<AsyncProcess> processes;
    private final Seq<Future<?>> futures;
    private ExecutorService executor;

    public AsyncCore() {
        AsyncProcess[] asyncProcessArray = new AsyncProcess[2];
        asyncProcessArray[0] = new PhysicsProcess();
        Vars.avoidance = new AvoidanceProcess();
        asyncProcessArray[1] = Vars.avoidance;
        this.processes = Seq.with(asyncProcessArray);
        this.futures = new Seq();
        Events.on(EventType.WorldLoadEvent.class, e -> {
            this.complete();
            for (AsyncProcess p : this.processes) {
                p.init();
            }
        });
        Events.on(EventType.ResetEvent.class, e -> {
            this.complete();
            for (AsyncProcess p : this.processes) {
                p.reset();
            }
        });
    }

    public void begin() {
        if (Vars.state.isPlaying()) {
            for (AsyncProcess p : this.processes) {
                p.begin();
            }
            this.futures.clear();
            if (this.executor == null) {
                this.executor = Executors.newFixedThreadPool(this.processes.size, r -> {
                    Thread thread = new Thread(r, "AsyncLogic-Thread");
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler((t, e) -> Threads.throwAppException(e));
                    return thread;
                });
            }
            for (AsyncProcess p : this.processes) {
                if (!p.shouldProcess()) continue;
                this.futures.add(this.executor.submit(p::process));
            }
        }
    }

    public void end() {
        if (Vars.state.isPlaying()) {
            this.complete();
            for (AsyncProcess p : this.processes) {
                p.end();
            }
        }
    }

    private void complete() {
        for (Future<?> future : this.futures) {
            try {
                future.get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        this.futures.clear();
    }
}

