/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import mindustry.Vars;
import mindustry.ai.types.GroundAI;
import mindustry.core.World;
import mindustry.entities.Units;
import mindustry.gen.Building;
import mindustry.gen.Hitboxc;
import mindustry.gen.Teamc;
import mindustry.world.Tile;
import mindustry.world.blocks.distribution.Conveyor;
import mindustry.world.blocks.liquid.Conduit;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.BlockGroup;

public class SuicideAI
extends GroundAI {
    static boolean blockedByBlock;

    @Override
    public void updateUnit() {
        boolean moveToTarget;
        boolean shoot;
        boolean rotate;
        CoreBlock.CoreBuild core;
        block13: {
            block14: {
                float f;
                if (Units.invalidateTarget(this.target, this.unit.team, this.unit.x, this.unit.y, Float.MAX_VALUE)) {
                    this.target = null;
                }
                if (this.retarget()) {
                    this.target = this.target(this.unit.x, this.unit.y, this.unit.range(), this.unit.type.targetAir, this.unit.type.targetGround);
                }
                core = this.unit.closestEnemyCore();
                rotate = false;
                shoot = false;
                moveToTarget = false;
                if (this.target == null) {
                    this.target = core;
                }
                if (Units.invalidateTarget(this.target, this.unit, this.unit.range()) || !this.unit.hasWeapons()) break block13;
                rotate = true;
                float f2 = this.unit.type.weapons.first().bullet.range;
                Teamc teamc = this.target;
                if (teamc instanceof Building) {
                    Building b = (Building)teamc;
                    f = (float)(b.block.size * 8) / 2.0f;
                } else {
                    f = ((Hitboxc)((Object)this.target)).hitSize() / 2.0f;
                }
                shoot = this.unit.within(this.target, f2 + f);
                teamc = this.target;
                if (!(teamc instanceof Building)) break block14;
                Building build = (Building)teamc;
                if (!(build.block instanceof CoreBlock) && (build.block.group == BlockGroup.walls || build.block.group == BlockGroup.liquids || build.block.group == BlockGroup.transportation)) break block13;
            }
            blockedByBlock = false;
            boolean blocked = World.raycast(this.unit.tileX(), this.unit.tileY(), this.target.tileX(), this.target.tileY(), (x, y) -> {
                int n = 0;
                Point2[] point2Array = Geometry.d4c;
                int n2 = point2Array.length;
                if (n < n2) {
                    Point2 p = point2Array[n];
                    Tile tile = Vars.world.tile(x + p.x, y + p.y);
                    if (tile != null && tile.build == this.target) {
                        return false;
                    }
                    if (tile != null && tile.build != null && tile.build.team != this.unit.team()) {
                        blockedByBlock = true;
                        return true;
                    }
                    return tile == null || tile.solid();
                }
                return false;
            });
            if (blockedByBlock) {
                shoot = true;
            }
            if (!blocked) {
                moveToTarget = true;
                this.unit.movePref(vec.set(this.target).sub(this.unit).limit(this.unit.speed()));
            }
        }
        if (!moveToTarget) {
            Tile spawner;
            boolean move = true;
            if (core == null && Vars.state.rules.waves && this.unit.team == Vars.state.rules.defaultTeam && (spawner = this.getClosestSpawner()) != null && this.unit.within(spawner, Vars.state.rules.dropZoneRadius + 120.0f)) {
                move = false;
            }
            if (move) {
                this.pathfind(0);
            }
        }
        this.unit.controlWeapons(rotate, shoot);
        this.faceTarget();
    }

    @Override
    public Teamc target(float x, float y, float range, boolean air, boolean ground) {
        return Units.closestTarget(this.unit.team, x, y, range, u -> u.checkTarget(air, ground), t -> ground && !(t.block instanceof Conveyor) && !(t.block instanceof Conduit));
    }
}

