/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.event;

import arc.input.KeyCode;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.event.EventListener;
import arc.scene.event.InputEvent;
import arc.scene.event.SceneEvent;

public class InputListener
implements EventListener {
    private static final Vec2 tmpCoords = new Vec2();

    @Override
    public boolean handle(SceneEvent e) {
        if (!(e instanceof InputEvent)) {
            return false;
        }
        InputEvent event = (InputEvent)e;
        switch (event.type) {
            case keyDown: {
                return this.keyDown(event, event.keyCode);
            }
            case keyUp: {
                return this.keyUp(event, event.keyCode);
            }
            case keyTyped: {
                return this.keyTyped(event, event.character);
            }
        }
        event.toCoordinates(event.listenerActor, tmpCoords);
        switch (event.type) {
            case touchDown: {
                return this.touchDown(event, InputListener.tmpCoords.x, InputListener.tmpCoords.y, event.pointer, event.keyCode);
            }
            case touchUp: {
                this.touchUp(event, InputListener.tmpCoords.x, InputListener.tmpCoords.y, event.pointer, event.keyCode);
                return true;
            }
            case touchDragged: {
                this.touchDragged(event, InputListener.tmpCoords.x, InputListener.tmpCoords.y, event.pointer);
                return true;
            }
            case mouseMoved: {
                return this.mouseMoved(event, InputListener.tmpCoords.x, InputListener.tmpCoords.y);
            }
            case scrolled: {
                return this.scrolled(event, InputListener.tmpCoords.x, InputListener.tmpCoords.y, event.scrollAmountX, event.scrollAmountY);
            }
            case enter: {
                this.enter(event, InputListener.tmpCoords.x, InputListener.tmpCoords.y, event.pointer, event.relatedActor);
                return false;
            }
            case exit: {
                this.exit(event, InputListener.tmpCoords.x, InputListener.tmpCoords.y, event.pointer, event.relatedActor);
                return false;
            }
        }
        return false;
    }

    public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
        return false;
    }

    public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
    }

    public void touchDragged(InputEvent event, float x, float y, int pointer) {
    }

    public boolean mouseMoved(InputEvent event, float x, float y) {
        return false;
    }

    public void enter(InputEvent event, float x, float y, int pointer, Element fromActor) {
    }

    public void exit(InputEvent event, float x, float y, int pointer, Element toActor) {
    }

    public boolean scrolled(InputEvent event, float x, float y, float amountX, float amountY) {
        return false;
    }

    public boolean keyDown(InputEvent event, KeyCode keycode) {
        return false;
    }

    public boolean keyUp(InputEvent event, KeyCode keycode) {
        return false;
    }

    public boolean keyTyped(InputEvent event, char character) {
        return false;
    }
}

