/*
 * Decompiled with CFR 0.152.
 */
package arc.net;

import arc.net.ArcNetException;
import arc.net.NetSerializer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;

class UdpConnection {
    InetSocketAddress connectedAddress;
    DatagramChannel datagramChannel;
    int keepAliveMillis = 19000;
    final ByteBuffer readBuffer;
    final ByteBuffer writeBuffer;
    private final NetSerializer serialization;
    private SelectionKey selectionKey;
    private final Object writeLock = new Object();
    private long lastCommunicationTime;

    public UdpConnection(NetSerializer serialization, int bufferSize) {
        this.serialization = serialization;
        this.readBuffer = ByteBuffer.allocate(bufferSize);
        this.writeBuffer = ByteBuffer.allocateDirect(bufferSize);
    }

    public void bind(Selector selector, InetSocketAddress localPort) throws IOException {
        this.close();
        this.readBuffer.clear();
        this.writeBuffer.clear();
        try {
            this.datagramChannel = selector.provider().openDatagramChannel();
            this.datagramChannel.socket().bind(localPort);
            this.datagramChannel.configureBlocking(false);
            this.selectionKey = this.datagramChannel.register(selector, 1);
            this.lastCommunicationTime = System.currentTimeMillis();
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    public void connect(Selector selector, InetSocketAddress remoteAddress) throws IOException {
        this.close();
        this.readBuffer.clear();
        this.writeBuffer.clear();
        try {
            this.datagramChannel = selector.provider().openDatagramChannel();
            this.datagramChannel.socket().bind(null);
            this.datagramChannel.socket().connect(remoteAddress);
            this.datagramChannel.configureBlocking(false);
            this.selectionKey = this.datagramChannel.register(selector, 1);
            this.lastCommunicationTime = System.currentTimeMillis();
            this.connectedAddress = remoteAddress;
        }
        catch (IOException ex) {
            this.close();
            throw new IOException("Unable to connect to: " + remoteAddress, ex);
        }
    }

    public InetSocketAddress readFromAddress() throws IOException {
        DatagramChannel datagramChannel = this.datagramChannel;
        if (datagramChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        this.lastCommunicationTime = System.currentTimeMillis();
        if (!datagramChannel.isConnected()) {
            return (InetSocketAddress)datagramChannel.receive(this.readBuffer);
        }
        datagramChannel.read(this.readBuffer);
        return this.connectedAddress;
    }

    public Object readObject() {
        this.readBuffer.flip();
        try {
            Object object = this.serialization.read(this.readBuffer);
            if (this.readBuffer.hasRemaining()) {
                throw new ArcNetException("Incorrect number of bytes (" + this.readBuffer.remaining() + " remaining) used to deserialize object: " + object);
            }
            Object object2 = object;
            return object2;
        }
        catch (Exception ex) {
            throw new ArcNetException("Error during deserialization.", ex);
        }
        finally {
            this.readBuffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(Object object, SocketAddress address) throws IOException {
        DatagramChannel datagramChannel = this.datagramChannel;
        if (datagramChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        Object object2 = this.writeLock;
        synchronized (object2) {
            int n;
            try {
                try {
                    this.serialization.write(this.writeBuffer, object);
                }
                catch (Exception ex) {
                    throw new ArcNetException("Error serializing object of type: " + object.getClass().getName(), ex);
                }
                this.writeBuffer.flip();
                int length = this.writeBuffer.limit();
                datagramChannel.send(this.writeBuffer, address);
                this.lastCommunicationTime = System.currentTimeMillis();
                boolean wasFullWrite = !this.writeBuffer.hasRemaining();
                n = wasFullWrite ? length : -1;
                this.writeBuffer.clear();
            }
            catch (Throwable throwable) {
                this.writeBuffer.clear();
                throw throwable;
            }
            return n;
        }
    }

    public void close() {
        this.connectedAddress = null;
        try {
            if (this.datagramChannel != null) {
                this.datagramChannel.close();
                this.datagramChannel = null;
                if (this.selectionKey != null) {
                    this.selectionKey.selector().wakeup();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean needsKeepAlive(long time) {
        return this.connectedAddress != null && this.keepAliveMillis > 0 && time - this.lastCommunicationTime > (long)this.keepAliveMillis;
    }
}

