/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.graphics.Gl;
import arc.graphics.Mesh;
import arc.graphics.VertexAttribute;
import arc.graphics.gl.Shader;
import arc.graphics.gl.VertexData;
import arc.util.ArcRuntimeException;
import arc.util.Buffers;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;

public class VertexBufferObject
implements VertexData {
    boolean dirty = false;
    boolean bound = false;
    boolean created = false;
    private Mesh mesh;
    private FloatBuffer buffer;
    private ByteBuffer byteBuffer;
    private boolean ownsBuffer;
    private int bufferHandle;
    private int usage;

    public VertexBufferObject(boolean isStatic, int numVertices, Mesh mesh) {
        this.mesh = mesh;
        this.usage = isStatic ? 35044 : 35048;
        ByteBuffer data = Buffers.newUnsafeByteBuffer(mesh.vertexSize * numVertices);
        data.limit(0);
        this.setBuffer(data, true);
    }

    @Override
    public int size() {
        return this.buffer.limit() * 4 / this.mesh.vertexSize;
    }

    @Override
    public int max() {
        return this.byteBuffer.capacity() / this.mesh.vertexSize;
    }

    @Override
    public FloatBuffer buffer() {
        this.dirty = true;
        return this.buffer;
    }

    protected void setBuffer(Buffer data, boolean ownsBuffer) {
        if (this.bound) {
            throw new ArcRuntimeException("Cannot change attributes while VBO is bound");
        }
        if (this.ownsBuffer && this.byteBuffer != null) {
            Buffers.disposeUnsafeByteBuffer(this.byteBuffer);
        }
        if (!(data instanceof ByteBuffer)) {
            throw new ArcRuntimeException("Only ByteBuffer is currently supported");
        }
        this.byteBuffer = (ByteBuffer)data;
        this.ownsBuffer = ownsBuffer;
        int l = this.byteBuffer.limit();
        this.byteBuffer.limit(this.byteBuffer.capacity());
        this.buffer = this.byteBuffer.asFloatBuffer();
        this.byteBuffer.limit(l);
        this.buffer.limit(l / 4);
    }

    private void upload() {
        Gl.bufferData(34962, this.byteBuffer.limit(), this.byteBuffer, this.usage);
    }

    private void bufferChanged() {
        if (this.bound) {
            this.upload();
            this.dirty = false;
        }
    }

    @Override
    public void set(float[] vertices, int offset, int count) {
        this.dirty = true;
        Buffers.copy(vertices, this.byteBuffer, count, offset);
        this.buffer.position(0);
        this.buffer.limit(count);
        this.bufferChanged();
    }

    @Override
    public void update(int targetOffset, float[] vertices, int sourceOffset, int count) {
        this.dirty = true;
        int pos = this.byteBuffer.position();
        this.byteBuffer.position(targetOffset * 4);
        Buffers.copy(vertices, sourceOffset, count, this.byteBuffer);
        this.byteBuffer.position(pos);
        this.buffer.position(0);
        this.bufferChanged();
    }

    public void bind() {
        if (!this.created) {
            this.bufferHandle = Gl.genBuffer();
            this.created = true;
        }
        Gl.bindBuffer(34962, this.bufferHandle);
        if (this.dirty) {
            this.byteBuffer.limit(this.buffer.limit() * 4);
            this.upload();
            this.dirty = false;
        }
        this.bound = true;
    }

    @Override
    public void bind(Shader shader) {
        this.bind();
        int offset = 0;
        for (VertexAttribute attribute : this.mesh.attributes) {
            int location = shader.getAttributeLocation(attribute.alias);
            int aoffset = offset;
            offset += attribute.size;
            if (location < 0) continue;
            Gl.enableVertexAttribArray(location);
            Gl.vertexAttribPointer(location, attribute.components, attribute.type, attribute.normalized, this.mesh.vertexSize, aoffset);
        }
    }

    @Override
    public void unbind(Shader shader) {
        for (VertexAttribute attribute : this.mesh.attributes) {
            shader.disableVertexAttribute(attribute.alias);
        }
        Gl.bindBuffer(34962, 0);
        this.bound = false;
    }

    @Override
    public void dispose() {
        Gl.bindBuffer(34962, 0);
        Gl.deleteBuffer(this.bufferHandle);
        this.bufferHandle = 0;
        if (this.ownsBuffer) {
            Buffers.disposeUnsafeByteBuffer(this.byteBuffer);
        }
    }
}

