/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.graphics.Gl;
import arc.graphics.Mesh;
import arc.graphics.VertexAttribute;
import arc.graphics.gl.IndexData;
import arc.graphics.gl.Shader;
import arc.graphics.gl.VertexData;
import arc.util.Buffers;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class VertexArray
implements VertexData {
    final Mesh mesh;
    final FloatBuffer buffer;
    final ByteBuffer byteBuffer;
    boolean isBound = false;

    public VertexArray(int numVertices, Mesh mesh) {
        this.mesh = mesh;
        this.byteBuffer = Buffers.newUnsafeByteBuffer(this.mesh.vertexSize * numVertices);
        this.buffer = this.byteBuffer.asFloatBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
        this.byteBuffer.asFloatBuffer();
    }

    @Override
    public void render(IndexData indices, int primitiveType, int offset, int count) {
        if (indices.size() > 0) {
            ShortBuffer buffer = indices.buffer();
            int oldPosition = buffer.position();
            int oldLimit = buffer.limit();
            buffer.position(offset);
            buffer.limit(offset + count);
            Gl.drawElements(primitiveType, count, 5123, buffer);
            buffer.position(oldPosition);
            buffer.limit(oldLimit);
        } else {
            Gl.drawArrays(primitiveType, offset, count);
        }
    }

    @Override
    public void dispose() {
        Buffers.disposeUnsafeByteBuffer(this.byteBuffer);
    }

    @Override
    public FloatBuffer buffer() {
        return this.buffer;
    }

    @Override
    public int size() {
        return this.buffer.limit() * 4 / this.mesh.vertexSize;
    }

    @Override
    public int max() {
        return this.byteBuffer.capacity() / this.mesh.vertexSize;
    }

    @Override
    public void set(float[] vertices, int offset, int count) {
        Buffers.copy(vertices, this.byteBuffer, count, offset);
        this.buffer.position(0);
        this.buffer.limit(count);
    }

    @Override
    public void update(int targetOffset, float[] vertices, int sourceOffset, int count) {
        int pos = this.byteBuffer.position();
        this.byteBuffer.position(targetOffset * 4);
        Buffers.copy(vertices, sourceOffset, count, this.byteBuffer);
        this.byteBuffer.position(pos);
    }

    @Override
    public void bind(Shader shader) {
        this.byteBuffer.limit(this.buffer.limit() * 4);
        int offset = 0;
        for (VertexAttribute attribute : this.mesh.attributes) {
            int location = shader.getAttributeLocation(attribute.alias);
            int aoffset = offset;
            offset += attribute.size;
            if (location < 0) continue;
            Gl.enableVertexAttribArray(location);
            if (attribute.type == 5126) {
                this.buffer.position(aoffset / 4);
                Gl.vertexAttribPointer(location, attribute.components, attribute.type, attribute.normalized, this.mesh.vertexSize, this.buffer);
                continue;
            }
            this.byteBuffer.position(aoffset);
            Gl.vertexAttribPointer(location, attribute.components, attribute.type, attribute.normalized, this.mesh.vertexSize, this.byteBuffer);
        }
        this.isBound = true;
    }

    @Override
    public void unbind(Shader shader) {
        for (VertexAttribute attribute : this.mesh.attributes) {
            shader.disableVertexAttribute(attribute.alias);
        }
        this.isBound = false;
    }
}

