/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics;

import arc.Core;
import arc.struct.Bits;
import arc.util.Buffers;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;

public class Gl {
    private static final boolean optimize = true;
    public static final int esVersion20 = 1;
    public static final int depthBufferBit = 256;
    public static final int stencilBufferBit = 1024;
    public static final int colorBufferBit = 16384;
    public static final int falseV = 0;
    public static final int trueV = 1;
    public static final int points = 0;
    public static final int lines = 1;
    public static final int lineLoop = 2;
    public static final int lineStrip = 3;
    public static final int triangles = 4;
    public static final int triangleStrip = 5;
    public static final int triangleFan = 6;
    public static final int zero = 0;
    public static final int one = 1;
    public static final int srcColor = 768;
    public static final int oneMinusSrcColor = 769;
    public static final int srcAlpha = 770;
    public static final int oneMinusSrcAlpha = 771;
    public static final int dstAlpha = 772;
    public static final int oneMinusDstAlpha = 773;
    public static final int dstColor = 774;
    public static final int oneMinusDstColor = 775;
    public static final int srcAlphaSaturate = 776;
    public static final int funcAdd = 32774;
    public static final int blendEquation = 32777;
    public static final int blendEquationRgb = 32777;
    public static final int blendEquationAlpha = 34877;
    public static final int funcSubtract = 32778;
    public static final int funcReverseSubtract = 32779;
    public static final int min = 32775;
    public static final int max = 32776;
    public static final int blendDstRgb = 32968;
    public static final int blendSrcRgb = 32969;
    public static final int blendDstAlpha = 32970;
    public static final int blendSrcAlpha = 32971;
    public static final int constantColor = 32769;
    public static final int oneMinusConstantColor = 32770;
    public static final int constantAlpha = 32771;
    public static final int oneMinusConstantAlpha = 32772;
    public static final int blendColor = 32773;
    public static final int arrayBuffer = 34962;
    public static final int elementArrayBuffer = 34963;
    public static final int arrayBufferBinding = 34964;
    public static final int elementArrayBufferBinding = 34965;
    public static final int streamDraw = 35040;
    public static final int staticDraw = 35044;
    public static final int dynamicDraw = 35048;
    public static final int bufferSize = 34660;
    public static final int bufferUsage = 34661;
    public static final int currentVertexAttrib = 34342;
    public static final int front = 1028;
    public static final int back = 1029;
    public static final int frontAndBack = 1032;
    public static final int texture2d = 3553;
    public static final int cullFace = 2884;
    public static final int blend = 3042;
    public static final int dither = 3024;
    public static final int stencilTest = 2960;
    public static final int depthTest = 2929;
    public static final int scissorTest = 3089;
    public static final int polygonOffsetFill = 32823;
    public static final int sampleAlphaToCoverage = 32926;
    public static final int sampleCoverage = 32928;
    public static final int noError = 0;
    public static final int invalidEnum = 1280;
    public static final int invalidValue = 1281;
    public static final int invalidOperation = 1282;
    public static final int outOfMemory = 1285;
    public static final int cw = 2304;
    public static final int ccw = 2305;
    public static final int lineWidth = 2849;
    public static final int aliasedPointSizeRange = 33901;
    public static final int aliasedLineWidthRange = 33902;
    public static final int cullFaceMode = 2885;
    public static final int frontFace = 2886;
    public static final int depthRange = 2928;
    public static final int depthWritemask = 2930;
    public static final int depthClearValue = 2931;
    public static final int depthFunc = 2932;
    public static final int stencilClearValue = 2961;
    public static final int stencilFunc = 2962;
    public static final int stencilFail = 2964;
    public static final int stencilPassDepthFail = 2965;
    public static final int stencilPassDepthPass = 2966;
    public static final int stencilRef = 2967;
    public static final int stencilValueMask = 2963;
    public static final int stencilWritemask = 2968;
    public static final int stencilBackFunc = 34816;
    public static final int stencilBackFail = 34817;
    public static final int stencilBackPassDepthFail = 34818;
    public static final int stencilBackPassDepthPass = 34819;
    public static final int stencilBackRef = 36003;
    public static final int stencilBackValueMask = 36004;
    public static final int stencilBackWritemask = 36005;
    public static final int viewport = 2978;
    public static final int scissorBox = 3088;
    public static final int colorClearValue = 3106;
    public static final int colorWritemask = 3107;
    public static final int unpackAlignment = 3317;
    public static final int packAlignment = 3333;
    public static final int maxTextureSize = 3379;
    public static final int maxTextureUnits = 34018;
    public static final int maxViewportDims = 3386;
    public static final int subpixelBits = 3408;
    public static final int redBits = 3410;
    public static final int greenBits = 3411;
    public static final int blueBits = 3412;
    public static final int alphaBits = 3413;
    public static final int depthBits = 3414;
    public static final int stencilBits = 3415;
    public static final int polygonOffsetUnits = 10752;
    public static final int polygonOffsetFactor = 32824;
    public static final int textureBinding2d = 32873;
    public static final int sampleBuffers = 32936;
    public static final int samples = 32937;
    public static final int sampleCoverageValue = 32938;
    public static final int sampleCoverageInvert = 32939;
    public static final int numCompressedTextureFormats = 34466;
    public static final int compressedTextureFormats = 34467;
    public static final int dontCare = 4352;
    public static final int fastest = 4353;
    public static final int nicest = 4354;
    public static final int generateMipmap = 33169;
    public static final int generateMipmapHint = 33170;
    public static final int byteV = 5120;
    public static final int unsignedByte = 5121;
    public static final int shortV = 5122;
    public static final int unsignedShort = 5123;
    public static final int intV = 5124;
    public static final int unsignedInt = 5125;
    public static final int floatV = 5126;
    public static final int fixed = 5132;
    public static final int depthComponent = 6402;
    public static final int alpha = 6406;
    public static final int rgb = 6407;
    public static final int rgba = 6408;
    public static final int luminance = 6409;
    public static final int luminanceAlpha = 6410;
    public static final int unsignedShort4444 = 32819;
    public static final int unsignedShort5551 = 32820;
    public static final int unsignedShort565 = 33635;
    public static final int fragmentShader = 35632;
    public static final int vertexShader = 35633;
    public static final int maxVertexAttribs = 34921;
    public static final int maxVertexUniformVectors = 36347;
    public static final int maxVaryingVectors = 36348;
    public static final int maxCombinedTextureImageUnits = 35661;
    public static final int maxVertexTextureImageUnits = 35660;
    public static final int maxTextureImageUnits = 34930;
    public static final int maxFragmentUniformVectors = 36349;
    public static final int shaderType = 35663;
    public static final int deleteStatus = 35712;
    public static final int linkStatus = 35714;
    public static final int validateStatus = 35715;
    public static final int attachedShaders = 35717;
    public static final int activeUniforms = 35718;
    public static final int activeUniformMaxLength = 35719;
    public static final int activeAttributes = 35721;
    public static final int activeAttributeMaxLength = 35722;
    public static final int shadingLanguageVersion = 35724;
    public static final int currentProgram = 35725;
    public static final int never = 512;
    public static final int less = 513;
    public static final int equal = 514;
    public static final int lequal = 515;
    public static final int greater = 516;
    public static final int notequal = 517;
    public static final int gequal = 518;
    public static final int always = 519;
    public static final int keep = 7680;
    public static final int replace = 7681;
    public static final int incr = 7682;
    public static final int decr = 7683;
    public static final int invert = 5386;
    public static final int incrWrap = 34055;
    public static final int decrWrap = 34056;
    public static final int vendor = 7936;
    public static final int renderer = 7937;
    public static final int version = 7938;
    public static final int extensions = 7939;
    public static final int nearest = 9728;
    public static final int linear = 9729;
    public static final int nearestMipmapNearest = 9984;
    public static final int linearMipmapNearest = 9985;
    public static final int nearestMipmapLinear = 9986;
    public static final int linearMipmapLinear = 9987;
    public static final int textureMagFilter = 10240;
    public static final int textureMinFilter = 10241;
    public static final int textureWrapS = 10242;
    public static final int textureWrapT = 10243;
    public static final int texture = 5890;
    public static final int textureCubeMap = 34067;
    public static final int textureBindingCubeMap = 34068;
    public static final int textureCubeMapPositiveX = 34069;
    public static final int textureCubeMapNegativeX = 34070;
    public static final int textureCubeMapPositiveY = 34071;
    public static final int textureCubeMapNegativeY = 34072;
    public static final int textureCubeMapPositiveZ = 34073;
    public static final int textureCubeMapNegativeZ = 34074;
    public static final int maxCubeMapTextureSize = 34076;
    public static final int texture0 = 33984;
    public static final int texture1 = 33985;
    public static final int texture2 = 33986;
    public static final int texture3 = 33987;
    public static final int texture4 = 33988;
    public static final int texture5 = 33989;
    public static final int texture6 = 33990;
    public static final int texture7 = 33991;
    public static final int texture8 = 33992;
    public static final int texture9 = 33993;
    public static final int texture10 = 33994;
    public static final int texture11 = 33995;
    public static final int texture12 = 33996;
    public static final int texture13 = 33997;
    public static final int texture14 = 33998;
    public static final int texture15 = 33999;
    public static final int texture16 = 34000;
    public static final int texture17 = 34001;
    public static final int texture18 = 34002;
    public static final int texture19 = 34003;
    public static final int texture20 = 34004;
    public static final int texture21 = 34005;
    public static final int texture22 = 34006;
    public static final int texture23 = 34007;
    public static final int texture24 = 34008;
    public static final int texture25 = 34009;
    public static final int texture26 = 34010;
    public static final int texture27 = 34011;
    public static final int texture28 = 34012;
    public static final int texture29 = 34013;
    public static final int texture30 = 34014;
    public static final int texture31 = 34015;
    public static final int activeTexture = 34016;
    public static final int repeat = 10497;
    public static final int clampToEdge = 33071;
    public static final int mirroredRepeat = 33648;
    public static final int floatVec2 = 35664;
    public static final int floatVec3 = 35665;
    public static final int floatVec4 = 35666;
    public static final int intVec2 = 35667;
    public static final int intVec3 = 35668;
    public static final int intVec4 = 35669;
    public static final int bool = 35670;
    public static final int boolVec2 = 35671;
    public static final int boolVec3 = 35672;
    public static final int boolVec4 = 35673;
    public static final int floatMat2 = 35674;
    public static final int floatMat3 = 35675;
    public static final int floatMat4 = 35676;
    public static final int sampler2d = 35678;
    public static final int samplerCube = 35680;
    public static final int vertexAttribArrayEnabled = 34338;
    public static final int vertexAttribArraySize = 34339;
    public static final int vertexAttribArrayStride = 34340;
    public static final int vertexAttribArrayType = 34341;
    public static final int vertexAttribArrayNormalized = 34922;
    public static final int vertexAttribArrayPointer = 34373;
    public static final int vertexAttribArrayBufferBinding = 34975;
    public static final int implementationColorReadType = 35738;
    public static final int implementationColorReadFormat = 35739;
    public static final int compileStatus = 35713;
    public static final int infoLogLength = 35716;
    public static final int shaderSourceLength = 35720;
    public static final int shaderCompiler = 36346;
    public static final int shaderBinaryFormats = 36344;
    public static final int numShaderBinaryFormats = 36345;
    public static final int lowFloat = 36336;
    public static final int mediumFloat = 36337;
    public static final int highFloat = 36338;
    public static final int lowInt = 36339;
    public static final int mediumInt = 36340;
    public static final int highInt = 36341;
    public static final int framebuffer = 36160;
    public static final int renderbuffer = 36161;
    public static final int rgba4 = 32854;
    public static final int rgb5A1 = 32855;
    public static final int rgb565 = 36194;
    public static final int depthComponent16 = 33189;
    public static final int stencilIndex = 6401;
    public static final int stencilIndex8 = 36168;
    public static final int renderbufferWidth = 36162;
    public static final int renderbufferHeight = 36163;
    public static final int renderbufferInternalFormat = 36164;
    public static final int renderbufferRedSize = 36176;
    public static final int renderbufferGreenSize = 36177;
    public static final int renderbufferBlueSize = 36178;
    public static final int renderbufferAlphaSize = 36179;
    public static final int renderbufferDepthSize = 36180;
    public static final int renderbufferStencilSize = 36181;
    public static final int framebufferAttachmentObjectType = 36048;
    public static final int framebufferAttachmentObjectName = 36049;
    public static final int framebufferAttachmentTextureLevel = 36050;
    public static final int framebufferAttachmentTextureCubeMapFace = 36051;
    public static final int colorAttachment0 = 36064;
    public static final int depthAttachment = 36096;
    public static final int stencilAttachment = 36128;
    public static final int none = 0;
    public static final int framebufferComplete = 36053;
    public static final int framebufferIncompleteAttachment = 36054;
    public static final int framebufferIncompleteMissingAttachment = 36055;
    public static final int framebufferIncompleteDimensions = 36057;
    public static final int framebufferUnsupported = 36061;
    public static final int framebufferBinding = 36006;
    public static final int renderbufferBinding = 36007;
    public static final int maxRenderbufferSize = 34024;
    public static final int invalidFramebufferOperation = 1286;
    public static final int vertexProgramPointSize = 34370;
    private static IntBuffer ibuf = Buffers.newIntBuffer(1);
    private static FloatBuffer fbuf = Buffers.newFloatBuffer(1);
    private static int lastActiveTexture = -1;
    private static int[] lastBoundTextures = new int[32];
    private static int lastUsedProgram = -1;
    private static Bits enabled = new Bits();
    private static boolean wasDepthMask = true;
    private static int lastBlendSrc = -1;
    private static int lastBlendDst = -1;
    private static int lastBlendSrcAlpha = -1;
    private static int lastBlendDstAlpha = -1;

    public static void reset() {
        lastActiveTexture = -1;
        Arrays.fill(lastBoundTextures, -1);
        lastUsedProgram = -1;
        enabled.clear();
        wasDepthMask = true;
    }

    public static void activeTexture(int texture) {
        if (lastActiveTexture == texture) {
            return;
        }
        Core.gl.glActiveTexture(texture);
        lastActiveTexture = texture;
    }

    public static void bindTexture(int target, int texture) {
        int index;
        if (target == 3553 && (index = lastActiveTexture - 33984) >= 0 && index < lastBoundTextures.length) {
            if (lastBoundTextures[index] == texture) {
                return;
            }
            Gl.lastBoundTextures[index] = texture;
        }
        Core.gl.glBindTexture(target, texture);
    }

    public static void blendFunc(int sfactor, int dfactor) {
        if (lastBlendSrc == sfactor && lastBlendDst == dfactor && lastBlendSrcAlpha == sfactor && lastBlendDstAlpha == dfactor) {
            return;
        }
        lastBlendSrc = lastBlendSrcAlpha = sfactor;
        lastBlendDst = lastBlendDstAlpha = dfactor;
        Core.gl.glBlendFunc(lastBlendSrcAlpha, lastBlendDstAlpha);
    }

    public static void clear(int mask) {
        Core.gl.glClear(mask);
    }

    public static void clearColor(float red, float green, float blue, float alpha) {
        Core.gl.glClearColor(red, green, blue, alpha);
    }

    public static void clearDepthf(float depth) {
        Core.gl.glClearDepthf(depth);
    }

    public static void clearStencil(int s) {
        Core.gl.glClearStencil(s);
    }

    public static void colorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        Core.gl.glColorMask(red, green, blue, alpha);
    }

    public static void compressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, Buffer data) {
        Core.gl.glCompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
    }

    public static void compressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, Buffer data) {
        Core.gl.glCompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
    }

    public static void copyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        Core.gl.glCopyTexImage2D(target, level, internalformat, x, y, width, height, border);
    }

    public static void copyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        Core.gl.glCopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
    }

    public static void cullFace(int mode) {
        Core.gl.glCullFace(mode);
    }

    public static void deleteTexture(int texture) {
        for (int i = 0; i < lastBoundTextures.length; ++i) {
            if (lastBoundTextures[i] != texture) continue;
            Gl.lastBoundTextures[i] = -1;
        }
        Core.gl.glDeleteTexture(texture);
    }

    public static void depthFunc(int func) {
        Core.gl.glDepthFunc(func);
    }

    public static void depthMask(boolean flag) {
        if (flag == wasDepthMask) {
            return;
        }
        wasDepthMask = flag;
        Core.gl.glDepthMask(flag);
    }

    public static void depthRangef(float zNear, float zFar) {
        Core.gl.glDepthRangef(zNear, zFar);
    }

    public static void disable(int cap) {
        if (!enabled.get(cap)) {
            return;
        }
        Core.gl.glDisable(cap);
        enabled.clear(cap);
    }

    public static void drawArrays(int mode, int first, int count) {
        Core.gl.glDrawArrays(mode, first, count);
    }

    public static void drawElements(int mode, int count, int type, Buffer indices) {
        Core.gl.glDrawElements(mode, count, type, indices);
    }

    public static void enable(int cap) {
        if (enabled.get(cap)) {
            return;
        }
        Core.gl.glEnable(cap);
        enabled.set(cap);
    }

    public static void finish() {
        Core.gl.glFinish();
    }

    public static void flush() {
        Core.gl.glFlush();
    }

    public static void frontFace(int mode) {
        Core.gl.glFrontFace(mode);
    }

    public static int genTexture() {
        return Core.gl.glGenTexture();
    }

    public static int getError() {
        return Core.gl.glGetError();
    }

    public static void getIntegerv(int pname, IntBuffer params) {
        Core.gl.glGetIntegerv(pname, params);
    }

    public static int getInt(int name) {
        ibuf.position(0);
        Gl.getIntegerv(name, ibuf);
        return ibuf.get(0);
    }

    public static float getFloat(int name) {
        fbuf.position(0);
        Gl.getFloatv(name, fbuf);
        return fbuf.get(0);
    }

    public static String getString(int name) {
        return Core.gl.glGetString(name);
    }

    public static void hint(int target, int mode) {
        Core.gl.glHint(target, mode);
    }

    public static void pixelStorei(int pname, int param) {
        Core.gl.glPixelStorei(pname, param);
    }

    public static void polygonOffset(float factor, float units) {
        Core.gl.glPolygonOffset(factor, units);
    }

    public static void readPixels(int x, int y, int width, int height, int format, int type, Buffer pixels) {
        Core.gl.glReadPixels(x, y, width, height, format, type, pixels);
    }

    public static void scissor(int x, int y, int width, int height) {
        Core.gl.glScissor(x, y, width, height);
    }

    public static void stencilFunc(int func, int ref, int mask) {
        Core.gl.glStencilFunc(func, ref, mask);
    }

    public static void stencilMask(int mask) {
        Core.gl.glStencilMask(mask);
    }

    public static void stencilOp(int fail, int zfail, int zpass) {
        Core.gl.glStencilOp(fail, zfail, zpass);
    }

    public static void texImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, Buffer pixels) {
        Core.gl.glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
    }

    public static void texParameterf(int target, int pname, float param) {
        Core.gl.glTexParameterf(target, pname, param);
    }

    public static void texSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, Buffer pixels) {
        Core.gl.glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
    }

    public static void viewport(int x, int y, int width, int height) {
        Core.gl.glViewport(x, y, width, height);
    }

    public static void attachShader(int program, int shader) {
        Core.gl.glAttachShader(program, shader);
    }

    public static void bindAttribLocation(int program, int index, String name) {
        Core.gl.glBindAttribLocation(program, index, name);
    }

    public static void bindBuffer(int target, int buffer) {
        Core.gl.glBindBuffer(target, buffer);
    }

    public static void bindFramebuffer(int target, int framebuffer) {
        Core.gl.glBindFramebuffer(target, framebuffer);
    }

    public static void bindRenderbuffer(int target, int renderbuffer) {
        Core.gl.glBindRenderbuffer(target, renderbuffer);
    }

    public static void blendColor(float red, float green, float blue, float alpha) {
        Core.gl.glBlendColor(red, green, blue, alpha);
    }

    public static void blendEquation(int mode) {
        Core.gl.glBlendEquation(mode);
    }

    public static void blendEquationSeparate(int modeRGB, int modeAlpha) {
        Core.gl.glBlendEquationSeparate(modeRGB, modeAlpha);
    }

    public static void blendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        if (srcRGB == lastBlendSrc && dstRGB == lastBlendDst && srcAlpha == lastBlendSrcAlpha && dstAlpha == lastBlendDstAlpha) {
            return;
        }
        lastBlendSrc = srcRGB;
        lastBlendDst = dstRGB;
        lastBlendSrcAlpha = srcAlpha;
        lastBlendDstAlpha = dstAlpha;
        Core.gl.glBlendFuncSeparate(lastBlendSrc, lastBlendDst, lastBlendSrcAlpha, lastBlendDstAlpha);
    }

    public static void bufferData(int target, int size, Buffer data, int usage) {
        Core.gl.glBufferData(target, size, data, usage);
    }

    public static void bufferSubData(int target, int offset, int size, Buffer data) {
        Core.gl.glBufferSubData(target, offset, size, data);
    }

    public static int checkFramebufferStatus(int target) {
        return Core.gl.glCheckFramebufferStatus(target);
    }

    public static void compileShader(int shader) {
        Core.gl.glCompileShader(shader);
    }

    public static int createProgram() {
        return Core.gl.glCreateProgram();
    }

    public static int createShader(int type) {
        return Core.gl.glCreateShader(type);
    }

    public static void deleteBuffer(int buffer) {
        Core.gl.glDeleteBuffer(buffer);
    }

    public static void deleteFramebuffer(int framebuffer) {
        Core.gl.glDeleteFramebuffer(framebuffer);
    }

    public static void deleteProgram(int program) {
        Core.gl.glDeleteProgram(program);
    }

    public static void deleteRenderbuffer(int renderbuffer) {
        Core.gl.glDeleteRenderbuffer(renderbuffer);
    }

    public static void deleteShader(int shader) {
        Core.gl.glDeleteShader(shader);
    }

    public static void detachShader(int program, int shader) {
        Core.gl.glDetachShader(program, shader);
    }

    public static void disableVertexAttribArray(int index) {
        Core.gl.glDisableVertexAttribArray(index);
    }

    public static void drawElements(int mode, int count, int type, int indices) {
        Core.gl.glDrawElements(mode, count, type, indices);
    }

    public static void enableVertexAttribArray(int index) {
        Core.gl.glEnableVertexAttribArray(index);
    }

    public static void framebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        Core.gl.glFramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
    }

    public static void framebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        Core.gl.glFramebufferTexture2D(target, attachment, textarget, texture, level);
    }

    public static int genBuffer() {
        return Core.gl.glGenBuffer();
    }

    public static void generateMipmap(int target) {
        Core.gl.glGenerateMipmap(target);
    }

    public static int genFramebuffer() {
        return Core.gl.glGenFramebuffer();
    }

    public static int genRenderbuffer() {
        return Core.gl.glGenRenderbuffer();
    }

    public static String getActiveAttrib(int program, int index, IntBuffer size, IntBuffer type) {
        return Core.gl.glGetActiveAttrib(program, index, size, type);
    }

    public static String getActiveUniform(int program, int index, IntBuffer size, IntBuffer type) {
        return Core.gl.glGetActiveUniform(program, index, size, type);
    }

    public static int getAttribLocation(int program, String name) {
        return Core.gl.glGetAttribLocation(program, name);
    }

    public static void getBooleanv(int pname, Buffer params) {
        Core.gl.glGetBooleanv(pname, params);
    }

    public static void getBufferParameteriv(int target, int pname, IntBuffer params) {
        Core.gl.glGetBufferParameteriv(target, pname, params);
    }

    public static void getFloatv(int pname, FloatBuffer params) {
        Core.gl.glGetFloatv(pname, params);
    }

    public static void getFramebufferAttachmentParameteriv(int target, int attachment, int pname, IntBuffer params) {
        Core.gl.glGetFramebufferAttachmentParameteriv(target, attachment, pname, params);
    }

    public static void getProgramiv(int program, int pname, IntBuffer params) {
        Core.gl.glGetProgramiv(program, pname, params);
    }

    public static String getProgramInfoLog(int program) {
        return Core.gl.glGetProgramInfoLog(program);
    }

    public static void getRenderbufferParameteriv(int target, int pname, IntBuffer params) {
        Core.gl.glGetRenderbufferParameteriv(target, pname, params);
    }

    public static void getShaderiv(int shader, int pname, IntBuffer params) {
        Core.gl.glGetShaderiv(shader, pname, params);
    }

    public static String getShaderInfoLog(int shader) {
        return Core.gl.glGetShaderInfoLog(shader);
    }

    public static void getShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        Core.gl.glGetShaderPrecisionFormat(shadertype, precisiontype, range, precision);
    }

    public static void getTexParameterfv(int target, int pname, FloatBuffer params) {
        Core.gl.glGetTexParameterfv(target, pname, params);
    }

    public static void getTexParameteriv(int target, int pname, IntBuffer params) {
        Core.gl.glGetTexParameteriv(target, pname, params);
    }

    public static void getUniformfv(int program, int location, FloatBuffer params) {
        Core.gl.glGetUniformfv(program, location, params);
    }

    public static void getUniformiv(int program, int location, IntBuffer params) {
        Core.gl.glGetUniformiv(program, location, params);
    }

    public static int getUniformLocation(int program, String name) {
        return Core.gl.glGetUniformLocation(program, name);
    }

    public static void getVertexAttribfv(int index, int pname, FloatBuffer params) {
        Core.gl.glGetVertexAttribfv(index, pname, params);
    }

    public static void getVertexAttribiv(int index, int pname, IntBuffer params) {
        Core.gl.glGetVertexAttribiv(index, pname, params);
    }

    public static boolean isBuffer(int buffer) {
        return Core.gl.glIsBuffer(buffer);
    }

    public static boolean isEnabled(int cap) {
        return Core.gl.glIsEnabled(cap);
    }

    public static boolean isFramebuffer(int framebuffer) {
        return Core.gl.glIsFramebuffer(framebuffer);
    }

    public static boolean isProgram(int program) {
        return Core.gl.glIsProgram(program);
    }

    public static boolean isRenderbuffer(int renderbuffer) {
        return Core.gl.glIsRenderbuffer(renderbuffer);
    }

    public static boolean isShader(int shader) {
        return Core.gl.glIsShader(shader);
    }

    public static boolean isTexture(int texture) {
        return Core.gl.glIsTexture(texture);
    }

    public static void linkProgram(int program) {
        Core.gl.glLinkProgram(program);
    }

    public static void releaseShaderCompiler() {
        Core.gl.glReleaseShaderCompiler();
    }

    public static void renderbufferStorage(int target, int internalformat, int width, int height) {
        Core.gl.glRenderbufferStorage(target, internalformat, width, height);
    }

    public static void sampleCoverage(float value, boolean invert) {
        Core.gl.glSampleCoverage(value, invert);
    }

    public static void shaderSource(int shader, String string) {
        Core.gl.glShaderSource(shader, string);
    }

    public static void stencilFuncSeparate(int face, int func, int ref, int mask) {
        Core.gl.glStencilFuncSeparate(face, func, ref, mask);
    }

    public static void stencilMaskSeparate(int face, int mask) {
        Core.gl.glStencilMaskSeparate(face, mask);
    }

    public static void stencilOpSeparate(int face, int fail, int zfail, int zpass) {
        Core.gl.glStencilOpSeparate(face, fail, zfail, zpass);
    }

    public static void texParameterfv(int target, int pname, FloatBuffer params) {
        Core.gl.glTexParameterfv(target, pname, params);
    }

    public static void texParameteri(int target, int pname, int param) {
        Core.gl.glTexParameteri(target, pname, param);
    }

    public static void texParameteriv(int target, int pname, IntBuffer params) {
        Core.gl.glTexParameteriv(target, pname, params);
    }

    public static void uniform1f(int location, float x) {
        Core.gl.glUniform1f(location, x);
    }

    public static void uniform1fv(int location, int count, FloatBuffer v) {
        Core.gl.glUniform1fv(location, count, v);
    }

    public static void uniform1fv(int location, int count, float[] v, int offset) {
        Core.gl.glUniform1fv(location, count, v, offset);
    }

    public static void uniform1i(int location, int x) {
        Core.gl.glUniform1i(location, x);
    }

    public static void uniform1iv(int location, int count, IntBuffer v) {
        Core.gl.glUniform1iv(location, count, v);
    }

    public static void uniform1iv(int location, int count, int[] v, int offset) {
        Core.gl.glUniform1iv(location, count, v, offset);
    }

    public static void uniform2f(int location, float x, float y) {
        Core.gl.glUniform2f(location, x, y);
    }

    public static void uniform2fv(int location, int count, FloatBuffer v) {
        Core.gl.glUniform2fv(location, count, v);
    }

    public static void uniform2fv(int location, int count, float[] v, int offset) {
        Core.gl.glUniform2fv(location, count, v, offset);
    }

    public static void uniform2i(int location, int x, int y) {
        Core.gl.glUniform2i(location, x, y);
    }

    public static void uniform2iv(int location, int count, IntBuffer v) {
        Core.gl.glUniform2iv(location, count, v);
    }

    public static void uniform2iv(int location, int count, int[] v, int offset) {
        Core.gl.glUniform2iv(location, count, v, offset);
    }

    public static void uniform3f(int location, float x, float y, float z) {
        Core.gl.glUniform3f(location, x, y, z);
    }

    public static void uniform3fv(int location, int count, FloatBuffer v) {
        Core.gl.glUniform3fv(location, count, v);
    }

    public static void uniform3fv(int location, int count, float[] v, int offset) {
        Core.gl.glUniform3fv(location, count, v, offset);
    }

    public static void uniform3i(int location, int x, int y, int z) {
        Core.gl.glUniform3i(location, x, y, z);
    }

    public static void uniform3iv(int location, int count, IntBuffer v) {
        Core.gl.glUniform3iv(location, count, v);
    }

    public static void uniform3iv(int location, int count, int[] v, int offset) {
        Core.gl.glUniform3iv(location, count, v, offset);
    }

    public static void uniform4f(int location, float x, float y, float z, float w) {
        Core.gl.glUniform4f(location, x, y, z, w);
    }

    public static void uniform4fv(int location, int count, FloatBuffer v) {
        Core.gl.glUniform4fv(location, count, v);
    }

    public static void uniform4fv(int location, int count, float[] v, int offset) {
        Core.gl.glUniform4fv(location, count, v, offset);
    }

    public static void uniform4i(int location, int x, int y, int z, int w) {
        Core.gl.glUniform4i(location, x, y, z, w);
    }

    public static void uniform4iv(int location, int count, IntBuffer v) {
        Core.gl.glUniform4iv(location, count, v);
    }

    public static void uniform4iv(int location, int count, int[] v, int offset) {
        Core.gl.glUniform4iv(location, count, v, offset);
    }

    public static void uniformMatrix2fv(int location, int count, boolean transpose, FloatBuffer value) {
        Core.gl.glUniformMatrix2fv(location, count, transpose, value);
    }

    public static void uniformMatrix2fv(int location, int count, boolean transpose, float[] value, int offset) {
        Core.gl.glUniformMatrix2fv(location, count, transpose, value, offset);
    }

    public static void uniformMatrix3fv(int location, int count, boolean transpose, FloatBuffer value) {
        Core.gl.glUniformMatrix3fv(location, count, transpose, value);
    }

    public static void uniformMatrix3fv(int location, int count, boolean transpose, float[] value, int offset) {
        Core.gl.glUniformMatrix3fv(location, count, transpose, value, offset);
    }

    public static void uniformMatrix4fv(int location, int count, boolean transpose, FloatBuffer value) {
        Core.gl.glUniformMatrix4fv(location, count, transpose, value);
    }

    public static void uniformMatrix4fv(int location, int count, boolean transpose, float[] value, int offset) {
        Core.gl.glUniformMatrix4fv(location, count, transpose, value, offset);
    }

    public static void useProgram(int program) {
        if (lastUsedProgram == program) {
            return;
        }
        Core.gl.glUseProgram(program);
        lastUsedProgram = program;
    }

    public static void validateProgram(int program) {
        Core.gl.glValidateProgram(program);
    }

    public static void vertexAttrib1f(int indx, float x) {
        Core.gl.glVertexAttrib1f(indx, x);
    }

    public static void vertexAttrib1fv(int indx, FloatBuffer values) {
        Core.gl.glVertexAttrib1fv(indx, values);
    }

    public static void vertexAttrib2f(int indx, float x, float y) {
        Core.gl.glVertexAttrib2f(indx, x, y);
    }

    public static void vertexAttrib2fv(int indx, FloatBuffer values) {
        Core.gl.glVertexAttrib2fv(indx, values);
    }

    public static void vertexAttrib3f(int indx, float x, float y, float z) {
        Core.gl.glVertexAttrib3f(indx, x, y, z);
    }

    public static void vertexAttrib3fv(int indx, FloatBuffer values) {
        Core.gl.glVertexAttrib3fv(indx, values);
    }

    public static void vertexAttrib4f(int indx, float x, float y, float z, float w) {
        Core.gl.glVertexAttrib4f(indx, x, y, z, w);
    }

    public static void vertexAttrib4fv(int indx, FloatBuffer values) {
        Core.gl.glVertexAttrib4fv(indx, values);
    }

    public static void vertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, Buffer ptr) {
        Core.gl.glVertexAttribPointer(indx, size, type, normalized, stride, ptr);
    }

    public static void vertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, int ptr) {
        Core.gl.glVertexAttribPointer(indx, size, type, normalized, stride, ptr);
    }

    static {
        Gl.reset();
    }
}

