/*
 * Decompiled with CFR 0.152.
 */
package arc.fx.filters;

import arc.Core;
import arc.fx.FxFilter;
import arc.graphics.Color;
import arc.math.geom.Vec2;

public final class LensFlareFilter
extends FxFilter {
    private final Vec2 viewport = new Vec2();
    public final Vec2 lightPosition = new Vec2(0.5f, 0.5f);
    public final Color color = new Color(1.0f, 0.8f, 0.2f, 1.0f);
    public float intensity = 5.0f;

    public LensFlareFilter() {
        super(LensFlareFilter.compileShader(Core.files.classpath("vfxshaders/screenspace.vert"), Core.files.classpath("vfxshaders/lensflare.frag")));
        this.rebind();
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.set(width, height);
        this.rebind();
    }

    @Override
    public void setParams() {
        this.shader.setUniformi("u_texture0", 0);
        this.shader.setUniformf("u_lightPosition", this.lightPosition);
        this.shader.setUniformf("u_intensity", this.intensity);
        this.shader.setUniformf("u_color", this.color.r, this.color.g, this.color.b);
        this.shader.setUniformf("u_viewport", this.viewport);
    }
}

