/*
 * Decompiled with CFR 0.152.
 */
package arc.fx.filters;

import arc.Core;
import arc.fx.FxFilter;

public final class Convolve1dFilter
extends FxFilter {
    public int length;
    public float[] weights;
    public float[] offsets;

    public Convolve1dFilter(int length) {
        this(length, new float[length], new float[length * 2]);
    }

    public Convolve1dFilter(int length, float[] weights_data) {
        this(length, weights_data, new float[length * 2]);
    }

    public Convolve1dFilter(int length, float[] weights_data, float[] offsets) {
        super(Convolve1dFilter.compileShader(Core.files.classpath("vfxshaders/screenspace.vert"), Core.files.classpath("vfxshaders/convolve-1d.frag"), "#define LENGTH " + length));
        this.setWeights(length, weights_data, offsets);
        this.rebind();
    }

    public void setWeights(int length, float[] weights, float[] offsets) {
        this.weights = weights;
        this.length = length;
        this.offsets = offsets;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.weights = null;
        this.offsets = null;
        this.length = 0;
    }

    @Override
    public void setParams() {
        this.shader.setUniformi("u_texture0", 0);
        this.shader.setUniform1fv("SampleWeights", this.weights, 0, this.length);
        this.shader.setUniform2fv("SampleOffsets", this.offsets, 0, this.length * 2);
    }
}

