/*
 * Decompiled with CFR 0.152.
 */
package arc.flabel;

import arc.flabel.FConfig;
import arc.flabel.FEffect;
import arc.flabel.FGlyph;
import arc.flabel.FListener;
import arc.flabel.FParser;
import arc.graphics.Color;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.FontCache;
import arc.graphics.g2d.GlyphLayout;
import arc.math.Mathf;
import arc.scene.style.Drawable;
import arc.scene.ui.Label;
import arc.struct.IntSeq;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.pooling.Pools;

public class FLabel
extends Label {
    private final ObjectMap<String, String> variables = new ObjectMap();
    protected final Seq<FParser.TokenEntry> tokenEntries = new Seq();
    private Color clearColor = new Color(FConfig.defaultClearColor);
    private FListener listener = null;
    boolean forceMarkupColor = FConfig.forceColorMarkupByDefault;
    private final StringBuilder originalText = new StringBuilder();
    private final Seq<FGlyph> glyphCache = new Seq();
    private final IntSeq glyphRunCapacities = new IntSeq();
    private final IntSeq offsetCache = new IntSeq();
    private final IntSeq layoutLineBreaks = new IntSeq();
    private final Seq<FEffect> activeEffects = new Seq();
    private float textSpeed;
    private float charCooldown = this.textSpeed = FConfig.defaultSpeedPerChar;
    private int rawCharIndex = -2;
    private int glyphCharIndex = -1;
    private int glyphCharCompensation = 0;
    private int cachedGlyphCharIndex = -1;
    private float lastLayoutX = 0.0f;
    private float lastLayoutY = 0.0f;
    private boolean parsed = false;
    private boolean paused = false;
    private boolean ended = false;
    private boolean skipping = false;
    private boolean ignoringEvents = false;
    private boolean ignoringEffects = false;
    private String defaultToken = "";

    public FLabel(CharSequence text) {
        super(text);
        this.saveOriginalText();
    }

    @Override
    public void setText(CharSequence newText) {
        this.setText(newText, true);
    }

    protected void setText(CharSequence newText, boolean modifyOriginalText) {
        super.setText(newText);
        if (modifyOriginalText && this.originalText != null) {
            this.saveOriginalText();
        }
    }

    public StringBuilder getOriginalText() {
        return this.originalText;
    }

    protected void saveOriginalText() {
        this.originalText.setLength(0);
        this.originalText.insert(0, this.getText());
        this.originalText.trimToSize();
    }

    protected void restoreOriginalText() {
        super.setText(this.originalText);
        this.parsed = false;
    }

    public FListener getTypingListener() {
        return this.listener;
    }

    public void setTypingListener(FListener listener) {
        this.listener = listener;
    }

    public Color getClearColor() {
        return this.clearColor;
    }

    public void setForceMarkupColor(boolean forceMarkupColor) {
        this.forceMarkupColor = forceMarkupColor;
    }

    public String getDefaultToken() {
        return this.defaultToken;
    }

    public void setDefaultToken(String defaultToken) {
        this.defaultToken = defaultToken == null ? "" : defaultToken;
        this.parsed = false;
    }

    public void parseTokens() {
        this.setText(this.getDefaultToken() + this.getText(), false);
        FParser.parseTokens(this);
        this.parsed = true;
    }

    public void skipToTheEnd() {
        this.skipToTheEnd(true);
    }

    public void skipToTheEnd(boolean ignoreEvents) {
        this.skipToTheEnd(ignoreEvents, false);
    }

    public void skipToTheEnd(boolean ignoreEvents, boolean ignoreEffects) {
        this.skipping = true;
        this.ignoringEvents = ignoreEvents;
        this.ignoringEffects = ignoreEffects;
    }

    public void cancelSkipping() {
        if (this.skipping) {
            this.skipping = false;
            this.ignoringEvents = false;
            this.ignoringEffects = false;
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }

    public boolean hasEnded() {
        return this.ended;
    }

    public void restart() {
        this.restart(this.getOriginalText());
    }

    public void restart(CharSequence newText) {
        Pools.freeAll(this.glyphCache);
        this.glyphCache.clear();
        this.glyphRunCapacities.clear();
        this.offsetCache.clear();
        this.layoutLineBreaks.clear();
        this.activeEffects.clear();
        this.charCooldown = this.textSpeed = FConfig.defaultSpeedPerChar;
        this.rawCharIndex = -2;
        this.glyphCharIndex = -1;
        this.glyphCharCompensation = 0;
        this.cachedGlyphCharIndex = -1;
        this.lastLayoutX = 0.0f;
        this.lastLayoutY = 0.0f;
        this.parsed = false;
        this.paused = false;
        this.ended = false;
        this.skipping = false;
        this.ignoringEvents = false;
        this.ignoringEffects = false;
        this.setText(newText);
        this.invalidate();
        this.tokenEntries.clear();
        this.parseTokens();
    }

    public ObjectMap<String, String> getVariables() {
        return this.variables;
    }

    public void setVariable(String var, String value) {
        this.variables.put(var.toUpperCase(), value);
    }

    public void setVariables(ObjectMap<String, String> variableMap) {
        this.variables.clear();
        variableMap.each((key, val) -> this.variables.put(key.toUpperCase(), (String)val));
    }

    public void clearVariables() {
        this.variables.clear();
    }

    @Override
    public void act(float delta) {
        int i;
        block10: {
            block11: {
                float f;
                super.act(delta);
                if (!this.parsed) {
                    this.parseTokens();
                }
                if (!this.skipping && (this.ended || this.paused)) break block10;
                if (this.skipping) break block11;
                this.charCooldown -= delta;
                if (!(f < 0.0f)) break block10;
            }
            this.processCharProgression();
        }
        if (this.activeEffects.size > 0) {
            for (i = 0; i < this.glyphCache.size; ++i) {
                FGlyph glyph = this.glyphCache.get(i);
                glyph.xoffset = this.offsetCache.get(i * 2);
                glyph.yoffset = this.offsetCache.get(i * 2 + 1);
            }
        }
        if (!this.ignoringEffects) {
            for (i = this.activeEffects.size - 1; i >= 0; --i) {
                int end;
                FEffect effect = this.activeEffects.get(i);
                effect.update(delta);
                int start = effect.indexStart;
                int n = end = effect.indexEnd >= 0 ? effect.indexEnd : this.glyphCharIndex;
                if (effect.isFinished()) {
                    this.activeEffects.remove(i);
                    continue;
                }
                for (int j = Math.max(0, start); j <= this.glyphCharIndex && j <= end && j < this.glyphCache.size; ++j) {
                    FGlyph glyph = this.glyphCache.get(j);
                    effect.apply(this, glyph, j, delta);
                }
            }
        }
    }

    private void processCharProgression() {
        int charCounter = 0;
        while (this.skipping || this.charCooldown < 0.0f) {
            int textLen;
            if (this.glyphCharCompensation != 0) {
                if (this.glyphCharCompensation > 0) {
                    ++this.glyphCharIndex;
                    --this.glyphCharCompensation;
                } else {
                    --this.glyphCharIndex;
                    ++this.glyphCharCompensation;
                }
                this.charCooldown += this.textSpeed;
                continue;
            }
            ++this.rawCharIndex;
            int safeIndex = Mathf.clamp(this.glyphCharIndex + 1, 0, this.glyphCache.size - 1);
            char primitiveChar = '\u0000';
            if (this.glyphCache.size > 0) {
                primitiveChar = (char)this.glyphCache.get((int)safeIndex).id;
                float intervalMultiplier = FConfig.intervalMultipliersByChar.get(Character.valueOf(primitiveChar), 1.0f);
                this.charCooldown += this.textSpeed * intervalMultiplier;
            }
            if ((textLen = this.getText().length()) == 0 || this.rawCharIndex >= textLen) {
                if (!this.ended) {
                    this.ended = true;
                    this.skipping = false;
                    if (this.listener != null) {
                        this.listener.end();
                    }
                }
                return;
            }
            boolean isLayoutLineBreak = false;
            if (this.layoutLineBreaks.contains(this.glyphCharIndex)) {
                this.layoutLineBreaks.removeValue(this.glyphCharIndex);
                isLayoutLineBreak = true;
            }
            if (this.rawCharIndex >= 0 && primitiveChar != '\n' && !isLayoutLineBreak) {
                ++this.glyphCharIndex;
            }
            block8: while (this.tokenEntries.size > 0 && this.tokenEntries.peek().index == this.rawCharIndex) {
                FParser.TokenEntry entry = this.tokenEntries.pop();
                String token = entry.token;
                FParser.TokenCategory category = entry.category;
                switch (category) {
                    case speed: {
                        this.textSpeed = entry.floatValue;
                        continue block8;
                    }
                    case wait: {
                        --this.glyphCharIndex;
                        ++this.glyphCharCompensation;
                        this.charCooldown += entry.floatValue;
                        continue block8;
                    }
                    case skip: {
                        if (entry.stringValue == null) continue block8;
                        this.rawCharIndex += entry.stringValue.length();
                        continue block8;
                    }
                    case event: {
                        if (this.listener == null || this.ignoringEvents) continue block8;
                        this.listener.event(entry.stringValue);
                        continue block8;
                    }
                    case effectStart: 
                    case effectEnd: {
                        boolean isStart = category == FParser.TokenCategory.effectStart;
                        for (int i = 0; i < this.activeEffects.size; ++i) {
                            FEffect effect = this.activeEffects.get(i);
                            if (effect.indexEnd >= 0 || !effect.endToken.equals(token)) continue;
                            effect.indexEnd = this.glyphCharIndex - 1;
                        }
                        if (!isStart) continue block8;
                        entry.effect.indexStart = this.glyphCharIndex;
                        this.activeEffects.add(entry.effect);
                        continue block8;
                    }
                }
            }
            ++charCounter;
            if (this.glyphCharIndex == -1) {
                this.charCooldown = this.textSpeed;
                break;
            }
            int charLimit = FConfig.charLimitPerFrame;
            if (this.skipping || charLimit <= 0 || ++charCounter <= charLimit) continue;
            this.charCooldown = this.textSpeed;
            break;
        }
    }

    @Override
    public boolean remove() {
        Pools.freeAll(this.glyphCache);
        this.glyphCache.clear();
        return super.remove();
    }

    @Override
    public void layout() {
        float prefHeight;
        boolean wrap;
        FontCache cache = this.getFontCache();
        StringBuilder text = this.getText();
        GlyphLayout layout = super.getGlyphLayout();
        int lineAlign = this.getLineAlign();
        int labelAlign = this.getLabelAlign();
        Label.LabelStyle style = this.getStyle();
        Font font = cache.getFont();
        float oldScaleX = font.getScaleX();
        float oldScaleY = font.getScaleY();
        if (this.fontScaleChanged) {
            font.getData().setScale(this.getFontScaleX(), this.getFontScaleY());
        }
        boolean bl = wrap = this.wrap && this.ellipsis == null;
        if (wrap && (prefHeight = this.getPrefHeight()) != this.lastPrefHeight) {
            this.lastPrefHeight = prefHeight;
            this.invalidateHierarchy();
        }
        float width = this.getWidth();
        float height = this.getHeight();
        Drawable background = style.background;
        float x = 0.0f;
        float y = 0.0f;
        if (background != null) {
            x = background.getLeftWidth();
            y = background.getBottomHeight();
            width -= background.getLeftWidth() + background.getRightWidth();
            height -= background.getBottomHeight() + background.getTopHeight();
        }
        layout.setText(font, text, 0, text.length(), Color.white, width, lineAlign, wrap, this.ellipsis);
        float textWidth = layout.width;
        float textHeight = layout.height;
        if ((labelAlign & 8) == 0) {
            x = (labelAlign & 0x10) != 0 ? (x += width - textWidth) : (x += (width - textWidth) / 2.0f);
        }
        if ((labelAlign & 2) != 0) {
            y += cache.getFont().isFlipped() ? 0.0f : height - textHeight;
            y += style.font.getDescent();
        } else if ((labelAlign & 4) != 0) {
            y += cache.getFont().isFlipped() ? height - textHeight : 0.0f;
            y -= style.font.getDescent();
        } else {
            y += (height - textHeight) / 2.0f;
        }
        if (!cache.getFont().isFlipped()) {
            y += textHeight;
        }
        if (this.fontScaleChanged) {
            font.getData().setScale(oldScaleX, oldScaleY);
        }
        this.lastLayoutX = x;
        this.lastLayoutY = y;
        Pools.freeAll(this.glyphCache);
        this.glyphCache.clear();
        this.layoutCache();
    }

    private void layoutCache() {
        int j;
        Seq<Font.Glyph> glyphs;
        FontCache cache = this.getFontCache();
        GlyphLayout layout = super.getGlyphLayout();
        Seq<GlyphLayout.GlyphRun> runs = layout.runs;
        this.layoutLineBreaks.clear();
        int glyphCount = 0;
        this.glyphRunCapacities.setSize(runs.size);
        for (int i = 0; i < runs.size; ++i) {
            Seq<Font.Glyph> glyphs2 = runs.get((int)i).glyphs;
            this.glyphRunCapacities.set(i, glyphs2.size);
            glyphCount += glyphs2.size;
        }
        if (this.glyphCache.size < glyphCount) {
            this.glyphCache.setSize(glyphCount);
            this.offsetCache.setSize(glyphCount * 2);
        }
        int index = -1;
        float lastY = 0.0f;
        for (int i = 0; i < runs.size; ++i) {
            GlyphLayout.GlyphRun run = runs.get(i);
            glyphs = run.glyphs;
            for (j = 0; j < glyphs.size; ++j) {
                if (!Mathf.equal(run.y, lastY)) {
                    lastY = run.y;
                    this.layoutLineBreaks.add(index);
                }
                Font.Glyph original = glyphs.get(j);
                FGlyph clone = null;
                if (++index < this.glyphCache.size) {
                    clone = this.glyphCache.get(index);
                }
                if (clone == null) {
                    clone = Pools.obtain(FGlyph.class, FGlyph::new);
                    this.glyphCache.set(index, clone);
                }
                clone.set(original);
                clone.width = (int)((float)clone.width * this.getFontScaleX());
                clone.height = (int)((float)clone.height * this.getFontScaleY());
                clone.xoffset = (int)((float)clone.xoffset * this.getFontScaleX());
                clone.yoffset = (int)((float)clone.yoffset * this.getFontScaleY());
                clone.run = run;
                this.offsetCache.set(index * 2, clone.xoffset);
                this.offsetCache.set(index * 2 + 1, clone.yoffset);
                glyphs.set(j, clone);
            }
        }
        int glyphCountdown = this.glyphCharIndex;
        block3: for (int i = 0; i < runs.size; ++i) {
            glyphs = runs.get((int)i).glyphs;
            if (glyphs.size < glyphCountdown) {
                glyphCountdown -= glyphs.size;
                continue;
            }
            for (j = 0; j < glyphs.size; ++j) {
                if (glyphCountdown < 0) {
                    glyphs.removeRange(j, glyphs.size - 1);
                    continue block3;
                }
                --glyphCountdown;
            }
        }
        cache.setText(layout, this.lastLayoutX, this.lastLayoutY);
    }

    private void addMissingGlyphs() {
        int glyphLeft = this.glyphCharIndex - this.cachedGlyphCharIndex;
        if (glyphLeft < 1) {
            return;
        }
        GlyphLayout layout = super.getGlyphLayout();
        Seq<GlyphLayout.GlyphRun> runs = layout.runs;
        int glyphCount = 0;
        for (int runIndex = 0; runIndex < this.glyphRunCapacities.size; ++runIndex) {
            int runSize;
            int runCapacity = this.glyphRunCapacities.get(runIndex);
            if (glyphCount + runCapacity < this.cachedGlyphCharIndex) {
                glyphCount += runCapacity;
                continue;
            }
            Seq<Font.Glyph> glyphs = runs.get((int)runIndex).glyphs;
            glyphCount += glyphs.size;
            while (glyphLeft > 0 && runCapacity != (runSize = glyphs.size)) {
                ++this.cachedGlyphCharIndex;
                FGlyph glyph = this.glyphCache.get(this.cachedGlyphCharIndex);
                glyphs.add(glyph);
                glyph.internalIndex = glyphCount++;
                --glyphLeft;
                if (this.listener == null) continue;
                this.listener.onChar((char)glyph.id);
            }
        }
    }

    @Override
    public void draw() {
        super.validate();
        this.addMissingGlyphs();
        FontCache FontCache2 = this.getFontCache();
        this.getFontCache().setText(this.getGlyphLayout(), this.lastLayoutX, this.lastLayoutY);
        for (FGlyph glyph : this.glyphCache) {
            if (glyph.internalIndex < 0 || glyph.color == null) continue;
            FontCache2.setColors(glyph.color, glyph.internalIndex, glyph.internalIndex + 1);
        }
        super.draw();
    }
}

