/*
 * Decompiled with CFR 0.152.
 */
package arc.files;

import arc.Core;
import arc.Files;
import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.Pixmap;
import arc.graphics.PixmapIO;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import arc.util.OS;
import arc.util.io.Reads;
import arc.util.io.Streams;
import arc.util.io.Writes;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class Fi {
    protected File file;
    protected Files.FileType type;

    protected Fi() {
    }

    public Fi(String fileName) {
        this.file = new File(fileName);
        this.type = Files.FileType.absolute;
    }

    public Fi(File file) {
        this.file = file;
        this.type = Files.FileType.absolute;
    }

    public Fi(String fileName, Files.FileType type) {
        this.type = type;
        this.file = new File(fileName);
    }

    protected Fi(File file, Files.FileType type) {
        this.file = file;
        this.type = type;
    }

    public static Fi get(String path) {
        return new Fi(path);
    }

    public static Fi tempFile(String prefix) {
        try {
            return new Fi(File.createTempFile(prefix, null));
        }
        catch (IOException ex) {
            throw new ArcRuntimeException("Unable to create temp file.", ex);
        }
    }

    public static Fi tempDirectory(String prefix) {
        try {
            File file = File.createTempFile(prefix, null);
            if (!file.delete()) {
                throw new IOException("Unable to delete temp file: " + file);
            }
            if (!file.mkdir()) {
                throw new IOException("Unable to create temp directory: " + file);
            }
            return new Fi(file);
        }
        catch (IOException ex) {
            throw new ArcRuntimeException("Unable to create temp file.", ex);
        }
    }

    private static void emptyDirectory(File file, boolean preserveTree) {
        File[] files;
        if (file.exists() && (files = file.listFiles()) != null) {
            for (File value : files) {
                if (!value.isDirectory()) {
                    value.delete();
                    continue;
                }
                if (preserveTree) {
                    Fi.emptyDirectory(value, true);
                    continue;
                }
                Fi.deleteDirectory(value);
            }
        }
    }

    private static boolean deleteDirectory(File file) {
        Fi.emptyDirectory(file, false);
        return file.delete();
    }

    private static void copyFile(Fi source, Fi dest) {
        try {
            dest.write(source.read(), false);
        }
        catch (Exception ex) {
            throw new ArcRuntimeException("Error copying source file: " + source.file + " (" + (Object)((Object)source.type) + ")\nTo destination: " + dest.file + " (" + (Object)((Object)dest.type) + ")", ex);
        }
    }

    private static void copyDirectory(Fi sourceDir, Fi destDir) {
        Fi[] files;
        destDir.mkdirs();
        for (Fi srcFile : files = sourceDir.list()) {
            Fi destFile = destDir.child(srcFile.name());
            if (srcFile.isDirectory()) {
                Fi.copyDirectory(srcFile, destFile);
                continue;
            }
            Fi.copyFile(srcFile, destFile);
        }
    }

    public String path() {
        return this.file.getPath().replace('\\', '/');
    }

    public String absolutePath() {
        return this.file.getAbsolutePath().replace('\\', '/');
    }

    public String name() {
        return this.file.getName().isEmpty() ? this.file.getPath() : this.file.getName();
    }

    public boolean extEquals(String ext) {
        return this.extension().equalsIgnoreCase(ext);
    }

    public String extension() {
        String name = this.file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return "";
        }
        return name.substring(dotIndex + 1);
    }

    public String nameWithoutExtension() {
        String name = this.file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return name;
        }
        return name.substring(0, dotIndex);
    }

    public String pathWithoutExtension() {
        String path = this.file.getPath().replace('\\', '/');
        int dotIndex = path.lastIndexOf(46);
        if (dotIndex == -1) {
            return path;
        }
        return path.substring(0, dotIndex);
    }

    public Files.FileType type() {
        return this.type;
    }

    public File file() {
        if (this.type == Files.FileType.external) {
            return new File(Core.files.getExternalStoragePath(), this.file.getPath());
        }
        return this.file;
    }

    public InputStream read() {
        if (this.type == Files.FileType.classpath || this.type == Files.FileType.internal && !this.file().exists() || this.type == Files.FileType.local && !this.file().exists()) {
            InputStream input = Fi.class.getResourceAsStream("/" + this.file.getPath().replace('\\', '/'));
            if (input == null) {
                throw new ArcRuntimeException("File not found: " + this.file + " (" + (Object)((Object)this.type) + ")");
            }
            return input;
        }
        try {
            return new FileInputStream(this.file());
        }
        catch (Exception ex) {
            if (this.file().isDirectory()) {
                throw new ArcRuntimeException("Cannot open a stream to a directory: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
            }
            throw new ArcRuntimeException("Error reading file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
        }
    }

    public BufferedInputStream read(int bufferSize) {
        return new BufferedInputStream(this.read(), bufferSize);
    }

    public Reader reader() {
        return this.reader("UTF-8");
    }

    public Reader reader(String charset) {
        InputStream stream = this.read();
        try {
            return new InputStreamReader(stream, charset);
        }
        catch (UnsupportedEncodingException ex) {
            Streams.close(stream);
            throw new ArcRuntimeException("Error reading file: " + this, ex);
        }
    }

    public BufferedReader reader(int bufferSize) {
        return this.reader(bufferSize, "UTF-8");
    }

    public BufferedReader reader(int bufferSize, String charset) {
        try {
            return new BufferedReader(new InputStreamReader(this.read(), charset), bufferSize);
        }
        catch (UnsupportedEncodingException ex) {
            throw new ArcRuntimeException("Error reading file: " + this, ex);
        }
    }

    public String readString() {
        return this.readString("UTF-8");
    }

    public String readString(String charset) {
        StringBuilder output = new StringBuilder(this.estimateLength());
        InputStreamReader reader = null;
        try {
            int length;
            reader = charset == null ? new InputStreamReader(this.read()) : new InputStreamReader(this.read(), charset);
            char[] buffer = new char[256];
            while ((length = reader.read(buffer)) != -1) {
                output.append(buffer, 0, length);
            }
        }
        catch (IOException ex) {
            try {
                throw new ArcRuntimeException("Error reading layout file: " + this, ex);
            }
            catch (Throwable throwable) {
                Streams.close(reader);
                throw throwable;
            }
        }
        Streams.close(reader);
        return output.toString();
    }

    public byte[] readBytes() {
        InputStream input = this.read();
        try {
            byte[] byArray = Streams.copyBytes(input, this.estimateLength());
            return byArray;
        }
        catch (IOException ex) {
            throw new ArcRuntimeException("Error reading file: " + this, ex);
        }
        finally {
            Streams.close(input);
        }
    }

    public ByteArrayInputStream readByteStream() {
        return new ByteArrayInputStream(this.readBytes());
    }

    private int estimateLength() {
        int length = (int)this.length();
        return length != 0 ? length : 512;
    }

    public int readBytes(byte[] bytes, int offset, int size) {
        InputStream input = this.read();
        int position = 0;
        try {
            int count;
            while ((count = input.read(bytes, offset + position, size - position)) > 0) {
                position += count;
            }
        }
        catch (IOException ex) {
            throw new ArcRuntimeException("Error reading file: " + this, ex);
        }
        finally {
            Streams.close(input);
        }
        return position - offset;
    }

    public ByteBuffer map() {
        return this.map(FileChannel.MapMode.READ_ONLY);
    }

    public ByteBuffer map(FileChannel.MapMode mode) {
        MappedByteBuffer mappedByteBuffer;
        if (this.type == Files.FileType.classpath) {
            throw new ArcRuntimeException("Cannot map a classpath file: " + this);
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.file, mode == FileChannel.MapMode.READ_ONLY ? "r" : "rw");
            FileChannel fileChannel = raf.getChannel();
            MappedByteBuffer map = fileChannel.map(mode, 0L, this.file.length());
            map.order(ByteOrder.nativeOrder());
            mappedByteBuffer = map;
        }
        catch (Exception ex) {
            try {
                throw new ArcRuntimeException("Error memory mapping file: " + this + " (" + (Object)((Object)this.type) + ")", ex);
            }
            catch (Throwable throwable) {
                Streams.close(raf);
                throw throwable;
            }
        }
        Streams.close(raf);
        return mappedByteBuffer;
    }

    public Writes writes(boolean append) {
        return new Writes(new DataOutputStream(this.write(append, 8192)));
    }

    public Writes writes() {
        return this.writes(false);
    }

    public Reads reads() {
        return new Reads(new DataInputStream(this.read(8192)));
    }

    public Writes writesDeflate() {
        return new Writes(new DataOutputStream(new DeflaterOutputStream(this.write(false, 8192))));
    }

    public Reads readsDeflate() {
        return new Reads(new DataInputStream(new InflaterInputStream(this.read(8192))));
    }

    public OutputStream write() {
        return this.write(false);
    }

    public OutputStream write(boolean append) {
        if (this.type == Files.FileType.classpath) {
            throw new ArcRuntimeException("Cannot write to a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.internal) {
            throw new ArcRuntimeException("Cannot write to an internal file: " + this.file);
        }
        this.parent().mkdirs();
        try {
            return new FileOutputStream(this.file(), append);
        }
        catch (Exception ex) {
            if (this.file().isDirectory()) {
                throw new ArcRuntimeException("Cannot open a stream to a directory: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
            }
            throw new ArcRuntimeException("Error writing file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
        }
    }

    public OutputStream write(boolean append, int bufferSize) {
        return new BufferedOutputStream(this.write(append), bufferSize);
    }

    public void write(InputStream input, boolean append) {
        OutputStream output = null;
        try {
            output = this.write(append);
            Streams.copy(input, output);
        }
        catch (Exception ex) {
            throw new ArcRuntimeException("Error stream writing to file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
        }
        finally {
            Streams.close(input);
            Streams.close(output);
        }
    }

    public Writer writer(boolean append) {
        return this.writer(append, "UTF-8");
    }

    public Writer writer(boolean append, String charset) {
        if (this.type == Files.FileType.classpath) {
            throw new ArcRuntimeException("Cannot write to a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.internal) {
            throw new ArcRuntimeException("Cannot write to an internal file: " + this.file);
        }
        this.parent().mkdirs();
        try {
            FileOutputStream output = new FileOutputStream(this.file(), append);
            if (charset == null) {
                return new OutputStreamWriter(output);
            }
            return new OutputStreamWriter((OutputStream)output, charset);
        }
        catch (IOException ex) {
            if (this.file().isDirectory()) {
                throw new ArcRuntimeException("Cannot open a stream to a directory: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
            }
            throw new ArcRuntimeException("Error writing file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
        }
    }

    public void writePng(Pixmap pixmap) {
        PixmapIO.writePng(this, pixmap);
    }

    public void writeString(String string) {
        this.writeString(string, false);
    }

    public void writeString(String string, boolean append) {
        this.writeString(string, append, "UTF-8");
    }

    public void writeString(String string, boolean append, String charset) {
        Writer writer = null;
        try {
            writer = this.writer(append, charset);
            writer.write(string);
        }
        catch (Exception ex) {
            try {
                throw new ArcRuntimeException("Error writing file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
            }
            catch (Throwable throwable) {
                Streams.close(writer);
                throw throwable;
            }
        }
        Streams.close(writer);
    }

    public void writeBytes(byte[] bytes) {
        this.writeBytes(bytes, false);
    }

    public void writeBytes(byte[] bytes, boolean append) {
        OutputStream output = this.write(append);
        try {
            output.write(bytes);
        }
        catch (IOException ex) {
            throw new ArcRuntimeException("Error writing file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
        }
        finally {
            Streams.close(output);
        }
    }

    public void writeBytes(byte[] bytes, int offset, int length, boolean append) {
        OutputStream output = this.write(append);
        try {
            output.write(bytes, offset, length);
        }
        catch (IOException ex) {
            throw new ArcRuntimeException("Error writing file: " + this.file + " (" + (Object)((Object)this.type) + ")", ex);
        }
        finally {
            Streams.close(output);
        }
    }

    public void walk(Cons<Fi> cons) {
        if (this.isDirectory()) {
            for (Fi file : this.list()) {
                file.walk(cons);
            }
        } else {
            cons.get(this);
        }
    }

    public Seq<Fi> findAll(Boolf<Fi> test) {
        Seq<Fi> out = new Seq<Fi>();
        this.walk(f -> {
            if (test.get((Fi)f)) {
                out.add((Fi)f);
            }
        });
        return out;
    }

    public Seq<Fi> findAll() {
        Seq<Fi> out = new Seq<Fi>();
        this.walk(out::add);
        return out;
    }

    public Seq<Fi> seq() {
        return Seq.with(this.list());
    }

    public Fi[] list() {
        if (this.type == Files.FileType.classpath) {
            throw new ArcRuntimeException("Cannot list a classpath directory: " + this.file);
        }
        String[] relativePaths = this.file().list();
        if (relativePaths == null) {
            return new Fi[0];
        }
        Fi[] handles = new Fi[relativePaths.length];
        int n = relativePaths.length;
        for (int i = 0; i < n; ++i) {
            handles[i] = this.child(relativePaths[i]);
        }
        return handles;
    }

    public Fi[] list(FileFilter filter) {
        if (this.type == Files.FileType.classpath) {
            throw new ArcRuntimeException("Cannot list a classpath directory: " + this.file);
        }
        File file = this.file();
        String[] relativePaths = file.list();
        if (relativePaths == null) {
            return new Fi[0];
        }
        Fi[] handles = new Fi[relativePaths.length];
        int count = 0;
        for (String path : relativePaths) {
            Fi child = this.child(path);
            if (!filter.accept(child.file())) continue;
            handles[count] = child;
            ++count;
        }
        if (count < relativePaths.length) {
            Fi[] newHandles = new Fi[count];
            System.arraycopy(handles, 0, newHandles, 0, count);
            handles = newHandles;
        }
        return handles;
    }

    public Fi[] list(FilenameFilter filter) {
        if (this.type == Files.FileType.classpath) {
            throw new ArcRuntimeException("Cannot list a classpath directory: " + this.file);
        }
        File file = this.file();
        String[] relativePaths = file.list();
        if (relativePaths == null) {
            return new Fi[0];
        }
        Fi[] handles = new Fi[relativePaths.length];
        int count = 0;
        for (String path : relativePaths) {
            if (!filter.accept(file, path)) continue;
            handles[count] = this.child(path);
            ++count;
        }
        if (count < relativePaths.length) {
            Fi[] newHandles = new Fi[count];
            System.arraycopy(handles, 0, newHandles, 0, count);
            handles = newHandles;
        }
        return handles;
    }

    public Fi[] list(String suffix) {
        if (this.type == Files.FileType.classpath) {
            throw new ArcRuntimeException("Cannot list a classpath directory: " + this.file);
        }
        String[] relativePaths = this.file().list();
        if (relativePaths == null) {
            return new Fi[0];
        }
        Fi[] handles = new Fi[relativePaths.length];
        int count = 0;
        for (String path : relativePaths) {
            if (!path.endsWith(suffix)) continue;
            handles[count] = this.child(path);
            ++count;
        }
        if (count < relativePaths.length) {
            Fi[] newHandles = new Fi[count];
            System.arraycopy(handles, 0, newHandles, 0, count);
            handles = newHandles;
        }
        return handles;
    }

    public boolean isDirectory() {
        if (this.type == Files.FileType.classpath) {
            return false;
        }
        return this.file().isDirectory();
    }

    public Fi child(String name) {
        if (this.file.getPath().length() == 0) {
            return new Fi(new File(name), this.type);
        }
        return new Fi(new File(this.file, name), this.type);
    }

    public Fi sibling(String name) {
        if (this.file.getPath().length() == 0) {
            throw new ArcRuntimeException("Cannot get the sibling of the root.");
        }
        return new Fi(new File(this.file.getParent(), name), this.type);
    }

    public Fi parent() {
        File parent = this.file.getParentFile();
        if (parent == null) {
            if (OS.isWindows) {
                return new Fi("", this.type){
                    Fi[] children;
                    {
                        this.children = (Fi[])Seq.with(File.listRoots()).map(Fi::new).toArray(Fi.class);
                    }

                    @Override
                    public Fi parent() {
                        return this;
                    }

                    @Override
                    public boolean isDirectory() {
                        return true;
                    }

                    @Override
                    public boolean exists() {
                        return true;
                    }

                    @Override
                    public Fi child(String name) {
                        return new Fi(new File(name));
                    }

                    @Override
                    public Fi[] list() {
                        return this.children;
                    }

                    @Override
                    public Fi[] list(FileFilter filter) {
                        return (Fi[])Seq.select(this.list(), f -> filter.accept(f.file)).toArray(Fi.class);
                    }
                };
            }
            parent = this.type == Files.FileType.absolute ? new File("/") : new File("");
        }
        return new Fi(parent, this.type);
    }

    public boolean mkdirs() {
        if (this.type == Files.FileType.classpath) {
            throw new ArcRuntimeException("Cannot mkdirs with a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.internal) {
            throw new ArcRuntimeException("Cannot mkdirs with an internal file: " + this.file);
        }
        return this.file().mkdirs();
    }

    public boolean exists() {
        switch (this.type) {
            case internal: {
                if (this.file().exists()) {
                    return true;
                }
            }
            case classpath: {
                return Fi.class.getResource("/" + this.file.getPath().replace('\\', '/')) != null;
            }
        }
        return this.file().exists();
    }

    public boolean delete() {
        if (this.type == Files.FileType.classpath) {
            throw new ArcRuntimeException("Cannot delete a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.internal) {
            throw new ArcRuntimeException("Cannot delete an internal file: " + this.file);
        }
        return this.file().delete();
    }

    public boolean deleteDirectory() {
        if (this.type == Files.FileType.classpath) {
            throw new ArcRuntimeException("Cannot delete a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.internal) {
            throw new ArcRuntimeException("Cannot delete an internal file: " + this.file);
        }
        return Fi.deleteDirectory(this.file());
    }

    public void emptyDirectory() {
        this.emptyDirectory(false);
    }

    public void emptyDirectory(boolean preserveTree) {
        if (this.type == Files.FileType.classpath) {
            throw new ArcRuntimeException("Cannot delete a classpath file: " + this.file);
        }
        if (this.type == Files.FileType.internal) {
            throw new ArcRuntimeException("Cannot delete an internal file: " + this.file);
        }
        Fi.emptyDirectory(this.file(), preserveTree);
    }

    public void copyTo(Fi dest) {
        if (!this.isDirectory()) {
            if (dest.isDirectory()) {
                dest = dest.child(this.name());
            }
            Fi.copyFile(this, dest);
            return;
        }
        if (dest.exists()) {
            if (!dest.isDirectory()) {
                throw new ArcRuntimeException("Destination exists but is not a directory: " + dest);
            }
        } else {
            dest.mkdirs();
            if (!dest.isDirectory()) {
                throw new ArcRuntimeException("Destination directory cannot be created: " + dest);
            }
        }
        Fi.copyDirectory(this, dest.child(this.name()));
    }

    public void copyFilesTo(Fi dest) {
        if (!this.isDirectory()) {
            throw new ArcRuntimeException("Source folder must be a directory: " + this);
        }
        if (dest.exists() && !dest.isDirectory()) {
            throw new ArcRuntimeException("Destination folder must be a directory: " + dest);
        }
        dest.mkdirs();
        Fi.copyDirectory(this, dest);
    }

    public void moveTo(Fi dest) {
        switch (this.type) {
            case classpath: {
                throw new ArcRuntimeException("Cannot move a classpath file: " + this.file);
            }
            case internal: {
                throw new ArcRuntimeException("Cannot move an internal file: " + this.file);
            }
            case absolute: 
            case external: {
                if (!this.file().renameTo(dest.file())) break;
                return;
            }
        }
        this.copyTo(dest);
        this.delete();
        if (this.exists() && this.isDirectory()) {
            this.deleteDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() {
        if (this.type == Files.FileType.classpath || this.type == Files.FileType.internal && !this.file.exists()) {
            InputStream input = this.read();
            try {
                long l = input.available();
                return l;
            }
            catch (Exception exception) {
            }
            finally {
                Streams.close(input);
            }
            return 0L;
        }
        return this.file().length();
    }

    public long lastModified() {
        return this.file().lastModified();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Fi)) {
            return false;
        }
        Fi other = (Fi)obj;
        return this.type == other.type && this.path().equals(other.path());
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 37 + this.type.hashCode();
        hash = hash * 67 + this.path().hashCode();
        return hash;
    }

    public String toString() {
        return this.file.getPath().replace('\\', '/');
    }
}

