/*
 * Decompiled with CFR 0.152.
 */
package arc.backend.sdl;

import arc.Application;
import arc.ApplicationListener;
import arc.Core;
import arc.Settings;
import arc.audio.Audio;
import arc.backend.sdl.SdlConfig;
import arc.backend.sdl.SdlFiles;
import arc.backend.sdl.SdlGraphics;
import arc.backend.sdl.SdlInput;
import arc.backend.sdl.jni.SDL;
import arc.files.Fi;
import arc.func.Cons;
import arc.graphics.Pixmap;
import arc.math.geom.Vec2;
import arc.scene.ui.TextField;
import arc.struct.Seq;
import arc.util.ArcNativesLoader;
import arc.util.Log;
import arc.util.OS;
import arc.util.Reflect;
import arc.util.Strings;
import arc.util.TaskQueue;
import arc.util.Threads;
import arc.util.Tmp;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;

public class SdlApplication
implements Application {
    private final Seq<ApplicationListener> listeners = new Seq();
    private final TaskQueue runnables = new TaskQueue();
    private final int[] inputs = new int[64];
    final SdlGraphics graphics;
    final SdlInput input;
    final SdlConfig config;
    final Thread mainThread;
    boolean running = true;
    long window;
    long context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SdlApplication(ApplicationListener listener, SdlConfig config) {
        this.config = config;
        this.listeners.add(listener);
        this.mainThread = Thread.currentThread();
        this.init();
        Core.app = this;
        Core.files = new SdlFiles();
        this.graphics = new SdlGraphics(this);
        Core.graphics = this.graphics;
        this.input = new SdlInput();
        Core.input = this.input;
        Core.settings = new Settings();
        Core.audio = new Audio(!config.disableAudio);
        this.initIcon();
        this.graphics.updateSize(config.width, config.height);
        if (!OS.isMac) {
            this.addTextInputListener();
        }
        try {
            this.loop();
            this.listen(ApplicationListener::exit);
        }
        finally {
            try {
                this.cleanup();
            }
            catch (Throwable error) {
                error.printStackTrace();
            }
        }
    }

    private void addTextInputListener() {
        this.addListener(new ApplicationListener(){
            TextField lastFocus;

            @Override
            public void update() {
                if (Core.scene != null && Core.scene.getKeyboardFocus() instanceof TextField) {
                    TextField next = (TextField)Core.scene.getKeyboardFocus();
                    if (this.lastFocus == null) {
                        SDL.SDL_StartTextInput();
                    }
                    this.lastFocus = next;
                } else if (this.lastFocus != null) {
                    SDL.SDL_StopTextInput();
                    this.lastFocus = null;
                }
                if (this.lastFocus != null) {
                    Vec2 pos = this.lastFocus.localToStageCoordinates(Tmp.v1.setZero());
                    SDL.SDL_SetTextInputRect((int)pos.x, Core.graphics.getHeight() - 1 - (int)(pos.y + this.lastFocus.getHeight()), (int)this.lastFocus.getWidth(), (int)this.lastFocus.getHeight());
                }
            }
        });
    }

    private void initIcon() {
        if (this.config.windowIconPaths != null && this.config.windowIconPaths.length > 0) {
            String path = this.config.windowIconPaths[0];
            try {
                Pixmap p = new Pixmap(Core.files.get(path, this.config.windowIconFileType));
                long surface = SDL.SDL_CreateRGBSurfaceFrom(p.pixels, p.width, p.height);
                SDL.SDL_SetWindowIcon(this.window, surface);
                SDL.SDL_FreeSurface(surface);
                p.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void init() {
        block18: {
            ArcNativesLoader.load();
            if (OS.isMac) {
                this.restartMac();
            }
            this.check(SDL.SDL_Init(16416));
            SDL.SDL_SetHint("SDL_IME_SHOW_UI", "1");
            SDL.SDL_SetHint("SDL_WINDOWS_DPI_SCALING", "1");
            this.check(SDL.SDL_GL_SetAttribute(17, this.config.gl30 ? this.config.gl30Major : 2));
            this.check(SDL.SDL_GL_SetAttribute(18, this.config.gl30 ? this.config.gl30Minor : 0));
            if (this.config.gl30 && (OS.isMac || this.config.coreProfile)) {
                this.check(SDL.SDL_GL_SetAttribute(21, 1));
            }
            this.check(SDL.SDL_GL_SetAttribute(0, this.config.r));
            this.check(SDL.SDL_GL_SetAttribute(1, this.config.g));
            this.check(SDL.SDL_GL_SetAttribute(2, this.config.b));
            this.check(SDL.SDL_GL_SetAttribute(6, this.config.depth));
            this.check(SDL.SDL_GL_SetAttribute(7, this.config.stencil));
            this.check(SDL.SDL_GL_SetAttribute(5, 1));
            if (this.config.samples > 0) {
                this.check(SDL.SDL_GL_SetAttribute(13, 1));
                this.check(SDL.SDL_GL_SetAttribute(14, this.config.samples));
            }
            int flags = 2;
            if (this.config.initialVisible) {
                flags |= 4;
            }
            if (!this.config.decorated) {
                flags |= 0x10;
            }
            if (this.config.resizable) {
                flags |= 0x20;
            }
            if (this.config.maximized) {
                flags |= 0x80;
            }
            if (this.config.fullscreen) {
                flags |= 1;
            }
            this.window = SDL.SDL_CreateWindow(this.config.title, this.config.width, this.config.height, flags);
            if (this.window == 0L) {
                throw new SdlError();
            }
            try {
                this.context = SDL.SDL_GL_CreateContext(this.window);
                if (this.context == 0L) {
                    throw new SdlError();
                }
            }
            catch (SdlError error) {
                if (this.config.gl30) {
                    try {
                        Log.info("Failed to initialize with OpenGL @.@, attempting fallback compatibility context: @", this.config.gl30Major, this.config.gl30Minor, Strings.getSimpleMessage(error));
                        this.check(SDL.SDL_GL_SetAttribute(21, 2));
                        this.check(SDL.SDL_GL_SetAttribute(17, 3));
                        this.check(SDL.SDL_GL_SetAttribute(18, 0));
                        this.context = SDL.SDL_GL_CreateContext(this.window);
                        if (this.context == 0L) {
                            throw new SdlError();
                        }
                    }
                    catch (SdlError error2) {
                        Log.info("Failed to initialize with fallback OpenGL 3.0 context, attempting 2.0 context: @", Strings.getSimpleMessage(error2));
                        this.config.gl30 = false;
                        this.check(SDL.SDL_GL_SetAttribute(17, 2));
                        this.check(SDL.SDL_GL_SetAttribute(18, 0));
                        this.context = SDL.SDL_GL_CreateContext(this.window);
                        if (this.context == 0L) {
                            throw new SdlError();
                        }
                        break block18;
                    }
                }
                throw error;
            }
        }
        if (this.config.vSyncEnabled) {
            SDL.SDL_GL_SetSwapInterval(1);
        }
        int[] ver = new int[3];
        SDL.SDL_GetVersion(ver);
        Log.info("[Core] Initialized SDL v@.@.@", ver[0], ver[1], ver[2]);
    }

    private void loop() {
        this.graphics.updateSize(this.config.width, this.config.height);
        this.listen(ApplicationListener::init);
        while (this.running) {
            while (SDL.SDL_PollEvent(this.inputs)) {
                if (this.inputs[0] == 0) {
                    this.running = false;
                    continue;
                }
                if (this.inputs[0] == 1) {
                    int type = this.inputs[1];
                    if (type == 6) {
                        this.graphics.updateSize(this.inputs[2], this.inputs[3]);
                        this.listen(l -> l.resize(this.inputs[2], this.inputs[3]));
                        continue;
                    }
                    if (type == 12) {
                        this.listen(ApplicationListener::resume);
                        continue;
                    }
                    if (type != 13) continue;
                    this.listen(ApplicationListener::pause);
                    continue;
                }
                if (this.inputs[0] != 2 && this.inputs[0] != 3 && this.inputs[0] != 4 && this.inputs[0] != 5 && this.inputs[0] != 6 && this.inputs[0] != 8) continue;
                this.input.handleInput(this.inputs);
            }
            this.graphics.update();
            this.input.update();
            this.defaultUpdate();
            this.listen(ApplicationListener::update);
            this.runnables.run();
            SDL.SDL_GL_SwapWindow(this.window);
            this.input.postUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen(Cons<ApplicationListener> cons) {
        Seq<ApplicationListener> seq = this.listeners;
        synchronized (seq) {
            for (ApplicationListener l : this.listeners) {
                cons.get(l);
            }
        }
    }

    private void cleanup() {
        this.listen(l -> {
            l.pause();
            try {
                l.dispose();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        });
        this.dispose();
        SDL.SDL_DestroyWindow(this.window);
        SDL.SDL_Quit();
    }

    private void check(int code) {
        if (code != 0) {
            throw new SdlError();
        }
    }

    public long getWindow() {
        return this.window;
    }

    @Override
    public Thread getMainThread() {
        return this.mainThread;
    }

    @Override
    public boolean openFolder(String file) {
        Threads.daemon(() -> {
            if (OS.isWindows) {
                OS.execSafe("explorer.exe /select," + file.replace("/", "\\"));
            } else if (OS.isLinux) {
                OS.execSafe("xdg-open", file);
            } else if (OS.isMac) {
                OS.execSafe("open", file);
            }
        });
        return true;
    }

    @Override
    public boolean openURI(String url) {
        try {
            URI.create(url);
        }
        catch (Exception wrong) {
            return false;
        }
        Threads.daemon(() -> {
            if (OS.isMac) {
                OS.execSafe("open", url);
            } else if (OS.isLinux) {
                OS.execSafe("xdg-open", url);
            } else if (OS.isWindows) {
                OS.execSafe("rundll32", "url.dll,FileProtocolHandler", url);
            }
        });
        return true;
    }

    @Override
    public Seq<ApplicationListener> getListeners() {
        return this.listeners;
    }

    @Override
    public Application.ApplicationType getType() {
        return Application.ApplicationType.desktop;
    }

    @Override
    public String getClipboardText() {
        return SDL.SDL_GetClipboardText();
    }

    @Override
    public void setClipboardText(String text) {
        SDL.SDL_SetClipboardText(text);
    }

    @Override
    public void post(Runnable runnable) {
        this.runnables.post(runnable);
    }

    @Override
    public void exit() {
        this.running = false;
    }

    private void restartMac() {
        try {
            Class<?> mgmt = Class.forName("java.lang.management.ManagementFactory");
            Class<?> beanClass = Class.forName("java.lang.management.RuntimeMXBean");
            Object bean = Reflect.invoke(mgmt, "getRuntimeMXBean");
            String id = ((String)beanClass.getMethod("getName", new Class[0]).invoke(bean, new Object[0])).split("@")[0];
            if (!OS.hasEnv("JAVA_STARTED_ON_FIRST_THREAD_" + id) || OS.env("JAVA_STARTED_ON_FIRST_THREAD_" + id).equals("0")) {
                Log.warn("Applying -XstartOnFirstThread for macOS support.", new Object[0]);
                String javaPath = new Fi(OS.prop("java.home")).child("bin/java").exists() ? new Fi(OS.prop("java.home")).child("bin/java").absolutePath() : (Core.files.local("jre/bin/java").exists() ? Core.files.local("jre/bin/java").absolutePath() : "java");
                try {
                    Fi jar = Fi.get(SdlApplication.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                    Seq<String> launchOptions = Seq.with(javaPath);
                    launchOptions.addAll((List)beanClass.getMethod("getInputArguments", new Class[0]).invoke(bean, new Object[0]));
                    launchOptions.addAll((String[])((String[])System.getProperties().entrySet().stream().map(it -> "-D" + it).toArray(String[]::new)));
                    launchOptions.addAll((String[])new String[]{"-XstartOnFirstThread", "-jar", jar.absolutePath(), "-firstThread"});
                    Process proc = new ProcessBuilder((String[])launchOptions.toArray(String.class)).inheritIO().start();
                    System.exit(proc.waitFor());
                }
                catch (IOException | URISyntaxException e) {
                    Log.err(e);
                    Log.err("Failed to apply the -XstartOnFirstThread argument, it is required in order to work on mac.", new Object[0]);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class SdlError
    extends RuntimeException {
        public SdlError() {
            super(SDL.SDL_GetError());
        }
    }
}

